/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.template.velocity.directives;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.util.engine.CounterEngine;
import org.qubership.automation.itf.core.util.exception.CounterLimitIsExhaustedException;

public class NextIndex
extends Directive {
    public String getName() {
        return "next_index";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i) != null) {
                String counterFormat = String.valueOf(node.jjtGetChild(i).value(internalContextAdapter));
                try {
                    this.rendData(counterFormat, internalContextAdapter, writer);
                    continue;
                }
                catch (CounterLimitIsExhaustedException e) {
                    throw new IOException(e);
                }
            }
            this.rsvc.getLog().warn((Object)"next_index: format is null");
        }
        return true;
    }

    private void rendData(String counterFormat, InternalContextAdapter internalContextAdapter, Writer writer) throws CounterLimitIsExhaustedException {
        Set<Object> owners = this.prepareOwners(internalContextAdapter);
        String index = CounterEngine.getInstance().nextIndex(owners, counterFormat);
        if (index == null) {
            throw new VelocityException("Unable to next index of operation by counter format '" + counterFormat + "' counter not found.");
        }
        this.rsvc.evaluate((Context)internalContextAdapter, writer, "VeLog", index);
    }

    private Set<Object> prepareOwners(InternalContextAdapter internalContextAdapter) {
        HashSet owners = Sets.newHashSet();
        Storable operation = (Storable)Storable.class.cast(internalContextAdapter.getBaseContext().get("___operation___"));
        Storable environment = (Storable)Storable.class.cast(internalContextAdapter.getBaseContext().get("___environment___"));
        if (!Objects.nonNull(operation) || !Objects.nonNull(environment)) {
            throw new VelocityException("Unable to next index by operation. Operation or Environment is null ");
        }
        owners.add(operation.getID());
        owners.add(environment.getID());
        return owners;
    }
}

