/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.template.velocity.directives;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;
import org.qubership.automation.itf.core.util.feign.http.HttpClientFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;

public class GetDsFile
extends Directive {
    private static String getExceptionMessage() {
        return "Directive '#get_ds_file': the 1st argument is $filePath, like '/attachment/a1919c04-8f39-49a1-aae1-ee52c815a221', the 2nd argument is $encoding (optional; 'UTF-8' by default)";
    }

    public String getName() {
        return "get_ds_file";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        String filePath;
        String encoding = "UTF-8";
        switch (node.jjtGetNumChildren()) {
            case 1: {
                filePath = this.getString(node.jjtGetChild(0), internalContextAdapter);
                break;
            }
            case 2: {
                filePath = this.getString(node.jjtGetChild(0), internalContextAdapter);
                encoding = this.getString(node.jjtGetChild(1), internalContextAdapter);
                if (!StringUtils.isBlank((CharSequence)encoding)) break;
                encoding = "UTF-8";
                break;
            }
            default: {
                this.rsvc.getLog().warn((Object)("Incorrect directive usage format (#get_ds_file). " + GetDsFile.getExceptionMessage()));
                return true;
            }
        }
        UUID dataSetUuid = UUID.fromString(filePath.replace("/attachment/", ""));
        ResponseEntity responseEntity = HttpClientFactory.getDatasetsAttachmentFeignClient().getAttachmentByParameterId(dataSetUuid);
        if (!responseEntity.hasBody()) {
            throw new IOException(String.format("Response body is null for '%s', http status %s.", filePath, responseEntity.getStatusCode()));
        }
        writer.append(IOUtils.toString((InputStream)((Resource)responseEntity.getBody()).getInputStream(), (String)encoding));
        return true;
    }

    private String getString(Node node, InternalContextAdapter internalContextAdapter) {
        if (node != null) {
            return String.valueOf(node.value(internalContextAdapter));
        }
        return null;
    }
}

