/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.template.velocity;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;
import org.apache.velocity.tools.config.Data;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.apache.velocity.tools.config.ToolConfiguration;
import org.apache.velocity.tools.config.ToolboxConfiguration;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.engine.TemplateEngine;
import org.qubership.automation.itf.core.util.helper.ClassResolver;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityTemplateEngine
implements TemplateEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(VelocityTemplateEngine.class);
    private final VelocityEngine engine;
    private final ToolManager toolManager;

    @Inject
    public VelocityTemplateEngine() {
        String velocityConfig = Config.getConfig().getString("velocity.config");
        if (!Strings.isNullOrEmpty((String)velocityConfig)) {
            LOGGER.info("Init Apache Velocity engine with settings {}", (Object)velocityConfig);
            this.engine = new VelocityEngine(velocityConfig);
        } else {
            LOGGER.info("Init Apache Velocity engine with default settings");
            this.engine = new VelocityEngine();
        }
        this.engine.setProperty("velocimacro.permissions.allow.inline.to.replace.global", (Object)"true");
        this.engine.setProperty("runtime.log.logsystem.class", (Object)"org.qubership.automation.itf.core.template.velocity.log.Slf4jLogChute");
        this.engine.setProperty("console.logsystem.max.level", (Object)"WARN");
        this.engine.setProperty("runtime.log.logsystem.max.level", (Object)"WARN");
        this.engine.init();
        for (Class directiveClass : ClassResolver.getInstance().getSubtypesOf(Directive.class)) {
            this.engine.loadDirective(directiveClass.getName());
        }
        FactoryConfiguration factoryConfiguration = VelocityTemplateEngine.makeGenericFactoryConfig();
        factoryConfiguration.addConfiguration(VelocityTemplateEngine.makeStrutsFactoryConfig());
        factoryConfiguration.addConfiguration(VelocityTemplateEngine.makeViewFactoryConfig());
        this.toolManager = new ToolManager();
        this.toolManager.getToolboxFactory().configure(factoryConfiguration);
        this.toolManager.setVelocityEngine(this.engine);
    }

    private static Data fillData(String type, String key, Object value) {
        Data data = new Data();
        data.setType(type);
        data.setKey(key);
        data.setValue(value);
        return data;
    }

    private static List<ToolConfiguration> makeToolsList(String ... args) {
        ArrayList<ToolConfiguration> list = new ArrayList<ToolConfiguration>();
        for (String arg : args) {
            ToolConfiguration cfg = new ToolConfiguration();
            cfg.setClassname(arg);
            list.add(cfg);
        }
        return list;
    }

    private static FactoryConfiguration makeGenericFactoryConfig() {
        FactoryConfiguration factoryConfiguration = new FactoryConfiguration();
        factoryConfiguration.addData(VelocityTemplateEngine.fillData("number", "TOOLS_VERSION", "2.0"));
        factoryConfiguration.addData(VelocityTemplateEngine.fillData("boolean", "GENERIC_TOOLS_AVAILABLE", "true"));
        ToolboxConfiguration applicationToolboxConfiguration = new ToolboxConfiguration();
        applicationToolboxConfiguration.setScope("application");
        applicationToolboxConfiguration.setTools(VelocityTemplateEngine.makeToolsList("org.apache.velocity.tools.generic.AlternatorTool", "org.apache.velocity.tools.generic.ClassTool", "org.apache.velocity.tools.generic.ComparisonDateTool", "org.apache.velocity.tools.generic.ConversionTool", "org.apache.velocity.tools.generic.DisplayTool", "org.apache.velocity.tools.generic.EscapeTool", "org.apache.velocity.tools.generic.FieldTool", "org.apache.velocity.tools.generic.MathTool", "org.apache.velocity.tools.generic.NumberTool", "org.apache.velocity.tools.generic.ResourceTool", "org.apache.velocity.tools.generic.SortTool", "org.apache.velocity.tools.generic.XmlTool"));
        factoryConfiguration.addToolbox(applicationToolboxConfiguration);
        ToolboxConfiguration requestToolboxConfiguration = new ToolboxConfiguration();
        requestToolboxConfiguration.setScope("request");
        requestToolboxConfiguration.setTools(VelocityTemplateEngine.makeToolsList("org.apache.velocity.tools.generic.ContextTool", "org.apache.velocity.tools.generic.LinkTool", "org.apache.velocity.tools.generic.LoopTool", "org.apache.velocity.tools.generic.RenderTool"));
        factoryConfiguration.addToolbox(requestToolboxConfiguration);
        return factoryConfiguration;
    }

    private static FactoryConfiguration makeStrutsFactoryConfig() {
        FactoryConfiguration factoryConfiguration = new FactoryConfiguration();
        factoryConfiguration.addData(VelocityTemplateEngine.fillData("boolean", "STRUTS_TOOLS_AVAILABLE", "true"));
        ToolboxConfiguration requestToolboxConfiguration = new ToolboxConfiguration();
        requestToolboxConfiguration.setScope("request");
        requestToolboxConfiguration.setTools(VelocityTemplateEngine.makeToolsList("org.apache.velocity.tools.struts.ActionMessagesTool", "org.apache.velocity.tools.struts.ErrorsTool", "org.apache.velocity.tools.struts.FormTool", "org.apache.velocity.tools.struts.MessageTool", "org.apache.velocity.tools.struts.StrutsLinkTool", "org.apache.velocity.tools.struts.TilesTool", "org.apache.velocity.tools.struts.ValidatorTool"));
        factoryConfiguration.addToolbox(requestToolboxConfiguration);
        return factoryConfiguration;
    }

    private static FactoryConfiguration makeViewFactoryConfig() {
        FactoryConfiguration factoryConfiguration = new FactoryConfiguration();
        factoryConfiguration.addData(VelocityTemplateEngine.fillData("boolean", "VIEW_TOOLS_AVAILABLE", "true"));
        ToolboxConfiguration requestToolboxConfiguration = new ToolboxConfiguration();
        requestToolboxConfiguration.setScope("request");
        requestToolboxConfiguration.setTools(VelocityTemplateEngine.makeToolsList("org.apache.velocity.tools.view.CookieTool", "org.apache.velocity.tools.view.ImportTool", "org.apache.velocity.tools.view.IncludeTool", "org.apache.velocity.tools.view.LinkTool", "org.apache.velocity.tools.view.PagerTool", "org.apache.velocity.tools.view.ParameterTool", "org.apache.velocity.tools.view.ViewContextTool", "org.apache.velocity.tools.generic.ResourceTool"));
        factoryConfiguration.addToolbox(requestToolboxConfiguration);
        ToolboxConfiguration sessionToolboxConfiguration = new ToolboxConfiguration();
        sessionToolboxConfiguration.setScope("session");
        sessionToolboxConfiguration.setProperty("createSession", (Object)"false");
        sessionToolboxConfiguration.setTools(VelocityTemplateEngine.makeToolsList("org.apache.velocity.tools.view.BrowserTool"));
        factoryConfiguration.addToolbox(sessionToolboxConfiguration);
        return factoryConfiguration;
    }

    public static BigInteger extractProjectIdFromContextAdapter(InternalContextAdapter internalContextAdapter) {
        if (Objects.nonNull(internalContextAdapter.get("tc"))) {
            return ((TcContext)internalContextAdapter.get("tc")).getProjectId();
        }
        Object owner = internalContextAdapter.get("___owner___");
        if (Objects.nonNull(owner)) {
            if (owner instanceof System) {
                return ((System)owner).getProjectId();
            }
            if (owner instanceof Template) {
                TemplateProvider templateParent = ((Template)owner).getParent();
                if (templateParent instanceof Operation) {
                    return ((Operation)templateParent).getProjectId();
                }
                if (templateParent instanceof System) {
                    return ((System)templateParent).getProjectId();
                }
            }
        }
        return null;
    }

    public String process(Storable owner, String someString, JsonContext context) {
        return this.process(owner, someString, context, "");
    }

    public String process(Map<String, Storable> storables, String someString, JsonContext context) {
        return this.process(storables, someString, context, "");
    }

    public String process(Storable owner, String someString, JsonContext context, String coords) {
        if (StringUtils.isBlank((CharSequence)someString)) {
            return "";
        }
        return this.processing(owner, someString, context, (Context)this.toolManager.createContext(), coords);
    }

    public String process(Map<String, Storable> storables, String someString, JsonContext context, String coords) {
        if (StringUtils.isBlank((CharSequence)someString)) {
            return "";
        }
        ToolContext velocityContext = this.toolManager.createContext();
        this.putIfPresent((Context)velocityContext, "___operation___", storables.get("___operation___"));
        this.putIfPresent((Context)velocityContext, "___environment___", storables.get("___environment___"));
        this.putIfPresent((Context)velocityContext, "___initiator___", storables.get("___initiator___"));
        Storable owner = storables.get("___owner___");
        return this.processing(owner, someString, context, (Context)velocityContext, coords);
    }

    private void putIfPresent(Context velocityContext, String key, Storable obj) {
        if (obj != null) {
            velocityContext.put(key, (Object)obj);
        }
    }

    private String processing(Storable owner, String someString, JsonContext context, Context velocityContext, String coords) {
        if (StringUtils.isBlank((CharSequence)someString)) {
            return "";
        }
        LOGGER.trace("Processing string with Velocity: {}\nContext: {}", (Object)someString, (Object)context);
        this.putIfPresent(velocityContext, "___owner___", owner);
        velocityContext.put("___hostName___", (Object)Config.getConfig().getString("runningHostname"));
        for (Object o : context.entrySet()) {
            AbstractContainerInstance initiator;
            Map.Entry entry = (Map.Entry)o;
            velocityContext.put(String.valueOf(entry.getKey()), entry.getValue());
            if (!(entry.getValue() instanceof TcContext) || !((initiator = ((TcContext)entry.getValue()).getInitiator()) instanceof CallChainInstance) || initiator.getContext() == null) continue;
            velocityContext.put("ENV", initiator.getContext().get((Object)"ENV"));
        }
        boolean isOwnerNameNotNull = owner != null && owner.getName() != null;
        try {
            StringWriter stringWriter = new StringWriter(someString.length());
            this.engine.evaluate(velocityContext, (Writer)stringWriter, isOwnerNameNotNull ? owner.getName() : "VeLog", someString);
            String string = stringWriter.toString();
            LOGGER.trace("String processed, result is: {}", (Object)string);
            return string;
        }
        catch (Exception e) {
            throw new VelocityException(String.format("Error occurred while processing of %s: %s", StringUtils.isBlank((CharSequence)coords) ? "template '" + (isOwnerNameNotNull ? owner.getName() : "VeLog") + "'" : coords, e.getMessage()), (Throwable)e);
        }
    }
}

