/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.template.velocity.directives;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;

public class FromJsonString
extends Directive {
    public String getName() {
        return "fromJson";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        int count = node.jjtGetNumChildren();
        if (count < 2) {
            throw new IllegalArgumentException("Directive '#" + this.getName() + "' arguments are missed.\nThe 1st argument is $jsonString (to be parsed into Json object),\nThe 2nd argument is Context Variable Name (without leading $, but with tc. or sp.) - where to put Json object.");
        }
        Object jsonObject = node.jjtGetChild(0).value(internalContextAdapter);
        Object fullKeyName = node.jjtGetChild(1).value(internalContextAdapter);
        if (fullKeyName == null) {
            throw new IllegalArgumentException("Directive '#" + this.getName() + "': 2nd argument should not be empty!");
        }
        String fullKeyString = fullKeyName.toString();
        if (fullKeyString.isEmpty()) {
            throw new IllegalArgumentException("Directive '#" + this.getName() + "': 2nd argument should not be empty!");
        }
        if (fullKeyString.length() < 4) {
            throw new IllegalArgumentException("Directive '#" + this.getName() + "': 2nd argument (" + fullKeyString + ") should be like sp.somekey or tc.somekey!");
        }
        String contextKey = fullKeyString.substring(0, 2);
        String keyString = fullKeyString.substring(3);
        if (!contextKey.equals("tc") && !contextKey.equals("sp") || !fullKeyString.substring(2, 3).equals(".") || keyString.startsWith(".")) {
            throw new IllegalArgumentException("Directive '#" + this.getName() + "': 2nd argument (" + fullKeyString + ") format is invalid!");
        }
        JsonContext contextToManage = (JsonContext)internalContextAdapter.get(contextKey);
        if (contextToManage == null) {
            throw new IllegalArgumentException("Directive '#" + this.getName() + "': Context object by key (" + contextKey + ") is not found!");
        }
        if (jsonObject instanceof String) {
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = jsonObject.toString();
            try {
                Map mp = (Map)mapper.readerFor(Map.class).readValue(jsonString);
                contextToManage.put((Object)keyString, mp == null || mp.isEmpty() ? jsonString : mp);
            }
            catch (Exception ex) {
                try {
                    List lst = (List)mapper.readerFor(List.class).readValue(jsonString);
                    contextToManage.put((Object)keyString, (Object)lst);
                }
                catch (Exception ex2) {
                    contextToManage.put((Object)keyString, (Object)jsonString);
                }
            }
        } else {
            contextToManage.put((Object)keyString, jsonObject);
        }
        return true;
    }
}

