/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.template.velocity.directives;

import java.io.Writer;
import java.math.BigInteger;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.template.velocity.VelocityTemplateEngine;
import org.qubership.automation.itf.core.util.TemplateHelper;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadPart
extends Directive {
    private static final Logger log = LoggerFactory.getLogger(LoadPart.class);

    public String getName() {
        return "load_part";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        BigInteger projectId = VelocityTemplateEngine.extractProjectIdFromContextAdapter(internalContextAdapter);
        if (projectId == null) {
            log.warn("Project ID is null! Template can't be found");
            return true;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i) != null) {
                String identifier = String.valueOf(node.jjtGetChild(i).value(internalContextAdapter));
                if (StringUtils.isEmpty((CharSequence)identifier)) {
                    log.warn("#load_part directive: Template name[{}] parameter should be not empty!", (Object)i);
                    continue;
                }
                Template<? extends TemplateProvider> template = this.loadTemplate(identifier, projectId);
                if (template != null) {
                    this.rsvc.evaluate((Context)internalContextAdapter, writer, identifier, template.getText());
                    continue;
                }
                throw new VelocityException("Unable to load part of template by identifier '" + identifier + "', template isn't found.");
            }
            log.warn("#load_part directive: name[{}] parameter is null", (Object)i);
        }
        return true;
    }

    private Template<? extends TemplateProvider> loadTemplate(String templateIdentifier, BigInteger projectId) {
        if (StringUtils.isEmpty((CharSequence)templateIdentifier)) {
            return null;
        }
        if (StringUtils.isNumeric((CharSequence)templateIdentifier)) {
            BigInteger id;
            try {
                id = IdConverter.toBigInt((Object)templateIdentifier);
            }
            catch (IllegalArgumentException e) {
                return this.findTemplateByName(templateIdentifier, projectId);
            }
            return TemplateHelper.getById((Object)id);
        }
        return this.findTemplateByName(templateIdentifier, projectId);
    }

    private Template<? extends TemplateProvider> findTemplateByName(String templateIdentifier, BigInteger projectId) {
        Collection templates = TemplateHelper.getFirstPartByNameAndProjectId((String)templateIdentifier, (BigInteger)projectId);
        if (templates.size() > 1) {
            throw new IllegalArgumentException(String.format("More than one template found by name '%s' in the project id %s", templateIdentifier, projectId));
        }
        if (templates.isEmpty()) {
            log.error("Template isn't found by name '{}' in project id {}", (Object)templateIdentifier, (Object)projectId);
            return null;
        }
        return (Template)templates.iterator().next();
    }
}

