/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.cli.outbound;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.netty4.NettyComponent;
import org.apache.camel.component.netty4.NettyEndpoint;
import org.apache.camel.component.ssh.SshComponent;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.annotation.Async;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.transport.camel.outbound.AbstractCamelOutboundTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UserName(value="CLI Outbound TCP/IP")
@Async
public class CLIOutboundTransport
extends AbstractCamelOutboundTransport {
    private static final Logger log = LoggerFactory.getLogger(CLIOutboundTransport.class);
    private static final String SSH_COMPONENT_KEY = "ssh";
    private static final String NETTY_COMPONENT_KEY = "netty4";
    private static final Cache<ConfiguredTransport, CLIConfig> CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(notification -> {
        CLIConfig cliConfig = (CLIConfig)notification.getValue();
        try {
            CAMEL_CONTEXT.removeEndpoint(cliConfig.getEndpoint());
            cliConfig.getEndpoint().stop();
        }
        catch (Throwable t) {
            log.error("Error while Camel Context cleaning up", t);
        }
    }).build();
    private static final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    @Parameter(shortName="remote_ip", longName="Remote IP", description="Remote host IP", isDynamic=true)
    private String endpoint;
    @Parameter(shortName="type", longName="Type of Connection", description="TCP, UDP or SSH type")
    @Options(value={"UDP", "TCP", "SSH"})
    private String type;
    @Parameter(shortName="remote_port", longName="Remote Port", description="Remote host port")
    private Integer port;
    @Parameter(shortName="user", longName="User", description="Remote user name", optional=true)
    private String user;
    @Parameter(shortName="password", longName="Password", description="Remote password", optional=true)
    private String password;
    @Parameter(shortName="ssh_key", longName="Ssh key", description="Ssh key", optional=true)
    private List<String> sshKey;
    @Parameter(shortName="wait_response", longName="Should wait response?", description="Should wait response? - Yes (default) / No", optional=true, forTemplate=true)
    @Options(value={"Yes", "No"})
    private String waitResponse;

    public String getShortName() {
        return "Cli outbound";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message sendReceiveSync(Message message, BigInteger projectId) throws Exception {
        Message response;
        ProducerTemplate producerTemplate;
        Endpoint cliEndPoint;
        Integer hash;
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ConnectionProperties properties = new ConnectionProperties(message.getConnectionProperties());
        properties.remove((Object)"ContextId");
        String transportId = (String)properties.get((Object)"transportId");
        ConfiguredTransport configuredTransport = new ConfiguredTransport(transportId, properties);
        Integer n = hash = Integer.valueOf(configuredTransport.hashCode());
        synchronized (n) {
            CLIConfig cliConfig = (CLIConfig)CACHE.getIfPresent((Object)configuredTransport);
            if (cliConfig == null) {
                try {
                    String componentId;
                    boolean isSsh = "SSH".equals(properties.get((Object)"type"));
                    if (isSsh) {
                        componentId = SSH_COMPONENT_KEY;
                        this.addSshComponent();
                        cliEndPoint = CAMEL_CONTEXT.getEndpoint(this.buildUri(properties, true));
                    } else {
                        componentId = NETTY_COMPONENT_KEY;
                        this.addNettyComponent();
                        cliEndPoint = CAMEL_CONTEXT.getEndpoint(this.buildUri(properties, false));
                        if ("Yes".equals(properties.getOrDefault((Object)"wait_response", (Object)"Yes"))) {
                            ((NettyEndpoint)cliEndPoint).setExchangePattern(ExchangePattern.InOut);
                            ((NettyEndpoint)cliEndPoint).getConfiguration().setSync(true);
                        } else {
                            ((NettyEndpoint)cliEndPoint).setExchangePattern(ExchangePattern.OutOnly);
                            ((NettyEndpoint)cliEndPoint).getConfiguration().setSync(false);
                        }
                    }
                    log.debug("{} Endpoint is: {}", properties.get((Object)"type"), (Object)cliEndPoint);
                    producerTemplate = template;
                    cliConfig = new CLIConfig(CAMEL_CONTEXT.getComponent(componentId), producerTemplate, cliEndPoint);
                    CACHE.put((Object)configuredTransport, (Object)cliConfig);
                }
                catch (Exception e) {
                    throw new Exception("Unable to configure CLI endpoint", e);
                }
            } else {
                cliEndPoint = cliConfig.getEndpoint();
                producerTemplate = cliConfig.getProducer();
            }
        }
        log.info("Getting response from: {}", (Object)cliEndPoint);
        Exchange exchange = cliEndPoint.createExchange();
        exchange.getIn().setBody((Object)message.getText());
        exchange = producerTemplate.send(cliEndPoint, exchange);
        if (!exchange.hasOut() || exchange.getOut().isFault()) {
            return this.makeExceptionMessage(exchange);
        }
        Object answerObject = exchange.getOut().getBody();
        if (answerObject == null) {
            response = new Message();
        } else if (answerObject instanceof ByteArrayInputStream) {
            ByteArrayInputStream answer = (ByteArrayInputStream)answerObject;
            int n2 = answer.available();
            if (n2 > 0) {
                byte[] bytes = new byte[n2];
                int cnt = answer.read(bytes, 0, n2);
                response = new Message(new String(bytes, 0, cnt, StandardCharsets.UTF_8));
            } else {
                response = new Message();
            }
        } else {
            response = new Message(answerObject.toString());
        }
        if (exchange.getOut().hasHeaders()) {
            response.convertAndSetHeaders(exchange.getOut().getHeaders());
        }
        log.debug("Response from {} is: {}", (Object)cliEndPoint, (Object)response.getText());
        return response;
    }

    private synchronized void addSshComponent() {
        SshComponent sshComponent = (SshComponent)CAMEL_CONTEXT.hasComponent(SSH_COMPONENT_KEY);
        if (sshComponent == null) {
            sshComponent = new SshComponent();
            CAMEL_CONTEXT.addComponent(SSH_COMPONENT_KEY, (Component)sshComponent);
        }
    }

    private synchronized void addNettyComponent() {
        NettyComponent nettyComponent = (NettyComponent)CAMEL_CONTEXT.hasComponent(NETTY_COMPONENT_KEY);
        if (nettyComponent == null) {
            nettyComponent = new NettyComponent();
            CAMEL_CONTEXT.addComponent(NETTY_COMPONENT_KEY, (Component)nettyComponent);
        }
    }

    private Message makeExceptionMessage(Exchange exchange) {
        Message message = new Message();
        Exception ex = exchange.getException();
        if (ex != null) {
            message.setFailedMessage(ex.getMessage() + (ex.getMessage().contains("Caused by:") || ex.getCause() == null ? "" : "Caused by: " + ex.getCause().getMessage()));
        } else {
            message.setFailedMessage("Unknown exception is occurred");
        }
        if (exchange.hasOut() && exchange.getOut().hasHeaders()) {
            message.convertAndSetHeaders(exchange.getOut().getHeaders());
        }
        return message;
    }

    private String buildUri(ConnectionProperties properties, boolean isSsh) throws IOException {
        StringBuilder uri = new StringBuilder();
        if (isSsh) {
            this.composeSshUri(properties, uri);
            return uri.toString();
        }
        return uri.append("netty4:").append(properties.get((Object)"type")).append("://").append(properties.get((Object)"remote_ip")).append(':').append(properties.get((Object)"remote_port")).append("?textline=true&requestTimeout=5000").toString();
    }

    public String viewEndpoint(ConnectionProperties connectionProperties) {
        return null;
    }

    public Mep getMep() {
        return Mep.OUTBOUND_REQUEST_RESPONSE_SYNCHRONOUS;
    }

    public String getEndpointPrefix() {
        return "/mockingbird-transport-cli";
    }

    private void composeSshUri(ConnectionProperties properties, StringBuilder uri) throws IOException {
        Object user = properties.get((Object)"user");
        Object password = properties.get((Object)"password");
        Object sshKeyObj = properties.get((Object)"ssh_key");
        String sshKey = Objects.nonNull(sshKeyObj) ? String.join((CharSequence)"\n", (List)sshKeyObj) : "";
        boolean userIsBlank = Objects.isNull(user) || Strings.isBlank((String)String.valueOf(user));
        boolean passIsBlank = Objects.isNull(password) || Strings.isBlank((String)String.valueOf(password));
        boolean sshKeyIsBlank = Strings.isBlank((String)sshKey);
        if (passIsBlank && sshKeyIsBlank) {
            throw new IllegalArgumentException("Password/ssh_key can't be empty! Please fill one of them.");
        }
        if (userIsBlank) {
            throw new IllegalArgumentException("User can't be empty!");
        }
        uri.append("ssh:").append(user).append(passIsBlank ? Character.valueOf('@') : ':' + password.toString() + '@').append(properties.get((Object)"remote_ip")).append(':').append(properties.get((Object)"remote_port")).append(sshKeyIsBlank ? "" : "?certResource=file:" + this.getTempPemFile(sshKey).getPath());
    }

    @NotNull
    private File getTempPemFile(String sshKey) throws IOException {
        File tmpfile = File.createTempFile(String.valueOf(System.currentTimeMillis()), ".pem");
        tmpfile.deleteOnExit();
        BufferedWriter writer = new BufferedWriter(new FileWriter(tmpfile));
        writer.write(sshKey);
        writer.close();
        return tmpfile;
    }

    static {
        service.scheduleWithFixedDelay(() -> {
            try {
                CACHE.cleanUp();
                if (CACHE.size() == 0L) {
                    template.stop();
                    CAMEL_CONTEXT.removeComponent(SSH_COMPONENT_KEY);
                    CAMEL_CONTEXT.removeComponent(NETTY_COMPONENT_KEY);
                    template.start();
                }
            }
            catch (Throwable t) {
                log.error("Error while Cache cleaning up", t);
            }
        }, 10L, 5L, TimeUnit.MINUTES);
    }

    private class ConfiguredTransport {
        TreeMap<String, Object> properties;
        private String transportId;

        public ConfiguredTransport() {
            this.transportId = "";
            this.properties = new TreeMap();
        }

        public ConfiguredTransport(String transportId, ConnectionProperties properties) {
            this.transportId = transportId;
            this.properties = new TreeMap(properties);
        }

        public void setTransportId(String transportId) {
            this.transportId = transportId;
        }

        public void setProperties(ConnectionProperties properties) {
            this.properties = new TreeMap(properties);
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.transportId);
            hash = 97 * hash + Objects.hashCode(this.properties);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfiguredTransport other = (ConfiguredTransport)obj;
            if (!Objects.equals(this.transportId, other.transportId)) {
                return false;
            }
            return Objects.equals(this.properties, other.properties);
        }

        public TreeMap<String, Object> getProperties() {
            return this.properties;
        }

        public String getTransportId() {
            return this.transportId;
        }
    }

    protected static class CLIConfig {
        private Component component;
        private ProducerTemplate producer;
        private Endpoint endpoint;

        public CLIConfig(Component component) {
            this.component = component;
        }

        public CLIConfig(Component component, ProducerTemplate producer) {
            this.component = component;
            this.producer = producer;
        }

        public CLIConfig(Component component, ProducerTemplate producer, Endpoint endpoint) {
            this.component = component;
            this.producer = producer;
            this.endpoint = endpoint;
        }

        public void setProducer(ProducerTemplate producer) {
            this.producer = producer;
        }

        public void setEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public Component getComponent() {
            return this.component;
        }

        public ProducerTemplate getProducer() {
            return this.producer;
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }
    }
}

