/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.diameter.interceptors;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.qubership.automation.diameter.connection.ExtraChannel;
import org.qubership.automation.diameter.interceptor.CEAInterceptor;
import org.qubership.automation.diameter.interceptor.DPRInterceptor;
import org.qubership.automation.diameter.interceptor.DWRInterceptor;
import org.qubership.automation.diameter.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.communication.message.DiameterTriggerExecutionMessage;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.DiameterExecutorService;
import org.qubership.automation.itf.transport.diameter.interceptors.ASAInterceptor;
import org.qubership.automation.itf.transport.diameter.interceptors.ASRInterceptor;
import org.qubership.automation.itf.transport.diameter.interceptors.CCAInterceptor;
import org.qubership.automation.itf.transport.diameter.interceptors.RAAInterceptor;
import org.qubership.automation.itf.transport.diameter.interceptors.RARInterceptor;
import org.qubership.automation.itf.transport.diameter.interceptors.SLAInterceptor;
import org.qubership.automation.itf.transport.diameter.interceptors.SNRInterceptor;
import org.qubership.automation.itf.transport.diameter.interceptors.STAInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExternalInterceptor
extends Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalInterceptor.class);
    private Object transportId;
    private Object tcContextId;

    public ExternalInterceptor() {
    }

    public ExternalInterceptor(Object transportId, Object tcContextId, String interceptorType) {
        this.transportId = transportId;
        this.tcContextId = tcContextId;
        this.setType(interceptorType);
    }

    protected void setTransportId(Object transportId) {
        this.transportId = transportId;
    }

    protected void setTcContextId(Object tcContextId) {
        this.tcContextId = tcContextId;
    }

    protected boolean _onReceive(String message, ExtraChannel extraChannel) {
        boolean isApplicable = this.isApplicable(message);
        if (isApplicable) {
            this.postSituation(message);
        }
        return isApplicable;
    }

    abstract boolean isApplicable(String var1);

    private void postSituation(String textMessage) {
        DiameterExecutorService.getDiameterEventProducer().produceEventDiameter(new DiameterTriggerExecutionMessage(new Message(textMessage), this.transportId, this.tcContextId, UUID.randomUUID().toString()));
    }

    public static class InterceptorFactory {
        private static final InterceptorFactory INSTANCE = new InterceptorFactory();
        private final Map<String, Class<? extends Interceptor>> interceptorStorage = new HashMap<String, Class<? extends Interceptor>>();

        private InterceptorFactory() {
            this.interceptorStorage.put("DWA", DWRInterceptor.class);
            this.interceptorStorage.put("CEA", CEAInterceptor.class);
            this.interceptorStorage.put("CCA", CCAInterceptor.class);
            this.interceptorStorage.put("ASA", ASAInterceptor.class);
            this.interceptorStorage.put("RAA", RAAInterceptor.class);
            this.interceptorStorage.put("SLA", SLAInterceptor.class);
            this.interceptorStorage.put("STA", STAInterceptor.class);
            this.interceptorStorage.put("RAR", RARInterceptor.class);
            this.interceptorStorage.put("ASR", ASRInterceptor.class);
            this.interceptorStorage.put("SNR", SNRInterceptor.class);
            this.interceptorStorage.put("DPR", DPRInterceptor.class);
        }

        public static InterceptorFactory getInstance() {
            return INSTANCE;
        }

        public Interceptor create(String name) {
            Class interceptorClass = this.interceptorStorage.computeIfAbsent(name, key -> {
                throw new IllegalArgumentException("Unknown interceptor name: " + key);
            });
            try {
                return (Interceptor)interceptorClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Unable to create interceptor", e);
            }
        }

        public Interceptor create(String name, String sessionId, Object tcContextId, Object transportId, boolean deleteOnReceive) {
            Interceptor interceptor = this.create(name);
            interceptor.setSessionId(sessionId);
            interceptor.setDeleteOnReceive(deleteOnReceive);
            if ("RAR".equalsIgnoreCase(name)) {
                RARInterceptor rarInterceptor = (RARInterceptor)interceptor;
                rarInterceptor.setTransportId(transportId);
                rarInterceptor.setTcContextId(tcContextId);
                return rarInterceptor;
            }
            if ("SNR".equalsIgnoreCase(name)) {
                SNRInterceptor snrInterceptor = (SNRInterceptor)interceptor;
                snrInterceptor.setTcContextId(tcContextId);
                snrInterceptor.setTransportId(transportId);
                return snrInterceptor;
            }
            if ("ASR".equalsIgnoreCase(name)) {
                ASRInterceptor asrInterceptor = (ASRInterceptor)interceptor;
                asrInterceptor.setTcContextId(tcContextId);
                asrInterceptor.setTransportId(transportId);
                return asrInterceptor;
            }
            return interceptor;
        }
    }
}

