/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.diameter;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.diameter.data.Encoder;
import org.qubership.automation.diameter.data.encoder.XmlEncoder;
import org.qubership.automation.diameter.data.encoder.wireshark.WireSharkEncoder;
import org.qubership.automation.diameter.dictionary.DictionaryConfig;

public class EncoderFactory {
    private static final Map<String, Class<? extends Encoder>> STORAGE = new HashMap<String, Class<? extends Encoder>>();
    private static final EncoderFactory ENCODER_FACTORY = new EncoderFactory();

    private EncoderFactory() {
        STORAGE.put("XML", XmlEncoder.class);
        STORAGE.put("Wireshark", WireSharkEncoder.class);
    }

    public static EncoderFactory getInstance() {
        return ENCODER_FACTORY;
    }

    public Encoder getEncoder(String format, @Nonnull DictionaryConfig dictionaryConfig) {
        if (StringUtils.isBlank((CharSequence)format)) {
            throw new IllegalArgumentException("Invalid encoder format : " + format);
        }
        Class encoder = STORAGE.computeIfAbsent(format, key -> {
            throw new IllegalArgumentException("Invalid type of encode: " + key);
        });
        boolean isXml = encoder.getSimpleName().equals(XmlEncoder.class.getSimpleName());
        return isXml ? new XmlEncoder(dictionaryConfig) : new WireSharkEncoder(dictionaryConfig);
    }
}

