/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.diameter.outbound;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Striped;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.qubership.automation.diameter.config.ConfigReader;
import org.qubership.automation.diameter.config.DiameterParserType;
import org.qubership.automation.diameter.connection.ConnectionFactory;
import org.qubership.automation.diameter.connection.DiameterConnection;
import org.qubership.automation.diameter.connection.ExtraChannel;
import org.qubership.automation.diameter.connection.TransportType;
import org.qubership.automation.diameter.data.Decoder;
import org.qubership.automation.diameter.data.Encoder;
import org.qubership.automation.diameter.data.XmlDecoder;
import org.qubership.automation.diameter.dictionary.DictionaryConfig;
import org.qubership.automation.diameter.interceptor.CEAInterceptor;
import org.qubership.automation.diameter.interceptor.DPRInterceptor;
import org.qubership.automation.diameter.interceptor.DWRInterceptor;
import org.qubership.automation.diameter.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.diameter.DiameterConnectionInfo;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.DiameterConnectionInfoProvider;
import org.qubership.automation.itf.core.util.DiameterSessionHolder;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.transport.base.AbstractOutboundTransportImpl;
import org.qubership.automation.itf.transport.diameter.DiameterSessionTypes;
import org.qubership.automation.itf.transport.diameter.EncoderFactory;
import org.qubership.automation.itf.transport.diameter.interceptors.ASRInterceptor;
import org.qubership.automation.itf.transport.diameter.interceptors.ExternalInterceptor;
import org.qubership.automation.itf.transport.diameter.interceptors.RARInterceptor;
import org.qubership.automation.itf.transport.diameter.interceptors.SNRInterceptor;
import org.qubership.automation.itf.transport.diameter.interceptors.util.DiameterInterceptorCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UserName(value="Outbound Diameter Synchronous")
public class DiameterOutbound
extends AbstractOutboundTransportImpl {
    private static final Logger log = LoggerFactory.getLogger(DiameterOutbound.class);
    private static final boolean SHARED_CONNECTIONS = true;
    private static final int STRIPES = 250;
    private static final Striped<Lock> LOCK_STRIPED = Striped.lazyWeakLock((int)250);
    private static final String CONTEXT_ID = "ContextId";
    private static final String PROPERTY_TEMPLATE = "${%s}";
    private static final String DROP_CONNECTION = "Drop Connection";
    private static final String TRANSPORT_ID = "transportId";
    private static final String UNDERLINE = "_";
    @Parameter(shortName="CER", longName="CER template (to send automatically just after connection is opened)", description="CER template (to send automatically just after connection is opened)", optional=true, loadTemplate=true)
    public String cer;
    @Parameter(shortName="host", longName="Remote host name", description="Remote host name")
    private String host;
    @Parameter(shortName="port", longName="Remote host port", description="Remote host port")
    private String port;
    @Parameter(shortName="dwa", longName="Watchdog default template", description="Watchdog default template", loadTemplate=true)
    private String dwr;
    @Parameter(shortName="configPath", longName="AVP configurations path", description="AVP configurations path (relative path, example: '/dictionary')", fileDirectoryType="diameter-dictionary", validatePattern="^((\\/[a-zA-Z0-9]+)+|\\/)$")
    private String configurationPath;
    @Parameter(shortName="waitResponseTimeout", longName="Response Timeout", description="Wait response timeout. Default: 3000ms (MILLISECONDS)", optional=true)
    private String waitTimeout;
    @Parameter(shortName="connectionType", longName="TCP/SCTP connection layer", description="TCP/SCTP connection layer")
    @Options(value={"TCP", "SCTP"})
    private String connectionType;
    @Parameter(shortName="interceptorName", longName="What response you are expecting", description="What response you are expecting", forTemplate=true, forServer=false)
    @Options(value={"DWA", "CCA", "CEA", "ASA", "RAA", "SLA", "STA"})
    private String interceptorName;
    @Parameter(shortName="properties", longName="Properties", description="Properties like Origin-Host=localhost", isDynamic=true, optional=true, userSettings=true)
    private Map<String, String> properties;
    @Parameter(shortName="messageFormat", longName="Message format", description="XML template configuration or Wireshark. Default is XML", optional=true)
    @Options(value={"XML", "Wireshark"})
    private String messageFormat;
    @Parameter(shortName="waitResponse", longName="Wait response for message sent", description="Will wait response for message or not", optional=true, forTemplate=true)
    @Options(value={"Yes", "No"})
    private String waitResponse;
    @Parameter(shortName="DPR", longName="DPR template (to send automatically just before the channel is closed)", description="DPR template (to send automatically just before the channel is closed)", optional=true, loadTemplate=true)
    private String dpr;
    @Parameter(shortName="sessionID", longName="Diameter session ID (Can be dynamic)", description="Diameter session ID (Can be dynamic)", optional=true, isDynamic=true)
    private String sessionId;
    @Parameter(shortName="customDpr", longName="Send DPR by yourself?", description="Send DPR by yourself?", optional=true)
    @Options(value={"Yes", "No"})
    private String customDpr;
    @Parameter(shortName="DPA", longName="DPA template", description="DPA template", loadTemplate=true)
    private String dpa;
    @Parameter(shortName="dictionary type", longName="Dictionary type", description="Dictionary type")
    @Options(value={"Standard", "Marben"})
    private String dictionaryType;
    private long currentTimeout;

    public String getShortName() {
        return "Diameter Outbound";
    }

    public Message sendReceiveSync(Message message, BigInteger projectId) throws Exception {
        ConnectionProperties connectionProperties = (ConnectionProperties)message.getConnectionProperties();
        int port = Integer.parseInt(this.getRequired(connectionProperties, "port"));
        if (DROP_CONNECTION.equalsIgnoreCase(message.getText())) {
            String connectionId = connectionProperties.obtain("host").toString() + port;
            ConnectionFactory.destroy((Object)connectionId);
            String podName = Config.getConfig().getRunningHostname();
            DiameterConnectionInfoProvider.getDiameterConnectionInfoCacheService().remove(String.format("%s%s", connectionId, podName));
            return new Message("");
        }
        String interceptorName = (String)connectionProperties.obtain("interceptorName");
        String required = this.getRequired(connectionProperties, "host");
        Interceptor interceptor = ExternalInterceptor.InterceptorFactory.getInstance().create(interceptorName);
        String sessionID = (String)connectionProperties.obtain("sessionID");
        interceptor.setSessionId(sessionID);
        message = this.prepareMessage(message, (Map)connectionProperties.obtain("properties"));
        Supplier<CEAInterceptor> ceaSupplier = this.createCeaSupplier();
        if ("No".equals(connectionProperties.obtain("waitResponse"))) {
            this.sendMessage(message, connectionProperties, port, required, interceptor, ceaSupplier, sessionID, projectId);
            return new Message("");
        }
        Message response = this.sendMessageAndGetResponse(message, connectionProperties, port, required, interceptor, ceaSupplier, sessionID, projectId);
        this.checkErrors(interceptor, response, ceaSupplier);
        return response;
    }

    private Message prepareMessage(Message message, Map<String, String> properties) {
        if (properties == null) {
            return message;
        }
        properties.forEach((key, value) -> message.setText(this.replacePlaceholder((String)key, (String)value, message.getText())));
        return message;
    }

    private String replacePlaceholder(String key, String value, String text) {
        return text.replaceAll(Pattern.quote(String.format(PROPERTY_TEMPLATE, key)), value);
    }

    private Message sendMessageAndGetResponse(Message message, ConnectionProperties connectionProperties, int port, String required, Interceptor interceptor, Supplier<CEAInterceptor> ceaSupplier, String sessionID, BigInteger projectId) throws Exception {
        this.sendMessage(message, connectionProperties, port, required, interceptor, ceaSupplier, sessionID, projectId);
        this.waitResponseAndExpireInterceptor(connectionProperties, interceptor);
        return new Message(interceptor.getResponse());
    }

    private void waitResponseAndExpireInterceptor(ConnectionProperties connectionProperties, Interceptor interceptor) throws Exception {
        this.currentTimeout = Long.parseLong((String)this.getOrDefault((Map<String, Object>)connectionProperties, "waitResponseTimeout", "3000"));
        boolean isReceived = this.waitResponse(interceptor, this.currentTimeout);
        if (!isReceived) {
            log.warn(String.format("timeout for request session: %s", connectionProperties.obtain("sessionID").toString()));
        }
        interceptor.setExpired(true);
    }

    private void sendMessage(Message message, ConnectionProperties connectionProperties, int port, String required, Interceptor interceptor, Supplier<CEAInterceptor> ceaSupplier, String sessionID, BigInteger projectId) throws Exception {
        DiameterConnection connection = this.getDiameterConnection(connectionProperties, required, port, Collections.singletonList(interceptor), ceaSupplier, projectId);
        try {
            Object contextId = connectionProperties.obtain(CONTEXT_ID);
            Object transportId = connectionProperties.obtain(TRANSPORT_ID);
            boolean isInit = DiameterSessionHolder.getInstance().add(sessionID, contextId);
            if (isInit) {
                this.createExternalInterceptors(interceptor, connection, sessionID, transportId, contextId);
            }
            connection.send(message.getText());
        }
        catch (Exception e) {
            log.error("Message sending is failed or CEA response isn't received", (Throwable)e);
            throw new RuntimeException("Message sending is failed or CEA response isn't received", e);
        }
    }

    private void createExternalInterceptors(Interceptor interceptor, DiameterConnection connection, String sessionID, Object transportId, Object contextId) {
        String sessionType;
        switch (sessionType = DiameterSessionTypes.getType(interceptor)) {
            case "CreditControlSession": {
                ExternalInterceptor.InterceptorFactory factory = ExternalInterceptor.InterceptorFactory.getInstance();
                RARInterceptor rar = (RARInterceptor)factory.create("RAR", sessionID, contextId, transportId, false);
                ASRInterceptor asr = (ASRInterceptor)factory.create("ASR", sessionID, contextId, transportId, false);
                connection.addInterceptors((Collection)Lists.newArrayList((Object[])new Interceptor[]{rar, asr}));
                break;
            }
            case "SySession": {
                ExternalInterceptor.InterceptorFactory factory = ExternalInterceptor.InterceptorFactory.getInstance();
                SNRInterceptor snr = (SNRInterceptor)factory.create("SNR", sessionID, contextId, transportId, false);
                connection.addInterceptors((Collection)Lists.newArrayList((Object[])new Interceptor[]{snr}));
                break;
            }
            default: {
                throw new IllegalStateException("Unable to create diameter interceptor - unexpected diameter session type: " + sessionType);
            }
        }
    }

    private void sendCer(ConnectionProperties connectionProperties, Interceptor interceptor, DiameterConnection connection) throws Exception {
        connection.addInterceptors(Collections.singletonList(interceptor));
        connection.send(this.prepareText((String)connectionProperties.obtain("CER"), connectionProperties));
        this.waitResponseAndExpireInterceptor(connectionProperties, interceptor);
        if (StringUtils.isBlank((CharSequence)interceptor.getResponse())) {
            throw new IllegalStateException("CEA response is not received. Can't establish connection");
        }
    }

    private String prepareText(String text, ConnectionProperties connectionProperties) {
        Map properties = (Map)connectionProperties.obtain("properties");
        text = this.replacePlaceholders(text, properties);
        return text;
    }

    private <U> String replacePlaceholders(String text, Map<String, U> properties) {
        if (properties == null) {
            return text;
        }
        for (Map.Entry<String, U> entry : properties.entrySet()) {
            text = this.replacePlaceholder(entry.getKey(), entry.getValue().toString(), text);
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitResponse(Interceptor interceptor, long timeOut) throws InterruptedException {
        long endTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + Long.parseLong(String.valueOf(timeOut));
        Interceptor interceptor2 = interceptor;
        synchronized (interceptor2) {
            long delta = endTime - TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            while (!interceptor.isReceived() && delta > 0L) {
                interceptor.wait(delta);
                delta = endTime - TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            }
        }
        return interceptor.isReceived();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiameterConnection getDiameterConnection(ConnectionProperties props, String host, int port, List<Interceptor> interceptors, Supplier<CEAInterceptor> ceaSupplier, BigInteger projectId) throws Exception {
        String localCacheId = String.format("%s%s%s%s%d", projectId, UNDERLINE, props.obtain("host").toString(), UNDERLINE, port);
        Lock lock = (Lock)LOCK_STRIPED.get((Object)localCacheId);
        synchronized (lock) {
            DiameterConnection connection = ConnectionFactory.getExisting((Object)localCacheId);
            if (connection != null) {
                connection.addInterceptors(interceptors);
                return connection;
            }
            String dictionaryPath = this.getRequired(props, "configPath");
            String parserType = this.getRequired(props, "dictionary type");
            Class parserClass = DiameterParserType.defineParserClass((String)parserType);
            DictionaryConfig dictionaryConfig = new DictionaryConfig(dictionaryPath, parserClass, projectId);
            ConfigReader.read((DictionaryConfig)dictionaryConfig, (boolean)false);
            connection = this.createDiameterConnection(props, projectId);
            connection.setDecoder((Decoder)new XmlDecoder(dictionaryConfig));
            Encoder encoder = EncoderFactory.getInstance().getEncoder((String)props.obtain("messageFormat"), dictionaryConfig);
            connection.setEncoder(encoder);
            String dpaTemplate = this.replacePlaceholders(this.getRequired(props, "DPA"), (Map)props.obtain("properties"));
            DPRInterceptor dprInterceptor = new DPRInterceptor(dpaTemplate, encoder);
            connection.addInterceptors(Collections.singletonList(dprInterceptor));
            String dwrTemplate = this.replacePlaceholders(this.getRequired(props, "dwa"), (Map)props.obtain("properties"));
            DWRInterceptor dwrInterceptor = new DWRInterceptor(dwrTemplate, encoder);
            connection.addInterceptors(Collections.singletonList(dwrInterceptor));
            connection.addInterceptors(interceptors);
            TransportType transportType = TransportType.getType((String)String.valueOf(this.getOrDefault((Map<String, Object>)props, "connectionType", "TCP")));
            ExtraChannel channel = ExtraChannel.open((TransportType)transportType);
            channel.connect(new InetSocketAddress(host, port));
            connection.setSocketChannel(channel);
            connection.startListening((Object)localCacheId);
            String podName = Config.getConfig().getRunningHostname();
            DiameterConnectionInfo diameterConnectionInfo = this.createDiameterConnectionInfo(localCacheId, connection, podName, dictionaryPath, projectId);
            DiameterConnectionInfoProvider.getDiameterConnectionInfoCacheService().put(localCacheId + UNDERLINE + podName, diameterConnectionInfo);
            ConnectionFactory.cache((Object)localCacheId, (DiameterConnection)connection);
            if (props.obtain("CER") != null) {
                this.sendCer(props, (Interceptor)ceaSupplier.get(), connection);
            }
            log.info("Establish connection with host: {}:{}. With configuration: {}", new Object[]{host, port, dictionaryPath});
            return connection;
        }
    }

    @NotNull
    private DiameterConnectionInfo createDiameterConnectionInfo(String cacheId, DiameterConnection connection, String podName, String dictionaryPath, BigInteger projectId) {
        DiameterConnectionInfo diameterConnectionInfo = new DiameterConnectionInfo();
        diameterConnectionInfo.setConnectionId(cacheId);
        diameterConnectionInfo.setChannel(connection.getChannel().toString());
        diameterConnectionInfo.setPodName(podName);
        diameterConnectionInfo.setDictionaryPath(dictionaryPath);
        diameterConnectionInfo.setProjectId(String.valueOf(projectId));
        return diameterConnectionInfo;
    }

    private DiameterConnection createDiameterConnection(ConnectionProperties connectionProperties, BigInteger projectId) {
        DiameterConnection connection = connectionProperties.obtain("DPR") != null && "Yes".equals(connectionProperties.obtain("customDpr")) ? ConnectionFactory.createConnection((String)((String)connectionProperties.obtain("DPR"))) : ConnectionFactory.createConnection();
        DiameterInterceptorCleaner.getInstance().scheduleCleanupIfNeeded(projectId);
        return connection;
    }

    private String getRequired(ConnectionProperties connectionProperties, String field) {
        return String.valueOf(connectionProperties.computeIfAbsent((Object)field, key -> {
            throw new IllegalArgumentException(String.format("Required %s doesn't configured", key));
        }));
    }

    private void checkErrors(Interceptor interceptor, Message response, Supplier<CEAInterceptor> ceaSupplier) {
        CEAInterceptor ceaInterceptor;
        if (interceptor.isFailed()) {
            response.setFailedMessage(interceptor.getResponse());
        }
        if ((ceaInterceptor = ceaSupplier.get()).isFailed()) {
            response.setFailedMessage(ceaInterceptor.getResponse());
        }
        if (response.getText() == null && !interceptor.isFailed()) {
            throw new IllegalStateException("No response from remote diameter host. Possible reasons are: CCA response wasn't received and request timed out after " + this.currentTimeout / 1000L + " seconds" + (ceaInterceptor.getResponse() != null ? " or CEA response is invalid: " + ceaInterceptor.getResponse() : "."));
        }
    }

    private Supplier<CEAInterceptor> createCeaSupplier() {
        return new Supplier<CEAInterceptor>(){
            private CEAInterceptor ceaInterceptor;

            @Override
            public CEAInterceptor get() {
                if (this.ceaInterceptor == null) {
                    this.ceaInterceptor = new CEAInterceptor();
                }
                return this.ceaInterceptor;
            }
        };
    }

    private <T extends Interceptor> Supplier<T> createInterceptorSupplier(final Class<T> clazz) {
        return new Supplier<T>(){
            private T interceptor;

            @Override
            public T get() {
                if (this.interceptor == null) {
                    try {
                        this.interceptor = (Interceptor)clazz.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        log.error("Interceptor for '{}' can't be created", (Object)clazz, (Object)e);
                    }
                }
                return this.interceptor;
            }
        };
    }

    public String viewEndpoint(ConnectionProperties connectionProperties) {
        return null;
    }

    public Mep getMep() {
        return Mep.OUTBOUND_REQUEST_RESPONSE_SYNCHRONOUS;
    }

    public String getEndpointPrefix() {
        return "/mockingbird-transport-diameter";
    }

    private Object getOrDefault(Map<String, Object> properties, String key, String defaultValue) {
        Object value = properties.get(key);
        return value == null || !properties.containsKey(key) || "".equals(value.toString()) ? defaultValue : value;
    }
}

