/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.file.outbound;

import com.google.common.io.Files;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.Endpoint;
import org.apache.camel.ProducerTemplate;
import org.apache.commons.io.FileUtils;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.transport.base.AbstractFileOverOutboundTransportImpl;
import org.qubership.automation.itf.transport.camel.CamelContextProvider;
import org.qubership.automation.itf.transport.camel.Helper;
import org.qubership.automation.itf.transport.file.FileHelper;

@UserName(value="Outbound File over SMB/FTP/SFTP")
public class FileOutbound
extends AbstractFileOverOutboundTransportImpl {
    @Parameter(shortName="endpointProperties", longName="Extra Endpoint Properties", description="Extra Endpoint Properties (name=value pairs delimited by newlines)", isDynamic=true, optional=true)
    protected Map<String, Object> properties;
    @Parameter(shortName="host", longName="Host", description="Host", optional=true)
    private String host;
    @Parameter(shortName="path", longName="Path", description="Path", optional=true, isDynamic=true)
    private String path;
    @Parameter(shortName="principal", longName="Security Principal", description="UserName", optional=true)
    private String principal;
    @Parameter(shortName="credentials", longName="Security Credentials", description="Password or empty", optional=true)
    private String credentials;
    @Parameter(shortName="destinationFileName", longName="Destination File Name", description="File Name", forServer=false, forTemplate=true, isDynamic=true)
    private String fileName;
    @Parameter(shortName="type", longName="Type", description="Protocol type")
    @Options(value={"file", "ftp", "sftp"})
    private String type;
    @Parameter(shortName="ssh_key", longName="SSH private key string (pem format only)", description="Ssh private key string (pem format only)", optional=true)
    private List<String> sshKey;

    public String getEndpointPrefix() {
        return "/mockingbird-transport-file";
    }

    public String getShortName() {
        return "File Outbound";
    }

    public String send(Message message, String sessionId, UUID projectUuid) throws Exception {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ConnectionProperties properties = new ConnectionProperties(message.getConnectionProperties());
        Map extraProps = Helper.setExtraPropertiesMap((Map)((Map)properties.obtain("endpointProperties")));
        ProducerTemplate template = CamelContextProvider.CAMEL_CONTEXT.createProducerTemplate();
        String uri = FileHelper.buildUri(properties, extraProps);
        Endpoint endpoint = template.getCamelContext().getEndpoint(uri);
        File fileToSend = this.createFile(message, properties);
        template.sendBody(endpoint, (Object)fileToSend);
        return "";
    }

    private File createFile(Message message, ConnectionProperties properties) throws Exception {
        File file = message.getFile();
        if (file == null) {
            String destinationFileName = FileHelper.checkDestinationName((String)properties.obtain("destinationFileName"));
            properties.put((Object)"destinationFileName", (Object)destinationFileName);
            String path = Files.createTempDir().getPath() + "\\";
            file = new File(path + destinationFileName);
            FileUtils.write((File)file, (CharSequence)message.getText().replace("\n", System.lineSeparator()));
        } else {
            String destinationPath = "";
            String destinationFileName = (String)properties.obtain("destinationFileName");
            int lastPos = destinationFileName.lastIndexOf("/");
            if (lastPos > -1) {
                destinationPath = destinationFileName.substring(0, lastPos + 1);
            } else {
                lastPos = destinationFileName.lastIndexOf("\\");
                if (lastPos > -1) {
                    destinationPath = destinationFileName.substring(0, lastPos + 1);
                }
            }
            properties.put((Object)"destinationFileName", (Object)(destinationPath + file.getName()));
        }
        return file;
    }
}

