/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.transport.camel.Helper;

public class FileHelper {
    public static String buildUri(ConnectionProperties properties, Map<String, Object> extraProps) throws IOException {
        String type = (String)properties.obtain("type");
        String host = (String)properties.obtain("host");
        String remotePath = (String)properties.obtain("path");
        String username = (String)properties.obtain("principal");
        String password = (String)properties.obtain("credentials");
        Object fileName = properties.obtain("destinationFileName");
        boolean isSftp = "sftp".equals(type);
        boolean passIsBlank = Objects.isNull(password) || FileHelper.isNull(password);
        String sshKey = FileHelper.getSshKey(properties);
        boolean isSftpWithKey = isSftp && Strings.isNotEmpty((CharSequence)sshKey);
        FileHelper.stopIfRequiredPropertiesEmpty(remotePath, type, isSftp, sshKey, password, username);
        return type + "://" + FileHelper.appendIfHas(username, "@") + FileHelper.appendIfHas(host, "/") + remotePath + FileHelper.appendIfHas("?password=", password) + (passIsBlank ? (char)'?' : '&') + "fileName=" + fileName + (isSftp ? "&preferredAuthentications=publickey,password" : "") + (isSftpWithKey ? "&privateKeyFile=" + FileHelper.createTempPemFile(sshKey).getPath() : "") + Helper.setExtraProperties(extraProps);
    }

    private static void stopIfRequiredPropertiesEmpty(String remotePath, String type, boolean isSftp, String sshKey, String password, String username) {
        if (FileHelper.isNull(remotePath) || FileHelper.isNull(type)) {
            throw new IllegalArgumentException("Path/type can't be empty");
        }
        if (isSftp && Strings.isEmpty((CharSequence)sshKey) && Strings.isEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("Password/ssh_key can't be empty! Please fill one of them");
        }
        if (isSftp && Strings.isEmpty((CharSequence)username)) {
            throw new IllegalArgumentException("Username can't be empty!");
        }
    }

    public static String checkDestinationName(String destFileName) {
        if (StringUtils.isBlank((CharSequence)destFileName)) {
            throw new IllegalArgumentException("Destination File Name is empty!");
        }
        return destFileName;
    }

    public static boolean isNull(String s) {
        return StringUtils.isBlank((CharSequence)s) || "null".equals(s);
    }

    private static String appendIfHas(String ... s) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String s1 : s) {
            if (FileHelper.isNull(s1)) {
                return "";
            }
            stringBuilder.append(s1);
        }
        return stringBuilder.toString();
    }

    private static String getSshKey(ConnectionProperties properties) {
        Object sshKeyPropertiesValue = properties.get((Object)"ssh_key");
        return Objects.nonNull(sshKeyPropertiesValue) && !((List)sshKeyPropertiesValue).isEmpty() ? String.join((CharSequence)"\n", (List)sshKeyPropertiesValue) : null;
    }

    @NotNull
    private static File createTempPemFile(String sshKey) throws IOException {
        File tmpfile = File.createTempFile(String.valueOf(System.currentTimeMillis()), ".pem");
        tmpfile.deleteOnExit();
        BufferedWriter writer = new BufferedWriter(new FileWriter(tmpfile));
        writer.write(sshKey);
        writer.close();
        return tmpfile;
    }
}

