/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.http.outbound;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.SocketException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.http.SSLContextParametersSecureProtocolSocketFactory;
import org.apache.camel.component.http4.CompositeHttpConfigurer;
import org.apache.camel.component.http4.HttpClientConfigurer;
import org.apache.camel.component.http4.HttpComponent;
import org.apache.camel.component.http4.ProxyHttpClientConfigurer;
import org.apache.camel.http.common.HttpOperationFailedException;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.util.jsse.KeyManagersParameters;
import org.apache.camel.util.jsse.KeyStoreParameters;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.camel.util.jsse.TrustManagersParameters;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.http.HttpVersion;
import org.apache.http.conn.HttpHostConnectException;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.config.ApplicationConfig;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.transport.camel.outbound.AbstractCamelOutboundTransport;
import org.qubership.automation.itf.transport.http.DynamicHttpClientConfigurer;
import org.qubership.automation.itf.transport.http.Helper;

public abstract class HTTPOutboundTransport
extends AbstractCamelOutboundTransport {
    private static final DefaultHeaderFilterStrategy ITFHeaderFilterStrategy = new DefaultHeaderFilterStrategy();
    private static final Cache<String, SSLContextParameters> SSL_CONTEXT_PARAMETERS_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private static final Cache<String, ProxyHttpClientConfigurer> PROXY_HTTP_CLIENT_CONFIGURER_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private static final Cache<String, DynamicHttpClientConfigurer> DYNAMIC_HTTP_CLIENT_CONFIGURER_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    @Parameter(shortName="method", longName="Method", description="HTTP Method", forServer=false, forTemplate=true)
    @Options(value={"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE", "PATCH"})
    protected String method = "GET";
    @Parameter(shortName="endpoint", longName="Http Endpoint", description="URI endpoint: /mb/test/enpoint", forTemplate=true, optional=true, isDynamic=true)
    protected String endpoint;
    @Parameter(shortName="baseUrl", longName="Base Server URL", description="Base URL: http://some-machine.our-company.com:6330", isRedefined=true, isDynamic=true)
    protected String baseUrl;
    @Parameter(shortName="contentType", longName="Http Request Content Type", description="Content-Type; Default=text/html. Header overrides it.", optional=true, forTemplate=true, isDynamic=true)
    protected String contentType = "text/html";
    @Parameter(shortName="headers", longName="Http Request Headers", description="SomeHeader=SomeValue\nAuthorization=Basic some-token", optional=true, forTemplate=true, isDynamic=true)
    protected Map<String, String> headers = new HashMap<String, String>();
    @Parameter(shortName="secureProtocol", longName="Use secure protocol(if use https)", optional=true, description="")
    @Options(value={"SSL", "TLSv1.2"})
    protected String secureProtocol = "TLSv1.2";
    @Parameter(shortName="responseCode", longName="Allow Status Code", description="Allowed status code for response (range like '200-299' or '200-200')", forTemplate=true, forServer=false, optional=true)
    private String allowStatus;
    @Parameter(shortName="properties", longName="Properties", description="Properties description", isDynamic=true, optional=true, forTemplate=true, userSettings=true)
    private Map<String, String> properties;
    @Parameter(shortName="cacheResponseForSeconds", longName="Cache Response for Seconds", description="Cache response; expiry time (in seconds). Default=Empty (means: Do NOT cache a response)", optional=true, forTemplate=true)
    private Integer cacheResponseForSeconds;

    public String getShortName() {
        return "HTTP Outbound";
    }

    public org.qubership.automation.itf.core.model.jpa.message.Message sendReceiveSync(org.qubership.automation.itf.core.model.jpa.message.Message message, BigInteger projectId) throws Exception {
        org.qubership.automation.itf.core.model.jpa.message.Message responseMessage;
        this.validateRequest(message);
        String baseUrl = (String)message.getConnectionProperties().get("baseUrl");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)baseUrl), (Object)"Base url can't be null or empty");
        Preconditions.checkArgument((boolean)baseUrl.startsWith("http"), (Object)"Base url isn't valid, it should start with http/https");
        boolean isSecure = this.isSecure(baseUrl);
        if (isSecure) {
            message.getHeaders().putIfAbsent("trustAll", "true");
        }
        HttpComponent httpComponent = this.prepareHttpComponent(isSecure, message);
        String endpointUri = this.resolveEndpoint(message, baseUrl);
        Helper.clearForbiddenHeaders(httpComponent, ITFHeaderFilterStrategy);
        this.configureSendViaProxy(httpComponent, message);
        this.configureDynamicHttpClient(httpComponent, message);
        Exchange exchange = this.createRequestExchange(message, CAMEL_CONTEXT.createProducerTemplate(), this.addDefaultHeaders(message), endpointUri, httpComponent);
        List<MutablePair<Integer, Integer>> validCodeRanges = this.computeValidCodeRanges(message.getConnectionProperties());
        int responseHttpCode = this.getResponseCode(exchange);
        if (!validCodeRanges.isEmpty()) {
            boolean codeAllowed = this.checkResponseCode(responseHttpCode, validCodeRanges);
            responseMessage = this.buildMessage(exchange, responseHttpCode, codeAllowed);
        } else {
            responseMessage = this.buildMessage(exchange);
        }
        responseMessage.getHeaders().putIfAbsent("CamelHttpResponseCode", responseHttpCode);
        return responseMessage;
    }

    protected abstract Exchange createRequestExchange(org.qubership.automation.itf.core.model.jpa.message.Message var1, ProducerTemplate var2, Map<String, Object> var3, String var4) throws Exception;

    protected abstract Exchange createRequestExchange(org.qubership.automation.itf.core.model.jpa.message.Message var1, ProducerTemplate var2, Map<String, Object> var3, String var4, HttpComponent var5) throws Exception;

    protected abstract Message composeBody(Message var1, org.qubership.automation.itf.core.model.jpa.message.Message var2) throws Exception;

    private boolean getBooleanValue(Object obj) {
        if (obj == null) {
            return false;
        }
        String s = obj.toString();
        return !StringUtils.isBlank((CharSequence)s) && Boolean.parseBoolean(s);
    }

    private void configureDynamicHttpClient(HttpComponent httpComponent, org.qubership.automation.itf.core.model.jpa.message.Message message) {
        HttpClientConfigurer httpClientConfigurer;
        Map headers = message.getHeaders();
        if (headers == null || headers.isEmpty()) {
            return;
        }
        boolean disableRedirects = this.getBooleanValue(headers.get("disableRedirects"));
        boolean trustAll = this.getBooleanValue(headers.get("trustAll"));
        if (!disableRedirects && !trustAll) {
            return;
        }
        String key = this.getCacheKey(String.valueOf(disableRedirects), String.valueOf(trustAll));
        DynamicHttpClientConfigurer dynamicHttpClientConfigurer = (DynamicHttpClientConfigurer)DYNAMIC_HTTP_CLIENT_CONFIGURER_CACHE.getIfPresent((Object)key);
        if (dynamicHttpClientConfigurer == null) {
            dynamicHttpClientConfigurer = this.createDynamicHttpClientConfigurer(disableRedirects, trustAll, key);
        }
        if ((httpClientConfigurer = httpComponent.getHttpClientConfigurer()) == null) {
            httpComponent.setHttpClientConfigurer((HttpClientConfigurer)dynamicHttpClientConfigurer);
        } else if (!dynamicHttpClientConfigurer.equals(httpClientConfigurer)) {
            CompositeHttpConfigurer compositeHttpConfigurer = new CompositeHttpConfigurer();
            compositeHttpConfigurer.addConfigurer(httpClientConfigurer);
            compositeHttpConfigurer.addConfigurer((HttpClientConfigurer)dynamicHttpClientConfigurer);
            httpComponent.setHttpClientConfigurer((HttpClientConfigurer)compositeHttpConfigurer);
        }
    }

    private void configureSendViaProxy(HttpComponent httpComponent, org.qubership.automation.itf.core.model.jpa.message.Message message) {
        Map<String, String> properties = this.getMessageProperties(message);
        if (properties == null) {
            return;
        }
        String host = properties.get("proxyAuthHost");
        if (StringUtils.isBlank((CharSequence)host)) {
            return;
        }
        HttpClientConfigurer httpClientConfigurer = httpComponent.getHttpClientConfigurer();
        if (httpClientConfigurer == null && httpComponent.getHttpConfiguration() == null) {
            String scheme = properties.get("proxyAuthScheme");
            String username = properties.get("proxyAuthUsername");
            String password = properties.get("proxyAuthPassword");
            String domain = properties.get("proxyAuthDomain");
            String ntHost = properties.get("proxyAuthNtHost");
            String portString = properties.get("proxyAuthPort");
            int port = StringUtils.isBlank((CharSequence)portString) ? -1 : Integer.parseInt(portString);
            String key = this.getCacheKey(host, String.valueOf(port), scheme, username, password, domain, ntHost);
            ProxyHttpClientConfigurer proxyHttpClientConfigurer = (ProxyHttpClientConfigurer)PROXY_HTTP_CLIENT_CONFIGURER_CACHE.getIfPresent((Object)key);
            if (proxyHttpClientConfigurer == null) {
                proxyHttpClientConfigurer = this.createProxyHttpClientConfigurer(host, port, scheme, username, password, domain, ntHost, key);
            }
            httpComponent.setHttpClientConfigurer((HttpClientConfigurer)proxyHttpClientConfigurer);
        }
    }

    private boolean isSecure(String schemeOrUrl) {
        return schemeOrUrl.startsWith("https");
    }

    private HttpComponent prepareHttpComponent(boolean isSecure, org.qubership.automation.itf.core.model.jpa.message.Message message) {
        HttpComponent httpComponent = new HttpComponent();
        if (isSecure) {
            this.registerSecureComponent(httpComponent, message);
        }
        return httpComponent;
    }

    private void registerSecureComponent(HttpComponent httpComponent, org.qubership.automation.itf.core.model.jpa.message.Message message) {
        String keyStoreFile = ApplicationConfig.env.getProperty("local.storage.directory", "local.storage.directory").concat("/keystore/keystore.jks");
        String keyStorePassword = ApplicationConfig.env.getProperty("keystore.password");
        String secProtocol = (String)message.getConnectionProperties().get("secureProtocol");
        String sslContextCacheKey = this.getCacheKey(keyStoreFile, keyStorePassword, secProtocol);
        SSLContextParameters sslContext = (SSLContextParameters)SSL_CONTEXT_PARAMETERS_CACHE.getIfPresent((Object)sslContextCacheKey);
        if (sslContext == null) {
            sslContext = this.createSSLContextParameters(keyStoreFile, keyStorePassword, secProtocol, sslContextCacheKey);
        }
        httpComponent.setSslContextParameters(sslContext);
    }

    protected String resolveEndpoint(org.qubership.automation.itf.core.model.jpa.message.Message message, String url) {
        String endpoint = (String)message.getConnectionProperties().get("endpoint");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)endpoint), (Object)"Endpoint can't be null or empty");
        return URI.create(url).resolve("/").resolve(endpoint).toString();
    }

    protected String escapeParameters(String endpoint) {
        int pos = endpoint.indexOf("?");
        if (pos == -1) {
            return endpoint;
        }
        StringBuilder encodedEndpoint = new StringBuilder(endpoint.substring(0, pos));
        String[] pairs = endpoint.substring(pos).split("&");
        int count = 0;
        for (String pair : pairs) {
            int pos1 = pair.indexOf("=");
            if (pos1 > -1) {
                String val = pair.substring(pos1 + 1);
                try {
                    encodedEndpoint.append(count == 0 ? "" : "&").append(pair, 0, pos1).append("=").append(URLEncoder.encode(val, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                encodedEndpoint.append(count == 0 ? "" : "&").append(pair);
            }
            ++count;
        }
        return encodedEndpoint.toString();
    }

    protected Map<String, Object> addDefaultHeaders(org.qubership.automation.itf.core.model.jpa.message.Message message) {
        message.getHeaders().putIfAbsent("CamelHttpMethod", this.method);
        message.getHeaders().putIfAbsent("Content-Type", this.contentType);
        return message.getHeaders();
    }

    protected org.qubership.automation.itf.core.model.jpa.message.Message buildMessage(Exchange exchange, int responseHttpCode, boolean codeAllowed) {
        org.qubership.automation.itf.core.model.jpa.message.Message message = new org.qubership.automation.itf.core.model.jpa.message.Message((String)exchange.getOut().getBody(String.class));
        message.convertAndSetHeaders(exchange.getOut().getHeaders());
        if (codeAllowed) {
            if (message.getText() == null && exchange.getException() != null && exchange.getException() instanceof HttpOperationFailedException) {
                this.processHttpOperationFailedException(exchange, message);
            }
            this.validateResponse(message);
        } else {
            this.responseCodeNotAllowedExceptionProcess(exchange, message, responseHttpCode);
        }
        return message;
    }

    protected org.qubership.automation.itf.core.model.jpa.message.Message buildMessage(Exchange exchange) {
        org.qubership.automation.itf.core.model.jpa.message.Message message = new org.qubership.automation.itf.core.model.jpa.message.Message((String)exchange.getOut().getBody(String.class));
        message.convertAndSetHeaders(exchange.getOut().getHeaders());
        if (exchange.isFailed()) {
            this.exchangeExceptionProcess(exchange, message);
        } else {
            this.validateResponse(message);
        }
        return message;
    }

    private DynamicHttpClientConfigurer createDynamicHttpClientConfigurer(boolean disableRedirects, boolean trustAll, String key) {
        DynamicHttpClientConfigurer dynamicHttpClientConfigurer = new DynamicHttpClientConfigurer();
        dynamicHttpClientConfigurer.setDisableRedirects(disableRedirects);
        dynamicHttpClientConfigurer.setTrustAll(trustAll);
        DYNAMIC_HTTP_CLIENT_CONFIGURER_CACHE.put((Object)key, (Object)dynamicHttpClientConfigurer);
        return dynamicHttpClientConfigurer;
    }

    private ProxyHttpClientConfigurer createProxyHttpClientConfigurer(String host, Integer port, String scheme, String username, String password, String domain, String ntHost, String key) {
        ProxyHttpClientConfigurer httpClientConfigurer = new ProxyHttpClientConfigurer(host, port, scheme, username, password, domain, ntHost);
        PROXY_HTTP_CLIENT_CONFIGURER_CACHE.put((Object)key, (Object)httpClientConfigurer);
        return httpClientConfigurer;
    }

    private SSLContextParameters createSSLContextParameters(String keyStoreFile, String keyStorePassword, String secProtocol, String key) {
        KeyStoreParameters keyStoreParameters = new KeyStoreParameters();
        if (!StringUtils.isBlank((CharSequence)keyStoreFile)) {
            keyStoreParameters.setResource(keyStoreFile);
            keyStoreParameters.setPassword(keyStorePassword);
        }
        KeyManagersParameters keyManagersParameters = new KeyManagersParameters();
        keyManagersParameters.setKeyStore(keyStoreParameters);
        keyManagersParameters.setKeyPassword(keyStorePassword);
        TrustManagersParameters trustManagersParameters = new TrustManagersParameters();
        trustManagersParameters.setKeyStore(keyStoreParameters);
        SSLContextParameters sslContext = new SSLContextParameters();
        sslContext.setKeyManagers(keyManagersParameters);
        sslContext.setTrustManagers(trustManagersParameters);
        sslContext.setSecureSocketProtocol(secProtocol);
        try {
            SSLContextParametersSecureProtocolSocketFactory factory = new SSLContextParametersSecureProtocolSocketFactory(sslContext, CAMEL_CONTEXT);
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)factory, 6443));
            SSL_CONTEXT_PARAMETERS_CACHE.put((Object)key, (Object)sslContext);
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while register http4(https) protocol ", e);
        }
    }

    private String getCacheKey(String ... keys) {
        StringBuilder result = new StringBuilder("_");
        for (String key : keys) {
            result.append(key).append("_");
        }
        return result.toString();
    }

    private void exchangeExceptionProcess(Exchange exchange, org.qubership.automation.itf.core.model.jpa.message.Message message) {
        String exceptionMessage = StringUtils.isBlank((CharSequence)exchange.getException().getMessage()) ? exchange.getException().toString() : exchange.getException().getMessage();
        exceptionMessage = exceptionMessage + (exchange.getException().getCause() != null ? "\nCaused by: " + exchange.getException().getCause().toString() : "\nStacktrace: " + ExceptionUtils.getStackTrace((Throwable)exchange.getException()));
        if (exchange.getException() instanceof HttpOperationFailedException) {
            exceptionMessage = exceptionMessage + this.processHttpOperationFailedException(exchange, message);
        } else if (exchange.getException().getCause() != null && exchange.getException().getCause() instanceof SocketException) {
            exceptionMessage = "Trying to connect to: " + exchange.getFromEndpoint().getEndpointUri() + " - " + exceptionMessage;
        } else {
            message.setText(exceptionMessage);
        }
        message.setFailedMessage(exceptionMessage);
        if (StringUtils.isEmpty((CharSequence)message.getText())) {
            message.setText(exceptionMessage);
        }
    }

    private void responseCodeNotAllowedExceptionProcess(Exchange exchange, org.qubership.automation.itf.core.model.jpa.message.Message message, int responseHttpCode) {
        String exceptionMessage = "HTTP Response code (" + responseHttpCode + ") is not in the allowed range!";
        Exception exception = exchange.getException();
        if (exception instanceof HttpOperationFailedException) {
            exceptionMessage = exceptionMessage + this.processHttpOperationFailedException(exchange, message);
        } else if (exception instanceof HttpHostConnectException) {
            exceptionMessage = exceptionMessage + "\n" + this.processHttpHostConnectException(exchange, message);
        } else if (exception != null) {
            exceptionMessage = exceptionMessage + "\n" + (StringUtils.isBlank((CharSequence)exception.getMessage()) ? exception.toString() : exception.getMessage()) + (exception.getCause() == null ? "\nStacktrace: " + ExceptionUtils.getStackTrace((Throwable)exception) : "\nCaused by: " + exception.getCause().toString());
        }
        message.setFailedMessage(exceptionMessage);
        if (StringUtils.isEmpty((CharSequence)message.getText())) {
            message.setText(exceptionMessage);
        }
    }

    private String processHttpOperationFailedException(Exchange exchange, org.qubership.automation.itf.core.model.jpa.message.Message message) {
        HttpOperationFailedException httpException = (HttpOperationFailedException)exchange.getException();
        HashMap exceptionHeaders = new HashMap(httpException.getResponseHeaders());
        message.convertAndSetHeaders(exceptionHeaders);
        String httpExceptionInfo = this.fillHttpExceptionInfo(httpException);
        message.setText(StringUtils.isBlank((CharSequence)httpException.getResponseBody()) ? "Response body is empty; brief exception info is: " + httpExceptionInfo : httpException.getResponseBody());
        return httpExceptionInfo;
    }

    private String processHttpHostConnectException(Exchange exchange, org.qubership.automation.itf.core.model.jpa.message.Message message) {
        HttpHostConnectException exception = (HttpHostConnectException)exchange.getException();
        message.setText(exception.getMessage() + (exception.getCause() == null ? "" : "\nCaused by: " + exception.getCause().toString()));
        return message.getText();
    }

    private List<MutablePair<Integer, Integer>> computeValidCodeRanges(Map<String, Object> connectionProperties) {
        String allowStatusCodes = (String)this.getOrDefault(connectionProperties, "responseCode", "");
        if (StringUtils.isBlank((CharSequence)allowStatusCodes)) {
            return Config.getConfig().getValidCodeRanges();
        }
        return Config.parseCodeRanges((String)allowStatusCodes);
    }

    private int getResponseCode(Exchange exchange) {
        Exception ex;
        if (exchange.hasOut()) {
            if (exchange.getOut().hasHeaders()) {
                Object strResponseCode = exchange.getOut().getHeader("CamelHttpResponseCode");
                if (strResponseCode instanceof Integer) {
                    return (Integer)strResponseCode;
                }
                try {
                    return Integer.parseInt((String)strResponseCode);
                }
                catch (Exception exception) {}
            }
        } else if (exchange.isFailed() && (ex = exchange.getException()) instanceof HttpOperationFailedException) {
            return ((HttpOperationFailedException)ex).getStatusCode();
        }
        return 0;
    }

    private boolean checkResponseCode(int responseHttpCode, List<MutablePair<Integer, Integer>> validCodeRanges) {
        for (MutablePair<Integer, Integer> range : validCodeRanges) {
            if ((Integer)range.getLeft() > responseHttpCode || (Integer)range.getRight() < responseHttpCode) continue;
            return true;
        }
        return false;
    }

    protected String fillHttpExceptionInfo(HttpOperationFailedException httpException) {
        String msg = "";
        msg = msg + this.addIfNotEmpty("\nResponse body: ", httpException.getResponseBody());
        msg = msg + this.addIfNotEmpty("\nStatus code: ", httpException.getStatusCode());
        msg = msg + this.addIfNotEmpty("\nStatus text: ", httpException.getStatusText());
        msg = msg + this.addIfNotEmpty("\nURI: ", httpException.getUri());
        msg = msg + this.addIfNotEmpty("\nError message: ", httpException.getMessage());
        return msg;
    }

    private String addIfNotEmpty(String title, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        return title + value;
    }

    private String addIfNotEmpty(String title, int value) {
        if (value == 0) {
            return "";
        }
        return title + value;
    }

    protected void validateResponse(org.qubership.automation.itf.core.model.jpa.message.Message message) {
    }

    protected void validateRequest(org.qubership.automation.itf.core.model.jpa.message.Message message) {
    }

    protected Processor fillOutputExchange(org.qubership.automation.itf.core.model.jpa.message.Message message, Map<String, Object> headers) {
        return exchange -> {
            Message in = exchange.getIn();
            in.getHeaders().putAll(headers);
            in.setHeader("CamelHttpMethod", this.getOrDefault(message.getConnectionProperties(), "method", this.method));
            in.setHeader("Content-Type", this.getOrDefault(message.getConnectionProperties(), "contentType", this.contentType));
            if (headers.getOrDefault("forceHTTP1.0", "false").equals("true")) {
                in.setHeader("CamelHttpProtocolVersion", (Object)HttpVersion.HTTP_1_0);
            }
            this.composeBody(in, message);
            this.removeHeadersIfConfigured(in, message);
            message.addConnectionProperty("Resolved_Endpoint_URL", (Object)in.getExchange().getFromEndpoint().toString());
            message.convertAndSetHeaders(in.getHeaders());
        };
    }

    protected Map<String, String> getMessageProperties(org.qubership.automation.itf.core.model.jpa.message.Message itfMessage) {
        Object obj = itfMessage.getConnectionProperties().get("properties");
        if (obj == null || obj instanceof String) {
            return null;
        }
        Map properties = (Map)obj;
        if (properties.isEmpty()) {
            return null;
        }
        return properties;
    }

    protected void removeHeadersIfConfigured(Message camelMessage, org.qubership.automation.itf.core.model.jpa.message.Message itfMessage) {
        String[] list;
        Map<String, String> properties = this.getMessageProperties(itfMessage);
        if (properties == null) {
            return;
        }
        String removeHeaders = properties.get("removeHeaders");
        if (StringUtils.isBlank((CharSequence)removeHeaders)) {
            return;
        }
        for (String elem : list = removeHeaders.split(",")) {
            if (StringUtils.isBlank((CharSequence)elem)) continue;
            camelMessage.removeHeader(elem);
            itfMessage.getHeaders().remove(elem);
        }
    }

    private Object getOrDefault(Map<String, Object> properties, String key, String defaultValue) {
        Object value = properties.get(key);
        return value == null || "".equals(value.toString()) ? defaultValue : value;
    }

    static {
        ITFHeaderFilterStrategy.setOutFilter(null);
        ITFHeaderFilterStrategy.setInFilter(null);
    }
}

