/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.http2.inbound;

import java.util.Map;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.transport.base.AbstractInboundTransportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UserName(value="Inbound HTTP2 Synchronous")
public class HTTP2InboundTransport
extends AbstractInboundTransportImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTP2InboundTransport.class);
    @Parameter(shortName="endpoint", longName="Endpoint URI", description="Endpoint URI, e.g. /mb/test/endpoint")
    protected String endpointUri;
    @Parameter(shortName="responseCode", longName="Response Code", description="responseCode", fromServer=true, forTemplate=true, isDynamic=true)
    protected Integer allowStatus;
    @Parameter(shortName="headers", longName="Response Headers", description="SomeHeader=SomeValue\nContent-Type=text/html", optional=true, forTemplate=true, isDynamic=true)
    protected Map<String, Object> headers;
    @Parameter(shortName="addProjectUuidEndpointPrefix", longName="Add Project UUID Prefix into Endpoint", description="Add Project UUID Prefix into Endpoint? - Yes (default) /No", optional=true)
    @Options(value={"No", "Yes"})
    protected String addProjectUuidEndpointPrefix = "Yes";
    @Parameter(shortName="isStub", longName="Is Stub", description="Is Stub: Default=No", optional=true)
    @Options(value={"No", "Yes"})
    protected String isStub = "No";
    @Parameter(shortName="remoteIp", longName="Local host", description="Local host IP or name")
    private String host;
    @Parameter(shortName="remotePort", longName="Local Port", description="Local port")
    private Integer port;

    public Mep getMep() {
        return Mep.INBOUND_REQUEST_RESPONSE_SYNCHRONOUS;
    }

    public String getEndpointPrefix() {
        return "";
    }

    public String getShortName() {
        return "HTTP2 Inbound";
    }
}

