/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.http2.outbound;

import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.transport.camel.outbound.AbstractCamelOutboundTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UserName(value="Outbound HTTP2 Synchronous")
public class HTTP2OutboundTransport
extends AbstractCamelOutboundTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTP2OutboundTransport.class);
    @Parameter(shortName="endpoint", longName="Http Endpoint", description="Endpoint URI, e.g. /mb/test/endpoint", forTemplate=true, isDynamic=true)
    protected String endpoint;
    @Parameter(shortName="method", longName="Method", description="HTTP Method", forTemplate=true)
    @Options(value={"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE", "PATCH"})
    private String method = "GET";
    @Parameter(shortName="remoteIp", longName="Remote host", description="Remote host IP or name", isDynamic=true)
    private String host;
    @Parameter(shortName="responseCode", longName="Allow Status Code", description="Allowed status code for response (range like '200-299' or '200-200')", forTemplate=true, forServer=false, optional=true, isDynamic=true)
    private String allowStatus;
    @Parameter(shortName="remotePort", longName="Remote Port", description="Remote port", isDynamic=true)
    private String port;
    @Parameter(shortName="headers", longName="Http Request Headers", description="SomeHeader=SomeValue\nContent-Type=text/html", optional=true, forTemplate=true, isDynamic=true)
    private Map<String, String> headers = new HashMap<String, String>();
    private ConnectionProperties connectionProperties;

    public String getShortName() {
        return "HTTP2 Outbound";
    }

    public String getEndpointPrefix() {
        return "/mockingbird-transport-http2";
    }

    public Mep getMep() {
        return Mep.OUTBOUND_REQUEST_RESPONSE_SYNCHRONOUS;
    }

    public Message sendReceiveSync(Message message, BigInteger projectId) throws Exception {
        Call call;
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ConnectionProperties connectionProperties = (ConnectionProperties)message.getConnectionProperties();
        if (this.connectionProperties == null || !this.connectionProperties.equals((Object)connectionProperties)) {
            this.connectionProperties = connectionProperties;
        }
        String resolvedEndpoint = this.resolveEndpoint(connectionProperties);
        connectionProperties.put((Object)"Resolved_Endpoint_URL", (Object)resolvedEndpoint);
        OkHttpClient client = new OkHttpClient().newBuilder().protocols(Collections.singletonList(Protocol.H2_PRIOR_KNOWLEDGE)).build();
        RequestBody formBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)message.getText());
        if (connectionProperties.get((Object)"headers") != null) {
            Headers headersMap = Headers.of((Map)((Map)connectionProperties.get((Object)"headers")));
            call = client.newCall(new Request.Builder().url(resolvedEndpoint).method(connectionProperties.get((Object)"method").toString(), formBody).headers(headersMap).build());
        } else {
            call = client.newCall(new Request.Builder().url(resolvedEndpoint).post(formBody).build());
        }
        Response response = call.execute();
        int responseHttpCode = response.code();
        Message responseMessage = new Message();
        responseMessage.setText(response.body() == null ? "" : response.body().string());
        responseMessage.convertAndSetMultiHeaders(response.headers().toMultimap());
        responseMessage.getHeaders().put("CamelHttpResponseCode", responseHttpCode);
        List<MutablePair<Integer, Integer>> validCodeRanges = this.computeValidCodeRanges(message.getConnectionProperties());
        if (!validCodeRanges.isEmpty()) {
            boolean codeAllowed = this.checkResponseCode(responseHttpCode, validCodeRanges);
            if (codeAllowed) {
                if (responseMessage.getText() == null) {
                    responseMessage.setFailedMessage(response.toString());
                }
            } else {
                this.setFailedMessage(response, responseMessage);
            }
        } else if (!response.isSuccessful()) {
            this.setFailedMessage(response, responseMessage);
        }
        return responseMessage;
    }

    public String viewEndpoint(ConnectionProperties connectionProperties) {
        return null;
    }

    private String resolveEndpoint(ConnectionProperties connectionProperties) {
        return "http://" + connectionProperties.get((Object)"remoteIp") + ":" + connectionProperties.get((Object)"remotePort") + connectionProperties.get((Object)"endpoint");
    }

    private List<MutablePair<Integer, Integer>> computeValidCodeRanges(Map<String, Object> connectionProperties) {
        String allowStatusCodes = (String)this.getOrDefault(connectionProperties, "responseCode", "");
        if (StringUtils.isBlank((CharSequence)allowStatusCodes)) {
            return Config.getConfig().getValidCodeRanges();
        }
        return Config.parseCodeRanges((String)allowStatusCodes);
    }

    private Object getOrDefault(Map<String, Object> properties, String key, String defaultValue) {
        Object value = properties.get(key);
        return value == null || "".equals(value.toString()) ? defaultValue : value;
    }

    private boolean checkResponseCode(int responseHttpCode, List<MutablePair<Integer, Integer>> validCodeRanges) {
        for (MutablePair<Integer, Integer> range : validCodeRanges) {
            if ((Integer)range.getLeft() > responseHttpCode || (Integer)range.getRight() < responseHttpCode) continue;
            return true;
        }
        return false;
    }

    public void setFailedMessage(Response response, Message responseMessage) {
        if (responseMessage.getText() == null) {
            responseMessage.setFailedMessage(response.toString());
        } else {
            responseMessage.setFailedMessage(responseMessage.getText());
        }
    }
}

