/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.jms.outbound;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.annotation.Async;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.helper.Reflection;
import org.qubership.automation.itf.transport.camel.CamelContextProvider;
import org.qubership.automation.itf.transport.camel.outbound.AbstractCamelOutboundTransport;
import org.qubership.automation.itf.transport.jms.JmsHelper;
import org.qubership.automation.itf.transport.jms.outbound.JMSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Async
@UserName(value="Outbound JMS Asynchronous")
public class JMSOutboundTransport
extends AbstractCamelOutboundTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMSOutboundTransport.class);
    private static final String CONFIGURATION_EXCEPTION = "Error configuring transport to send JMS Message";
    private static final String MESSAGE_SENDING_EXCEPTION = "Error sending JMS Message: ";
    private static final String CONNECTING_EXCEPTION = "Error while making Jms outbound connection: ";
    private static final LoadingCache<ConfiguredTransport, JMSConfig> CONFIG_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).removalListener(removalNotification -> {
        if (removalNotification.getCause().equals((Object)RemovalCause.EXPIRED)) {
            JMSOutboundTransport.removeComponentById((ConfiguredTransport)removalNotification.getKey());
        }
    }).build((CacheLoader)new CacheLoader<ConfiguredTransport, JMSConfig>(){

        public JMSConfig load(@Nonnull ConfiguredTransport id) throws Exception {
            try {
                JMSOutboundTransport.removeComponentById(id);
                String destinationName = (String)id.getProperties().get("destination");
                String destinationType = (String)id.getProperties().get("destinationType");
                String componentId = id.getComponentId();
                JMSConfig jmsConfig = JMSOutboundTransport.initConnectionProperties(id.getProperties(), componentId, destinationName);
                ProducerTemplate producer = CamelContextProvider.CAMEL_CONTEXT.createProducerTemplate();
                producer.start();
                jmsConfig.setProducer(producer);
                Endpoint endpoint = JMSOutboundTransport.makeEndpoint(componentId, destinationType.toLowerCase(), destinationName, jmsConfig, CamelContextProvider.CAMEL_CONTEXT);
                jmsConfig.setEndpoint(endpoint);
                return jmsConfig;
            }
            catch (Exception e) {
                LOGGER.error(JMSOutboundTransport.CONFIGURATION_EXCEPTION, (Throwable)e);
                throw new Exception(JMSOutboundTransport.CONFIGURATION_EXCEPTION, e);
            }
        }
    });
    private static final ScheduledExecutorService configCacheMaintenanceService = Executors.newSingleThreadScheduledExecutor();
    private static boolean isCacheCleanupScheduled = false;
    @Parameter(shortName="destinationType", longName="JMS destination type. Queue/Topic", description="Queue or Topic", forServer=false, isRedefined=true)
    @Options(value={"Queue", "Topic"})
    private String destinationType;
    @Parameter(shortName="destination", longName="Out Data Destination", description="For cluser:NCJMSServer_clust1/NCJMSModule!queue_xxx\nFor non cluster:NCJMSModule!queue_xxx", forServer=false, isRedefined=true)
    private String destination;
    @Parameter(shortName="connectionFactory", longName="Out Connection Factory", description="jms_xxx_xxx", isRedefined=true)
    private String connectionFactoryName;
    @Parameter(shortName="credentials", longName="Security Credentials", description="Password or empty", optional=true)
    private String credentials;
    @Parameter(shortName="principal", longName="Security Principal", description="UserName", optional=true)
    private String principal;
    @Parameter(shortName="initialContextFactory", longName="Initial Context Factory", description="weblogic.jndi.WLInitialContextFactory", isRedefined=true)
    private String initialContextFactory;
    @Parameter(shortName="addJndiProps", longName="Additional JNDI Properties", description="aaa=bbb\nccc=ddd", optional=true)
    private Map<String, String> addJndiProps;
    @Parameter(shortName="authentication", longName="Authentication", description="Simple or empty", optional=true)
    private String authentication;
    @Parameter(shortName="providerUrl", longName="Provider URL", description="URL or empty\nURL...", fromServer=true, isDynamic=true)
    private String providerUrl;
    @Parameter(shortName="jmsHeaders", longName="JMS Headers", description="aaa=bbb\nccc=ddd", optional=true, isDynamic=true)
    private Map<String, String> jmsHeaders;

    private static void removeComponentById(ConfiguredTransport id) {
        String componentId = id.getComponentId();
        if (CAMEL_CONTEXT.hasComponent(componentId) != null) {
            CAMEL_CONTEXT.removeComponent(componentId);
        }
    }

    private static JMSConfig initConnectionProperties(TreeMap<String, Object> connectionProperties, String id, String destinationName) throws NamingException {
        ConnectionFactory factory;
        String connectionFactory = (String)connectionProperties.get("connectionFactory");
        Destination remoteDestination = null;
        try (InitialContext initialContext = null;){
            initialContext = JMSOutboundTransport.createContext(connectionProperties);
            factory = (ConnectionFactory)initialContext.lookup(connectionFactory);
            if (JmsHelper.isJNDIName(destinationName)) {
                remoteDestination = (Destination)initialContext.lookup(destinationName);
            }
        }
        JmsComponent component = JmsComponent.jmsComponent((ConnectionFactory)factory);
        CAMEL_CONTEXT.addComponent(id, (Component)component);
        return new JMSConfig(component, remoteDestination);
    }

    private static Endpoint makeEndpoint(String id, String destinationType, String destinationName, JMSConfig jmsConfig, CamelContext context) throws JMSException {
        Object endpoint = jmsConfig.getDestination() != null ? JmsEndpoint.newInstance((Destination)jmsConfig.getDestination(), (JmsComponent)jmsConfig.getComponent()) : context.getEndpoint(id + ':' + destinationType + ':' + destinationName);
        return endpoint;
    }

    private static InitialContext createContext(TreeMap<String, Object> connectionProperties) throws NamingException {
        Properties env = new Properties();
        JmsHelper.putSafe(env, "java.naming.factory.initial", connectionProperties.get("initialContextFactory"));
        JmsHelper.putSafe(env, "java.naming.security.principal", connectionProperties.get("principal"));
        JmsHelper.putSafe(env, "java.naming.security.credentials", connectionProperties.get("credentials"));
        String[] providers = (String[])Reflection.toArray(String.class, (String)((String)connectionProperties.get("providerUrl")));
        if (providers == null || providers.length < 1) {
            throw new IllegalStateException("Provider URL is not defined");
        }
        if (providers[0].isEmpty()) {
            throw new IllegalStateException("Provider URL is empty. Please check Server config (Environment tab).");
        }
        JmsHelper.putSafe(env, "java.naming.provider.url", providers[0]);
        JmsHelper.putSafe(env, "java.naming.security.authentication", connectionProperties.get("authentication"));
        if (connectionProperties.get("addJndiProps") != null) {
            env.putAll((Map<?, ?>)((Map)connectionProperties.get("addJndiProps")));
        }
        return new InitialContext(env);
    }

    public String send(Message message, String sessionId, UUID projectUuid) throws Exception {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ConnectionProperties properties = new ConnectionProperties(message.getConnectionProperties());
        properties.remove((Object)"ContextId");
        String destinationName = (String)properties.obtain("destination");
        String destinationType = (String)properties.get((Object)"destinationType");
        if (Strings.isNullOrEmpty((String)destinationType) || StringUtils.isBlank((CharSequence)destinationName)) {
            throw new IllegalArgumentException("'Destination type' and 'Destination' can't be empty");
        }
        String transportId = (String)message.getConnectionProperties().get("transportId");
        ConfiguredTransport configuredTransport = new ConfiguredTransport(transportId, properties);
        JMSConfig jmsConfig = (JMSConfig)CONFIG_CACHE.get((Object)configuredTransport);
        try {
            Processor processor = this.getProcessor(message, properties);
            Exchange exchange = jmsConfig.getProducer().send(jmsConfig.getEndpoint(), processor);
            if (exchange.isFailed()) {
                if (exchange.getException().getCause() == null) {
                    throw exchange.getException();
                }
                throw new Exception(exchange.getException().getMessage(), exchange.getException().getCause());
            }
        }
        catch (Exception e) {
            LOGGER.error(MESSAGE_SENDING_EXCEPTION, (Throwable)e);
            if (e.getCause() == null) {
                throw new Exception(MESSAGE_SENDING_EXCEPTION + e.getMessage());
            }
            throw new Exception(MESSAGE_SENDING_EXCEPTION + e.getMessage(), e.getCause());
        }
        finally {
            this.scheduleCacheCleanupIfNeeded();
        }
        return null;
    }

    private synchronized void scheduleCacheCleanupIfNeeded() {
        if (!isCacheCleanupScheduled && CONFIG_CACHE.size() > 0L) {
            configCacheMaintenanceService.scheduleWithFixedDelay(() -> {
                try {
                    CONFIG_CACHE.cleanUp();
                }
                catch (Throwable t) {
                    LOGGER.error("Error while JmsOutboundTransport cache cleanUp: {}", (Object)t.toString());
                }
            }, 61L, 20L, TimeUnit.MINUTES);
            isCacheCleanupScheduled = true;
        }
    }

    private Processor getProcessor(Message message, ConnectionProperties connectionProperties) {
        return exchange -> {
            HashMap headers = Maps.newHashMapWithExpectedSize((int)message.getHeaders().size());
            headers.putAll(message.getHeaders());
            Map properties = (Map)connectionProperties.get((Object)"jmsHeaders");
            if (properties != null && !properties.isEmpty()) {
                headers.putAll(properties);
            }
            exchange.getIn().setHeaders((Map)headers);
            exchange.getIn().setBody((Object)message.getText());
        };
    }

    public Mep getMep() {
        return Mep.OUTBOUND_REQUEST_ASYNCHRONOUS;
    }

    public String getEndpointPrefix() {
        return "/mockingbird-transport-jms";
    }

    public String getShortName() {
        return "JMS Outbound";
    }

    public String viewEndpoint(ConnectionProperties connectionProperties) {
        return null;
    }

    public void start() {
        super.start();
    }

    private class ConfiguredTransport {
        private TreeMap<String, Object> properties;
        private String componentId;
        private String transportId;

        public ConfiguredTransport(String transportId, ConnectionProperties properties) {
            this.transportId = transportId;
            this.setComponentId();
            this.properties = new TreeMap(properties);
        }

        private void setComponentId() {
            this.componentId = "out" + this.transportId + "-" + UUID.randomUUID();
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.transportId);
            hash = 97 * hash + Objects.hashCode(this.properties);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfiguredTransport other = (ConfiguredTransport)obj;
            if (!Objects.equals(this.transportId, other.transportId)) {
                return false;
            }
            return Objects.equals(this.properties, other.properties);
        }

        public TreeMap<String, Object> getProperties() {
            return this.properties;
        }

        public String getComponentId() {
            return this.componentId;
        }

        public String getTransportId() {
            return this.transportId;
        }

        public void setTransportId(String transportId) {
            this.transportId = transportId;
        }
    }
}

