/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.jms;

import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WLInitialContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(WLInitialContext.class);

    public static synchronized InitialContext init(String principal, String auth, String credentials, String brokerUrl, Map<String, String> customProperties) {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        env.put("java.naming.security.principal", principal);
        env.put("java.naming.security.authentication", auth);
        env.put("java.naming.security.credentials", credentials);
        env.put("java.naming.provider.url", brokerUrl);
        if (customProperties != null) {
            env.putAll(customProperties);
        }
        try {
            return new InitialContext(env);
        }
        catch (NamingException e) {
            LOGGER.error("Failed initialization of WL InitialContext", (Throwable)e);
            throw new IllegalStateException("InitialContext is not initialized");
        }
    }
}

