/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.jms.inbound;

import java.util.Map;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.transport.base.AbstractInboundTransportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UserName(value="Inbound JMS Asynchronous")
public class JMSInboundTransport
extends AbstractInboundTransportImpl {
    public static final Logger LOGGER = LoggerFactory.getLogger(JMSInboundTransport.class);
    @Parameter(shortName="providerUrl", longName="Provider URL", description="URL or empty\nURL...", fromServer=true)
    protected String providerUrl;
    @Parameter(shortName="messageSelector", longName="Message selector", description="For example: test=%A ...or empty\n", fromServer=true, optional=true)
    protected String messageSelector;
    @Parameter(shortName="destination", longName="In Data Destination", description="For cluser:NCJMSServer_clust1/NCJMSModule!queue_xxx\nFor non cluster:NCJMSModule!queue_xxx")
    protected String destination;
    @Parameter(shortName="principal", longName="Principal", description="UserName", optional=true)
    protected String principal;
    @Parameter(shortName="authentication", longName="Authentication", description="Simple or empty", optional=true)
    protected String authentication;
    @Parameter(shortName="credentials", longName="Credentials", description="Password or empty", optional=true)
    protected String credentials;
    @Parameter(shortName="connectionFactory", longName="Connection Factory Name", description="jms_xxx_xxx")
    protected String connectionFactoryName;
    @Parameter(shortName="initialContextFactory", longName="Initial Context Factory", description="weblogic.jndi.WLInitialContextFactory")
    protected String initialContextFactory;
    @Parameter(shortName="addJndiProps", longName="Additional JNDI Properties", description="aaa=bbb\nccc=ddd", optional=true)
    protected Map<String, String> addJndiProps;
    @Parameter(shortName="destinationType", longName="JMS destination type. Queue/Topic", description="Queue or Topic")
    @Options(value={"Queue", "Topic"})
    protected String destinationType;
    @Parameter(shortName="recoveryInterval", longName="Connection Recovery Interval", description="Time between reconnection attempts in milliseconds", optional=true)
    protected String recoveryInterval;
    @Parameter(shortName="maxAttempts", longName="Connection Max Attempts", description="Total maximum reconnection attempts: unlimited or numerical value", optional=true)
    protected String maxAttempts;

    public String getShortName() {
        return "JMS Inbound";
    }

    public Mep getMep() {
        return Mep.INBOUND_REQUEST_ASYNCHRONOUS;
    }

    public String getEndpointPrefix() {
        return "/mockingbird-transport-jms";
    }
}

