/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.ldap.outbound;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.transport.base.AbstractTransportImpl;
import org.qubership.automation.itf.core.util.transport.base.OutboundTransport;
import org.qubership.automation.itf.transport.camel.Helper;

public class LdapOutboundTransport
extends AbstractTransportImpl
implements OutboundTransport {
    @Parameter(shortName="initialContextFactory", longName="Initial Context Factory", description="For example, com.sun.jndi.ldap.LdapCtxFactory", isRedefined=true)
    private String initialContextFactory;
    @Parameter(shortName="providerUrl", longName="Provider URL", description="For example, ldap://some.ldap.server:389", fromServer=true)
    private String providerUrl;
    @Parameter(shortName="authentication", longName="Authentication", description="Variants are: 'none' (=anonymous), 'simple' (weak authentication) or a space-separated list of SASL mechanism names", optional=true)
    private String authentication;
    @Parameter(shortName="principal", longName="Security Principal", description="For example, cn=Manager; can be empty if Authentication=none", optional=true)
    private String principal;
    @Parameter(shortName="credentials", longName="Security Credentials", description="Password; can be empty", optional=true)
    private String credentials;
    @Parameter(shortName="addJndiProps", longName="Additional JNDI Properties", description="Extra JNDI properties, format is name=value, on the separate row each", optional=true)
    private Map<String, String> addJndiProps;
    @Parameter(shortName="outputFormat", longName="Search results formatting", description="Response Format (for search requests only); LDIF (default) or JSON formats are supported", optional=true)
    @Options(value={"LDIF", "JSON"})
    private String outputFormat;
    @Parameter(shortName="responseCode", longName="Allow Status Code", description="Regexp to test LDAP server response; please leave blank if only success is allowed", forTemplate=true, optional=true)
    private String allowStatus;

    public String getShortName() {
        return "Ldap Outbound";
    }

    public Message sendReceiveSync(Message message, BigInteger projectId) throws Exception {
        Exchange out;
        boolean isSearchRequest;
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ConnectionProperties connectionProperties = (ConnectionProperties)message.getConnectionProperties();
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", (String)connectionProperties.get((Object)"initialContextFactory"));
        props.setProperty("java.naming.provider.url", (String)connectionProperties.get((Object)"providerUrl"));
        props.setProperty("java.naming.security.authentication", (String)connectionProperties.getOrDefault((Object)"authentication", (Object)"none"));
        props.setProperty("java.naming.security.principal", (String)connectionProperties.get((Object)"principal"));
        props.setProperty("java.naming.security.credentials", (String)connectionProperties.get((Object)"credentials"));
        if (connectionProperties.get((Object)"addJndiProps") != null) {
            props.putAll((Map<?, ?>)((Map)connectionProperties.get((Object)"addJndiProps")));
        }
        Object jsonMessage = null;
        String changeType = null;
        try {
            JSONParser parser = new JSONParser();
            jsonMessage = parser.parse(message.getText());
            isSearchRequest = jsonMessage instanceof JSONObject ? (changeType = (String)((JSONObject)jsonMessage).get((Object)"changetype")) == null : true;
        }
        catch (ParseException e) {
            isSearchRequest = true;
        }
        if (!isSearchRequest) {
            return this.sendChangeRequest((JSONObject)jsonMessage, props, changeType, (String)connectionProperties.getOrDefault((Object)"responseCode", (Object)""));
        }
        String outputFormat = (String)connectionProperties.getOrDefault((Object)"outputFormat", (Object)"LDIF");
        final String base = (String)props.getOrDefault((Object)"base", "ou=system");
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)"itfldap", (Object)new InitialLdapContext(props, null));
        DefaultCamelContext context = new DefaultCamelContext((Registry)registry);
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("ldap:itfldap?base=" + base);
            }
        });
        context.start();
        ProducerTemplate template = context.createProducerTemplate();
        Endpoint endpoint = context.getEndpoint("direct:start");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)message.getText());
        try {
            out = template.send(endpoint, exchange);
            if (out.isFailed()) {
                throw out.getException();
            }
        }
        catch (Exception e) {
            context.stop();
            throw new Exception("Error sending/processing of LDAP search request", e);
        }
        Collection data = (Collection)out.getOut().getBody(Collection.class);
        Message response = new Message(this.dataToString(data, outputFormat));
        response.convertAndSetHeaders(exchange.getOut().getHeaders());
        context.stop();
        return response;
    }

    private Message sendChangeRequest(JSONObject jsonMessage, Properties props, String changeType, String allowStatus) throws Exception {
        try (InitialDirContext ctx = new InitialDirContext(props);){
            String name = (String)jsonMessage.get((Object)"dn");
            switch (changeType) {
                case "modify": {
                    ModificationItem[] mods = this.populateModificationItems(jsonMessage);
                    if (mods != null && mods.length > 0) {
                        ctx.modifyAttributes(name, mods);
                        break;
                    }
                    throw new Exception("Invalid '" + changeType + "' LDAP request: no add/replace/delete actions are found");
                }
                case "delete": {
                    ctx.destroySubcontext(name);
                    break;
                }
                case "add": {
                    BasicAttributes attrs = this.populateAttributes(jsonMessage);
                    ctx.createSubcontext(name, (Attributes)attrs);
                    break;
                }
                case "moddn": {
                    BasicAttributes attrs = this.populateAttributes(jsonMessage);
                    this.moveToAnotherSuperior(ctx, name, (String)attrs.get("newsuperior").get(), "newsuperior");
                    break;
                }
                case "modrdn": {
                    BasicAttributes attrs = this.populateAttributes(jsonMessage);
                    this.renameUnderTheSameSuperior(ctx, name, (String)attrs.get("newrdn").get(), "newrdn");
                    break;
                }
                default: {
                    throw new Exception("Unknown type of LDAP modification request: " + changeType);
                }
            }
            String string = this.checkAllowedStatusCode(true, null, allowStatus);
            return string;
        }
    }

    private Message checkAllowedStatusCode(boolean success, NamingException ex, String allowStatus) throws Exception {
        String successMessage = "Changes are applied successfully";
        if (allowStatus.isEmpty()) {
            if (success) {
                return new Message(successMessage);
            }
            throw new Exception("NamingException while processing of LDAP change request", ex);
        }
        if (success) {
            if (successMessage.matches(allowStatus)) {
                return new Message(successMessage + "\nSuccess because matches 'Allow status code' configured: " + allowStatus);
            }
            throw new Exception(successMessage + "\nFail because doesn't match 'Allow status code' configured: " + allowStatus);
        }
        if (ex.getExplanation().matches(allowStatus)) {
            return new Message("LDAP exception explanation: " + ex.getExplanation() + "\nSuccess because matches 'Allow status code' configured: " + allowStatus + "\nFull message: " + ex);
        }
        throw new Exception("LDAP exception explanation: " + ex.getExplanation() + "Fail because doesn't match 'Allow status code' configured: " + allowStatus, ex);
    }

    private void moveToAnotherSuperior(DirContext ctx, String name, String newSuperior, String propName) throws Exception {
        LdapName oldLdapName = new LdapName(name);
        List<Rdn> oldRdns = oldLdapName.getRdns();
        int oldRdnsCount = oldRdns.size();
        if (oldRdnsCount == 0) {
            throw new Exception("moddn request: invalid parsing results for 'dn' LDAP name: " + name);
        }
        if (StringUtils.isBlank((CharSequence)newSuperior)) {
            throw new Exception("moddn request: '" + propName + "' value is null or empty");
        }
        LdapName newLdapSuperior = new LdapName(newSuperior);
        List<Rdn> newSuperiorRdns = newLdapSuperior.getRdns();
        int newRdnsCount = newSuperiorRdns.size();
        if (newRdnsCount == 0) {
            throw new Exception("moddn request: invalid parsing results for '" + propName + "' LDAP name: " + newSuperior);
        }
        ArrayList<Rdn> newRdns = new ArrayList<Rdn>(newSuperiorRdns);
        newRdns.add(oldRdns.get(oldRdnsCount - 1));
        LdapName newLdapName = new LdapName(newRdns);
        ctx.rename(oldLdapName, newLdapName);
    }

    private void renameUnderTheSameSuperior(DirContext ctx, String name, String newRdn, String propName) throws Exception {
        LdapName oldLdapName = new LdapName(name);
        List<Rdn> oldRdns = oldLdapName.getRdns();
        int rdnsCount = oldRdns.size();
        if (rdnsCount == 0) {
            throw new Exception("modrdn request: invalid parsing results for 'dn' LDAP name: " + name);
        }
        if (StringUtils.isBlank((CharSequence)newRdn)) {
            throw new Exception("modrdn request: '" + propName + "' value is null or empty");
        }
        Rdn rdn = new Rdn(newRdn);
        ArrayList<Rdn> newRdns = new ArrayList<Rdn>(oldRdns.subList(0, rdnsCount - 1));
        newRdns.add(rdn);
        LdapName newLdapName = new LdapName(newRdns);
        ctx.rename(oldLdapName, newLdapName);
    }

    private ModificationItem[] populateModificationItems(JSONObject jsonMessage) {
        BasicAttributes attrs = this.populateAttributes(jsonMessage);
        if (attrs.size() == 0) {
            return null;
        }
        List<ModificationItem> listItems = this.populateModificationItems(attrs, attrs.get("add"), 1);
        listItems.addAll(this.populateModificationItems(attrs, attrs.get("replace"), 2));
        listItems.addAll(this.populateModificationItems(attrs, attrs.get("delete"), 3));
        ModificationItem[] items = new ModificationItem[listItems.size()];
        return listItems.toArray(items);
    }

    private List<ModificationItem> populateModificationItems(BasicAttributes attrs, Attribute namesList, int action) {
        ArrayList<ModificationItem> listItems = new ArrayList<ModificationItem>();
        if (namesList != null) {
            for (int i = 0; i < namesList.size(); ++i) {
                try {
                    String curname = (String)namesList.get(i);
                    Attribute attr = attrs.get(curname);
                    if (attr == null) continue;
                    listItems.add(new ModificationItem(action, attr));
                    continue;
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        return listItems;
    }

    private BasicAttributes populateAttributes(JSONObject jsonMessage) {
        BasicAttributes attrs = new BasicAttributes();
        jsonMessage.forEach((key, value) -> {
            if (!(key.equals("changetype") || key.equals("dn") || key.equals("inet-bandwidth"))) {
                BasicAttribute attr;
                if (value instanceof List) {
                    attr = new BasicAttribute((String)key);
                    ((List)value).forEach(attr::add);
                } else {
                    attr = new BasicAttribute((String)key, value);
                }
                attrs.put(attr);
            }
        });
        return attrs;
    }

    private String dataToString(Collection<SearchResult> data, String outputFormat) throws NamingException {
        if (outputFormat.equals("LDIF")) {
            return data.toString();
        }
        ArrayList dataList = new ArrayList();
        for (SearchResult item : data) {
            HashMap<String, Object> mapItem = new HashMap<String, Object>();
            mapItem.put("boundObj", item.getObject());
            mapItem.put("name", item.getName());
            mapItem.put("className", item.getClassName());
            mapItem.put("fullName", item.getNameInNamespace());
            mapItem.put("isRel", item.isRelative());
            mapItem.put("attrs_ignoreCase", item.getAttributes().isCaseIgnored());
            HashMap<String, Object> itemAttrs = new HashMap<String, Object>();
            Attributes attributes = item.getAttributes();
            NamingEnumeration<String> attrIdEnum = attributes.getIDs();
            while (attrIdEnum.hasMoreElements()) {
                String attrId = attrIdEnum.next();
                Attribute attr = attributes.get(attrId);
                NamingEnumeration<?> attrValuesEnum = attr.getAll();
                ArrayList<String> values = new ArrayList<String>();
                while (attrValuesEnum.hasMore()) {
                    values.add(attrValuesEnum.next().toString());
                }
                if (values.isEmpty()) continue;
                if (values.size() == 1) {
                    itemAttrs.put(attrId, values.get(0));
                    continue;
                }
                itemAttrs.put(attrId, values);
            }
            mapItem.put("attrs", itemAttrs);
            dataList.add(mapItem);
        }
        return String.valueOf(Helper.GSON.toJsonTree(dataList));
    }

    public String viewEndpoint(ConnectionProperties connectionProperties) {
        return null;
    }

    public Mep getMep() {
        return Mep.OUTBOUND_REQUEST_RESPONSE_SYNCHRONOUS;
    }

    public String getEndpointPrefix() {
        return null;
    }
}

