/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.rest.outbound;

import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.http4.HttpComponent;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.http.common.HttpOperationFailedException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.annotation.Async;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.transport.http.Helper;
import org.qubership.automation.itf.transport.http.outbound.HTTPOutboundTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Async
@UserName(value="Outbound REST Synchronous")
public class RESTOutboundTransport
extends HTTPOutboundTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(RESTOutboundTransport.class);

    public String viewEndpoint(ConnectionProperties connectionProperties) {
        return null;
    }

    protected Exchange createRequestExchange(org.qubership.automation.itf.core.model.jpa.message.Message message, ProducerTemplate template, Map<String, Object> headers, String endpoint) {
        int loopIndex = 0;
        boolean autoRedirect = this.checkRemoveFollowRedirectsHeader(headers);
        return this.createRequestExchange(message, template, headers, endpoint, autoRedirect, loopIndex);
    }

    protected Exchange createRequestExchange(org.qubership.automation.itf.core.model.jpa.message.Message message, ProducerTemplate template, Map<String, Object> headers, String endpoint, HttpComponent httpComponent) throws Exception {
        int loopIndex = 0;
        boolean autoRedirect = this.checkRemoveFollowRedirectsHeader(headers);
        return this.createRequestExchange(message, template, headers, endpoint, autoRedirect, loopIndex, httpComponent);
    }

    protected Message composeBody(Message camelMessage, org.qubership.automation.itf.core.model.jpa.message.Message itfMessage) throws Exception {
        return Helper.composeBodyForREST((Message)camelMessage, (org.qubership.automation.itf.core.model.jpa.message.Message)itfMessage);
    }

    private Exchange createRequestExchange(org.qubership.automation.itf.core.model.jpa.message.Message message, ProducerTemplate template, Map<String, Object> headers, String endpoint, boolean autoRedirect, int loopIndex) {
        return this.createRequestExchange(message, template, headers, endpoint, autoRedirect, loopIndex, null);
    }

    private Exchange createRequestExchange(org.qubership.automation.itf.core.model.jpa.message.Message message, ProducerTemplate template, Map<String, Object> headers, String endpoint, boolean autoRedirect, int loopIndex, HttpComponent httpComponent) {
        HttpOperationFailedException ex;
        int statusCode;
        Exchange resp;
        if (httpComponent == null) {
            resp = template.request(endpoint, this.fillOutputExchange(message, headers));
        } else {
            HttpEndpoint endpointObj;
            String randomUuid = "out" + UUID.randomUUID();
            CAMEL_CONTEXT.addComponent(randomUuid, (Component)httpComponent);
            try {
                URI uri = new URI(endpoint);
                endpointObj = new HttpEndpoint(endpoint, httpComponent, uri);
                endpointObj.setHttpClientConfigurer(httpComponent.getHttpClientConfigurer());
                endpointObj.setClientConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager());
                endpointObj.setHeaderFilterStrategy(httpComponent.getHeaderFilterStrategy());
                if (endpoint.contains("deleteWithBody=true")) {
                    endpointObj.setDeleteWithBody(true);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            resp = template.request((Endpoint)endpointObj, this.fillOutputExchange(message, headers));
            CAMEL_CONTEXT.removeComponent(randomUuid);
        }
        if (resp.getException() instanceof HttpOperationFailedException && (statusCode = (ex = (HttpOperationFailedException)resp.getException()).getStatusCode()) == 302 && this.getOrDefault(message.getConnectionProperties(), "method", this.method).equals("POST") && loopIndex < 4 && autoRedirect) {
            this.logRedirect(endpoint, resp, ++loopIndex);
            String redirectLocation = ex.getRedirectLocation();
            resp = this.createRequestExchange(message, template, headers, this.checkAndFixNonAbsoluteRedirectLocation(redirectLocation, ex.getUri()), autoRedirect, loopIndex, httpComponent);
        }
        return resp;
    }

    public Mep getMep() {
        return Mep.OUTBOUND_REQUEST_RESPONSE_SYNCHRONOUS;
    }

    public String getEndpointPrefix() {
        return "/mockingbird-transport-rest";
    }

    private Object getOrDefault(Map<String, Object> properties, String key, String defaultValue) {
        Object value = properties.get(key);
        return value == null || "".equals(value.toString()) ? defaultValue : value;
    }

    private void logRedirect(String endpoint, Exchange resp, int loopIndex) {
        HttpOperationFailedException ex = (HttpOperationFailedException)resp.getException();
        LOGGER.debug("Redirection attempt #{}, original endpoint '{}': Response status: {}\n Response:\n   Exception: {}\n   - URI: {}\n   - RedirectLocation: {}\n   - ResponseBody: {}\n   - ResponseHeaders: {}\n", new Object[]{loopIndex, endpoint, ex.getStatusCode(), ex, ex.getUri(), ex.getRedirectLocation(), ex.getResponseBody(), ex.getResponseHeaders()});
    }

    private String checkAndFixNonAbsoluteRedirectLocation(String redirectLocation, String endpoint) {
        try {
            URI redirectLocationUri = new URI(redirectLocation);
            if (redirectLocationUri.isAbsolute()) {
                return redirectLocation;
            }
            URL url = new URI(endpoint).toURL();
            return url.getProtocol() + "://" + url.getHost() + (url.getPort() == -1 ? "" : ":" + url.getPort()) + (redirectLocation.startsWith("/") ? "" : "/") + redirectLocation;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkRemoveFollowRedirectsHeader(Map<String, Object> headers) {
        boolean autoRedirect = headers.containsKey("FollowRedirects");
        if (autoRedirect) {
            headers.remove("FollowRedirects");
        }
        return autoRedirect;
    }

    public String getShortName() {
        return "Rest Outbound";
    }
}

