/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.smpp.outbound;

import com.cloudhopper.commons.charset.CharsetUtil;
import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.SmppClient;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultSmppClient;
import com.cloudhopper.smpp.impl.DefaultSmppSessionHandler;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.pdu.SubmitSmResp;
import com.cloudhopper.smpp.tlv.Tlv;
import com.cloudhopper.smpp.type.Address;
import com.cloudhopper.smpp.type.LoggingOptions;
import com.cloudhopper.smpp.type.SmppInvalidArgumentException;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.config.ApplicationConfig;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.services.CoreServices;
import org.qubership.automation.itf.core.util.transport.base.AbstractOutboundTransportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UserName(value="Outbound SMPP transport")
public class SmppOutboundTransport
extends AbstractOutboundTransportImpl {
    private static final Logger log = LoggerFactory.getLogger(SmppOutboundTransport.class);
    @Parameter(shortName="type", longName="Type of Connection", description="TRANSCEIVER, TRANSMITTER or RECEIVER type")
    @Options(value={"TRANSCEIVER", "TRANSMITTER", "RECEIVER"})
    private String type;
    @Parameter(shortName="host", longName="Host", description="Host")
    private String host;
    @Parameter(shortName="port", longName="Port", description="Port number")
    private String port;
    @Parameter(shortName="systemId", longName="System Id", description="System Id (default: uim)", optional=true)
    private String systemId = "uim";
    @Parameter(shortName="password", longName="Password", description="Remote password or empty", optional=true)
    private String password;
    @Parameter(shortName="senderName", longName="Sender name", description="Sender name  (default: ITF Instance)", optional=true)
    private String senderName;
    @Parameter(shortName="address", longName="Address", description="Address of the recipient")
    private String address;
    @Parameter(shortName="charsetName", longName="Charset Name", description="Charset name (default: UCS-2)", forTemplate=true, optional=true)
    private String charsetName;
    @Parameter(shortName="expiryTimeout", longName="Expiry Timeout", description="Default response expiry timeout, ms (default: 60000)", forTemplate=true, optional=true)
    private String expiryTimeout;

    public static SubmitSm createSubmitSm(String src, String dst, String text, String charset) throws SmppInvalidArgumentException {
        SubmitSm submitSm = new SubmitSm();
        submitSm.setSourceAddress(new Address(5, 0, src));
        submitSm.setDestAddress(new Address(1, 1, dst));
        submitSm.setDataCoding((byte)8);
        submitSm.setShortMessage(CharsetUtil.encode((CharSequence)text, (String)charset));
        submitSm.setRegisteredDelivery((byte)1);
        Tlv scInterfaceVersion = new Tlv(528, new byte[]{Byte.parseByte("4")});
        submitSm.setOptionalParameter(scInterfaceVersion);
        return submitSm;
    }

    public Message sendReceiveSync(Message message, BigInteger projectId) throws Exception {
        ConnectionProperties connectionProperties = (ConnectionProperties)message.getConnectionProperties();
        return this.sendMessageAndGetResponse(message, connectionProperties, projectId);
    }

    private Message sendMessageAndGetResponse(Message message, ConnectionProperties connectionProperties, BigInteger projectId) {
        DefaultSmppClient client = new DefaultSmppClient();
        SmppSessionConfiguration sessionConfig = this.getSmppSessionConfiguration(connectionProperties);
        this.disableDefaultLoggingSmpp(sessionConfig);
        SmppSession session = null;
        Message response = new Message();
        try {
            session = this.getSmppSession((SmppClient)client, sessionConfig);
            this.expiryTimeout = (String)this.getOrDefault((Map<String, Object>)connectionProperties, "expiryTimeout", "60000");
            long expiryTimeout = Long.parseLong(this.expiryTimeout);
            long maxTimeout = Long.parseLong(CoreServices.getProjectSettingsService().get((Object)projectId, "tc.timeout.fail", "20"));
            maxTimeout = TimeUnit.valueOf(CoreServices.getProjectSettingsService().get((Object)projectId, "tc.timeout.fail.timeunit", "MINUTES").toUpperCase()).toMillis(maxTimeout);
            if (expiryTimeout > maxTimeout) {
                expiryTimeout = maxTimeout;
                log.warn("Used maximum response timeout, because the set time is greater than the maximum. Given time: {}, Maximum time: {}", (Object)expiryTimeout, (Object)maxTimeout);
            }
            String senderName = (String)this.getOrDefault((Map<String, Object>)connectionProperties, "senderName", "ITF Instance");
            String address = (String)connectionProperties.get((Object)"address");
            String charsetName = (String)this.getOrDefault((Map<String, Object>)connectionProperties, "charsetName", "UCS-2");
            SubmitSm sm = SmppOutboundTransport.createSubmitSm(senderName, address, message.getText(), charsetName);
            SubmitSmResp submitSmResp = session.submit(sm, expiryTimeout);
            response.setText(submitSmResp.getResultMessage());
        }
        catch (Exception e) {
            log.error("Message sending is failed or response isn't received ", (Throwable)e);
            throw new RuntimeException("Message sending is failed or response isn't received ", e);
        }
        finally {
            this.closeConnection(session, (SmppClient)client);
        }
        this.checkErrors(response, Long.parseLong(this.expiryTimeout));
        return response;
    }

    private SmppSession getSmppSession(SmppClient client, SmppSessionConfiguration sessionConfig) {
        SmppSession session;
        try {
            session = client.bind(sessionConfig, (SmppSessionHandler)new DefaultSmppSessionHandler());
            log.info("Establish connection with host: {}:{}.", (Object)sessionConfig.getHost(), (Object)sessionConfig.getPort());
        }
        catch (Exception e) {
            String error = "Error occurred while connect remote host. ";
            log.error(error, (Throwable)e);
            throw new RuntimeException(error, e);
        }
        return session;
    }

    private SmppSessionConfiguration getSmppSessionConfiguration(ConnectionProperties props) {
        SmppSessionConfiguration sessionConfig = new SmppSessionConfiguration();
        sessionConfig.setType(SmppBindType.valueOf((String)((String)props.get((Object)"type"))));
        sessionConfig.setHost((String)props.get((Object)"host"));
        sessionConfig.setPort(Integer.parseInt((String)props.get((Object)"port")));
        sessionConfig.setSystemId((String)this.getOrDefault((Map<String, Object>)props, "systemId", this.systemId));
        if (!StringUtils.isBlank((CharSequence)((String)props.get((Object)"password")))) {
            sessionConfig.setPassword((String)props.get((Object)"password"));
        }
        sessionConfig.setConnectTimeout(((Long)ApplicationConfig.env.getProperty("transport.smpp.connect.timeout", Long.class, (Object)10000L)).longValue());
        sessionConfig.setBindTimeout(((Long)ApplicationConfig.env.getProperty("transport.smpp.bind.timeout", Long.class, (Object)5000L)).longValue());
        return sessionConfig;
    }

    private void disableDefaultLoggingSmpp(SmppSessionConfiguration smppSessionConfiguration) {
        LoggingOptions loggingOptions = new LoggingOptions();
        loggingOptions.setLogPdu(((Boolean)ApplicationConfig.env.getProperty("transport.smpp.logging.package", Boolean.class, (Object)false)).booleanValue());
        loggingOptions.setLogBytes(((Boolean)ApplicationConfig.env.getProperty("transport.smpp.logging.hex.dump", Boolean.class, (Object)false)).booleanValue());
        smppSessionConfiguration.setLoggingOptions(loggingOptions);
    }

    private void checkErrors(Message response, Long expiryTimeout) {
        if (Objects.isNull(response.getText())) {
            throw new IllegalStateException("No response from remote host. Possible reasons are: response wasn't received and request timed out after " + expiryTimeout / 1000L + " seconds.");
        }
    }

    private void closeConnection(SmppSession session, SmppClient client) {
        if (Objects.nonNull(session)) {
            session.close();
            session.destroy();
        }
        client.destroy();
        log.info("Resources SmppClient and SmppSession were closed successfully.");
    }

    public Mep getMep() {
        return Mep.OUTBOUND_REQUEST_RESPONSE_SYNCHRONOUS;
    }

    public String getEndpointPrefix() {
        return "/mockingbird-transport-smpp";
    }

    public String getShortName() {
        return "SMPP Outbound";
    }

    public String viewEndpoint(ConnectionProperties connectionProperties) {
        return null;
    }

    private Object getOrDefault(Map<String, Object> properties, String key, String defaultValue) {
        Object value = properties.get(key);
        return Objects.isNull(value) || StringUtils.isBlank((CharSequence)value.toString()) ? defaultValue : value;
    }
}

