/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.snmp.outbound;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.Component;
import org.apache.camel.component.snmp.SnmpComponent;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.annotation.Async;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.transport.camel.outbound.AbstractCamelOutboundTransport;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

@UserName(value="Outbound SNMP Asynchronous")
@Async
public class SNMPOutboundTransport
extends AbstractCamelOutboundTransport {
    @Parameter(shortName="Host", longName="Host name", description="Host name")
    private String host;
    @Parameter(shortName="Port", longName="Port number", description="Port number")
    private String port;
    @Parameter(shortName="SNMP version", longName="SNMP version", description="SNMP version number: 0 (SNMPv1), 1 (SNMPv2c), 3 (SNMPv3)")
    @Options(value={"0 (SNMPv1)", "1 (SNMPv2c)", "3 (SNMPv3)"})
    private String snmpVersion;
    @Parameter(shortName="properties", longName="Extra Properties", description="Extra Properties (name=value pairs delimited by a new-line character)", isDynamic=true, optional=true, userSettings=true)
    private Map<String, Object> properties = Maps.newHashMap();

    public String getShortName() {
        return "SNMP Outbound";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String send(Message message, String sessionId, UUID projectUuid) throws Exception {
        ConnectionProperties connectionProperties = (ConnectionProperties)message.getConnectionProperties();
        if (CAMEL_CONTEXT.hasComponent("snmp") == null) {
            CAMEL_CONTEXT.addComponent("snmp", (Component)new SnmpComponent());
        }
        try (DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();){
            String host = (String)connectionProperties.obtain("Host");
            String port = (String)connectionProperties.obtain("Port");
            int snmpVersion = this.determineVersion((String)connectionProperties.obtain("SNMP version"));
            HashMap extraProperties = (HashMap)connectionProperties.obtain("properties");
            transport.listen();
            Snmp snmp = new Snmp((TransportMapping)transport);
            CommunityTarget target = this.configureCommunityTarget(extraProperties, host, port, snmpVersion);
            PDU pdu = this.configurePdu(extraProperties, host, port, message, target);
            snmp.send(pdu, (Target)target);
            snmp.close();
        }
        return null;
    }

    public String viewEndpoint(ConnectionProperties connectionProperties) {
        return null;
    }

    public Mep getMep() {
        return Mep.OUTBOUND_REQUEST_ASYNCHRONOUS;
    }

    public String getEndpointPrefix() {
        return "/mockingbird-transport-snmp";
    }

    private int determineVersion(String stringVersion) {
        switch (stringVersion) {
            case "0 (SNMPv1)": {
                return 0;
            }
            case "1 (SNMPv2c)": {
                return 1;
            }
            case "3 (SNMPv3)": {
                return 3;
            }
        }
        return 0;
    }

    private CommunityTarget configureCommunityTarget(HashMap<String, String> extraProperties, String host, String port, int snmpVersion) {
        UdpAddress targetAddress = new UdpAddress(host + "/" + port);
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString(extraProperties.getOrDefault("community", "public")));
        target.setVersion(snmpVersion);
        target.setAddress((Address)targetAddress);
        target.setRetries(2);
        target.setTimeout(5000L);
        return target;
    }

    private PDU configurePdu(HashMap<String, String> extraProperties, String host, String port, Message message, CommunityTarget target) {
        String pduType;
        PDU pdu = new PDU();
        switch (pduType = extraProperties.get("type")) {
            case "TRAP": 
            case "NOTIFICATION": {
                pdu.setType(target.getVersion() == 0 ? -92 : -89);
                break;
            }
            case "GET": {
                pdu.setType(-96);
                break;
            }
            case "GETNEXT": {
                pdu.setType(-95);
                break;
            }
            case "RESPONSE": {
                pdu.setType(-94);
                break;
            }
            case "REPORT": {
                pdu.setType(-88);
                break;
            }
            case "INFORM": {
                pdu.setType(-90);
                break;
            }
        }
        String[] messageOids = message.getText().split("\\s+");
        for (int i = 0; i < messageOids.length; ++i) {
            if (messageOids[i] == null || messageOids[i].isEmpty()) continue;
            if (messageOids.length >= i + 1 && messageOids[i + 1].startsWith("\"")) {
                int k;
                String variableString = "";
                for (k = i + 1; k < messageOids.length; ++k) {
                    variableString = variableString + (k == i + 1 ? "" : " ") + messageOids[k];
                    if (messageOids[k].endsWith("\"")) break;
                }
                pdu.add(new VariableBinding(new OID(messageOids[i]), (Variable)new OctetString(variableString.replaceAll("\"", ""))));
                i = k;
                continue;
            }
            pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OID(messageOids[i])));
        }
        pdu.add(new VariableBinding(SnmpConstants.snmpTrapAddress, (Variable)new IpAddress(host)));
        pdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new TimeTicks(111111L)));
        return pdu;
    }
}

