/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.soap.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOAPOverHTTPHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOAPOverHTTPHelper.class);

    public static Bus prepareBusContext(Object transport) {
        Thread.currentThread().setContextClassLoader(transport.getClass().getClassLoader());
        Bus defaultBus = BusFactory.getThreadDefaultBus();
        if (Objects.isNull(defaultBus.getExtension(WSDLManager.class))) {
            try {
                defaultBus.setExtension((Object)new WSDLManagerImpl(), WSDLManager.class);
            }
            catch (BusException e) {
                LOGGER.error("WSDLManager doesn't created ", (Throwable)e);
            }
        }
        return defaultBus;
    }

    public static String getAndCheckPath(String pathString, boolean checkFileExists, String errorMessage) throws MalformedURLException, FileNotFoundException {
        try {
            URL url = new URL(pathString);
            return url.toString();
        }
        catch (MalformedURLException ex) {
            Path path = Paths.get(pathString, new String[0]);
            String absolutePath = path.toAbsolutePath().toString();
            if (checkFileExists) {
                File file = new File(absolutePath);
                if (!file.exists()) {
                    throw new FileNotFoundException(errorMessage + " not found at path: " + absolutePath);
                }
                return file.toURI().toURL().toString();
            }
            return absolutePath;
        }
    }
}

