/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.soap.http.outbound;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.Striped;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfProducer;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.http4.HttpComponent;
import org.apache.camel.impl.ProducerCache;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.Bus;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.transport.http.Helper;
import org.qubership.automation.itf.transport.http.outbound.HTTPOutboundTransport;
import org.qubership.automation.itf.transport.soap.http.SOAPOverHTTPHelper;
import org.qubership.automation.itf.xsd.XSDValidationResult;
import org.qubership.automation.itf.xsd.XSDValidator;

@UserName(value="Outbound SOAP Over HTTP Synchronous")
public class SOAPOverHTTPOutboundTransport
extends HTTPOutboundTransport {
    private static final Cache<ConfiguredTransport, CxfConfig> CACHE = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
    private static final int STRIPES = 4096;
    private static final Striped<Lock> LOCK_STRIPED = Striped.lazyWeakLock((int)4096);
    @Parameter(shortName="wsdlPath", longName="Path to WSDL file", description="Path to WSDL file", fileDirectoryType="wsdl-xsd")
    private String wsdlFile;
    @Parameter(shortName="isWsdlContains", longName="Does WSDL File contain XSD?", description="Does WSDL File contain XSD?")
    @Options(value={"No", "Yes"})
    private String isWsdlContainsXSD;
    @Parameter(shortName="requestXSDPath", longName="Validate Request by XSD", description="Path to XSD file (not required)", optional=true, fileDirectoryType="wsdl-xsd")
    private String requestXSD;
    @Parameter(shortName="responseXSDPath", longName="Validate Response by XSD", description="Path to XSD file (not required)", optional=true, fileDirectoryType="wsdl-xsd")
    private String responseXSD;

    public String getShortName() {
        return "SOAP Outbound";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Exchange createRequestExchange(org.qubership.automation.itf.core.model.jpa.message.Message message, ProducerTemplate template, Map<String, Object> headers, String endpoint) {
        CxfEndpoint cxfEndpoint;
        String wsdlPathString = FilenameUtils.normalize((String)((String)message.getConnectionProperties().get("wsdlPath")));
        if (StringUtils.isBlank((CharSequence)wsdlPathString)) {
            throw new IllegalArgumentException("Path/URL to WSDL file is not specified");
        }
        if (wsdlPathString.contains("../") || wsdlPathString.contains("\\..")) {
            throw new IllegalArgumentException("Path/URL to WSDL file contains path elements which cancause Path Traversal vulnerability ('../' and/or '\\..').");
        }
        ConnectionProperties properties = new ConnectionProperties(message.getConnectionProperties());
        properties.remove((Object)"ContextId");
        String transportId = (String)message.getConnectionProperties().get("transportId");
        ConfiguredTransport configuredTransport = new ConfiguredTransport(transportId, properties);
        try {
            CxfProducer cxfProducer;
            CxfConfig cxfConfig;
            Lock lock = (Lock)LOCK_STRIPED.get((Object)configuredTransport);
            synchronized (lock) {
                cxfConfig = (CxfConfig)CACHE.getIfPresent((Object)configuredTransport);
                if (cxfConfig == null) {
                    cxfEndpoint = new CxfEndpoint();
                    cxfEndpoint.setWsdlURL(SOAPOverHTTPHelper.getAndCheckPath(wsdlPathString, true, "WSDL file"));
                    cxfEndpoint.setAddress(endpoint);
                    cxfEndpoint.setCamelContext(template.getCamelContext());
                    Bus defaultBus = SOAPOverHTTPHelper.prepareBusContext((Object)this);
                    cxfEndpoint.setBus(defaultBus);
                    cxfEndpoint.setDataFormat(DataFormat.RAW);
                    this.setExtraProperties(cxfEndpoint, (Map)message.getConnectionProperties().get("properties"));
                    cxfEndpoint.start();
                    cxfProducer = new CxfProducer(cxfEndpoint);
                    cxfProducer.start();
                    cxfConfig = new CxfConfig(cxfEndpoint, cxfProducer);
                    CACHE.put((Object)configuredTransport, (Object)cxfConfig);
                }
            }
            cxfEndpoint = cxfConfig.getCxfEndpoint();
            cxfEndpoint.setCamelContext(template.getCamelContext());
            cxfProducer = cxfConfig.getCxfProducer();
            this.fixNPE_clientNull(template, cxfEndpoint, cxfProducer);
        }
        catch (FileNotFoundException | MalformedURLException e) {
            throw new IllegalArgumentException("Path/URL to WSDL file is invalid (" + wsdlPathString + ")", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error configuring transport to send CXF Message. Stacktrace: " + e);
        }
        return template.request((Endpoint)cxfEndpoint, this.fillOutputExchange(message, headers));
    }

    protected Exchange createRequestExchange(org.qubership.automation.itf.core.model.jpa.message.Message message, ProducerTemplate template, Map<String, Object> headers, String endpoint, HttpComponent httpComponent) throws Exception {
        return this.createRequestExchange(message, template, headers, endpoint);
    }

    protected Message composeBody(Message camelMessage, org.qubership.automation.itf.core.model.jpa.message.Message itfMessage) throws Exception {
        return Helper.composeBodyForSOAPOutbound((Message)camelMessage, (org.qubership.automation.itf.core.model.jpa.message.Message)itfMessage);
    }

    public void validateRequest(org.qubership.automation.itf.core.model.jpa.message.Message message) {
        this.validate(message, "requestXSDPath");
    }

    public void validateResponse(org.qubership.automation.itf.core.model.jpa.message.Message message) {
        this.validate(message, "responseXSDPath");
    }

    private void fixNPE_clientNull(ProducerTemplate template, CxfEndpoint cxfEndpoint, CxfProducer cxfProducer) throws Exception {
        Method method = template.getClass().getDeclaredMethod("getProducerCache", new Class[0]);
        method.setAccessible(true);
        ProducerCache producerCache = (ProducerCache)method.invoke((Object)template, new Object[0]);
        Field field = producerCache.getClass().getDeclaredField("producers");
        field.setAccessible(true);
        Map producers = (Map)field.get(producerCache);
        producers.put(cxfEndpoint.getEndpointUri(), cxfProducer);
    }

    private void validate(org.qubership.automation.itf.core.model.jpa.message.Message message, String requestXsdPath) {
        XSDValidationResult result = this.validateMessage(message, requestXsdPath);
        if (result != null && result.isFailed()) {
            message.setText(result.toString());
        }
    }

    @Nullable
    private XSDValidationResult validateMessage(org.qubership.automation.itf.core.model.jpa.message.Message message, String xsdPathParameter) {
        String xsdFilePath = (String)message.getConnectionPropertiesParameter(xsdPathParameter);
        if (StringUtils.isBlank((CharSequence)xsdFilePath) || StringUtils.isBlank((CharSequence)message.getText())) {
            return null;
        }
        XSDValidator validator = new XSDValidator();
        return validator.validate(message.getText(), xsdFilePath);
    }

    public String viewEndpoint(ConnectionProperties connectionProperties) {
        return null;
    }

    public Mep getMep() {
        return Mep.OUTBOUND_REQUEST_RESPONSE_SYNCHRONOUS;
    }

    public String getEndpointPrefix() {
        return "/mockingbird-transport-soap-http";
    }

    protected void setExtraProperties(CxfEndpoint cxfEndpoint, Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        block8: for (Map.Entry<String, Object> item : properties.entrySet()) {
            String key;
            if (StringUtils.isBlank((CharSequence)item.getKey()) || item.getValue() == null) continue;
            switch (key = item.getKey().trim()) {
                case "endpoint": {
                    cxfEndpoint.setPortName((String)item.getValue());
                    continue block8;
                }
                case "defaultOperationName": {
                    cxfEndpoint.setDefaultOperationName((String)item.getValue());
                    continue block8;
                }
            }
            props.put(key, item.getValue());
        }
        if (!props.isEmpty()) {
            cxfEndpoint.setProperties(props);
        }
    }

    private class CxfConfig {
        private CxfProducer cxfProducer;
        private CxfEndpoint cxfEndpoint;

        public CxfConfig(CxfEndpoint cxfEndpoint, CxfProducer cxfProducer) {
            this.cxfEndpoint = cxfEndpoint;
            this.cxfProducer = cxfProducer;
        }

        public CxfProducer getCxfProducer() {
            return this.cxfProducer;
        }

        public void setCxfProducer(CxfProducer cxfProducer) {
            this.cxfProducer = cxfProducer;
        }

        public CxfEndpoint getCxfEndpoint() {
            return this.cxfEndpoint;
        }

        public void setCxfEndpoint(CxfEndpoint cxfEndpoint) {
            this.cxfEndpoint = cxfEndpoint;
        }
    }

    private class ConfiguredTransport {
        TreeMap<String, Object> properties;
        private String transportId;
        private String componentId;

        public ConfiguredTransport() {
            this.transportId = "";
            this.setComponentId();
            this.properties = new TreeMap();
        }

        public ConfiguredTransport(String transportId, ConnectionProperties properties) {
            this.transportId = transportId;
            this.setComponentId();
            this.properties = new TreeMap(properties);
        }

        public String getTransportId() {
            return this.transportId;
        }

        public void setTransportId(String transportId) {
            this.transportId = transportId;
        }

        public TreeMap<String, Object> getProperties() {
            return this.properties;
        }

        public void setProperties(ConnectionProperties properties) {
            this.properties = new TreeMap(properties);
        }

        public String getComponentId() {
            return this.componentId;
        }

        private void setComponentId() {
            this.componentId = "out" + this.transportId + "-" + UUID.randomUUID();
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.transportId);
            hash = 97 * hash + Objects.hashCode(this.properties);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfiguredTransport other = (ConfiguredTransport)obj;
            if (!Objects.equals(this.transportId, other.transportId)) {
                return false;
            }
            return Objects.equals(this.properties, other.properties);
        }
    }
}

