/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.sql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.util.concurrent.Striped;
import java.net.UnknownHostException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.qubership.automation.itf.transport.sql.CassandraClientURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraSessionsHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraSessionsHolder.class);
    private static final int STRIPES = 100;
    private static final Striped<Lock> LOCK_STRIPED = Striped.lazyWeakLock((int)100);
    private static final long baseDelayMs = 100L;
    private static final long maxDelayMs = 51200L;
    private static final ScheduledExecutorService configCacheMaintenanceService = Executors.newSingleThreadScheduledExecutor();
    private static CassandraSessionsHolder INSTANCE = new CassandraSessionsHolder();
    private static boolean isCacheCleanupScheduled = false;
    private volatile Cache<String, Session> sessionsHolder = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).removalListener(removalNotification -> {
        Session session;
        if (removalNotification.getCause().equals((Object)RemovalCause.EXPIRED) && (session = (Session)removalNotification.getValue()) != null) {
            Cluster cluster = session.getCluster();
            if (!session.isClosed()) {
                session.close();
            }
            if (cluster != null && !cluster.isClosed()) {
                cluster.close();
            }
        }
    }).build();

    private CassandraSessionsHolder() {
    }

    public static CassandraSessionsHolder getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String url, String user, String pass) throws UnknownHostException {
        Session session;
        Lock lock = (Lock)LOCK_STRIPED.get((Object)url);
        synchronized (lock) {
            session = (Session)this.sessionsHolder.getIfPresent((Object)url);
            if (session != null) {
                if (session.isClosed()) {
                    Cluster cluster = session.getCluster();
                    if (cluster != null && !cluster.isClosed()) {
                        cluster.close();
                    }
                    session = this.createSession(url, user, pass);
                    this.sessionsHolder.put((Object)url, (Object)session);
                }
            } else {
                session = this.createSession(url, user, pass);
                this.sessionsHolder.put((Object)url, (Object)session);
            }
        }
        this.scheduleCacheCleanupIfNeeded();
        return session;
    }

    private synchronized void scheduleCacheCleanupIfNeeded() {
        if (!isCacheCleanupScheduled && this.sessionsHolder.size() > 0L) {
            configCacheMaintenanceService.scheduleWithFixedDelay(() -> {
                try {
                    this.sessionsHolder.cleanUp();
                }
                catch (Throwable t) {
                    LOGGER.error("Error while Cassandra Sessions cache cleanUp: {}", (Object)t.toString());
                }
            }, 61L, 20L, TimeUnit.MINUTES);
            isCacheCleanupScheduled = true;
        }
    }

    private Session createSession(String url, String user, String pass) throws UnknownHostException {
        CassandraClientURI uri = new CassandraClientURI(url, user, pass);
        ExponentialReconnectionPolicy exponentialReconnectionPolicy = new ExponentialReconnectionPolicy(100L, 51200L);
        Cluster cluster = uri.createBuilder((ReconnectionPolicy)exponentialReconnectionPolicy);
        return cluster.connect(uri.getDatabase());
    }
}

