/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.sql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qubership.automation.itf.transport.sql.outbound.SqlOutboundTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraClientURI {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlOutboundTransport.class);
    private static final String PREFIX = "jdbc:cassandra://";
    static Set<String> allKeys = new HashSet<String>();
    private final List<String> hosts;
    private final String database;
    private final String collection;
    private final String uri;
    private final String userName;
    private final String password;

    public CassandraClientURI(String uri, String username, String password) {
        String optionsPart;
        String nsPart;
        String serverPart;
        this.uri = uri;
        this.userName = username;
        this.password = password;
        if (!uri.startsWith(PREFIX)) {
            throw new IllegalArgumentException("URI must start with jdbc:cassandra://, but configured: " + uri);
        }
        int idx = (uri = uri.substring(PREFIX.length())).lastIndexOf("/");
        if (idx < 0) {
            if (uri.contains("?")) {
                throw new IllegalArgumentException("URI contains options without trailing slash: " + uri);
            }
            serverPart = uri;
            nsPart = null;
            optionsPart = "";
        } else {
            serverPart = uri.substring(0, idx);
            nsPart = uri.substring(idx + 1);
            if ((idx = nsPart.indexOf("?")) >= 0) {
                optionsPart = nsPart.substring(idx + 1);
                nsPart = nsPart.substring(0, idx);
            } else {
                optionsPart = "";
            }
        }
        LinkedList all = new LinkedList();
        Collections.addAll(all, serverPart.split(","));
        this.hosts = Collections.unmodifiableList(all);
        if (nsPart != null && nsPart.length() != 0) {
            idx = nsPart.indexOf(".");
            if (idx < 0) {
                this.database = nsPart;
                this.collection = null;
            } else {
                this.database = nsPart.substring(0, idx);
                this.collection = nsPart.substring(idx + 1);
            }
        } else {
            this.database = null;
            this.collection = null;
        }
        Map<String, List<String>> optionsMap = this.parseOptions(optionsPart);
        this.warnOnUnsupportedOptions(optionsMap);
    }

    public Cluster createBuilder() throws UnknownHostException {
        return this.createBuilder((ReconnectionPolicy)new ConstantReconnectionPolicy(100L));
    }

    public Cluster createBuilder(ReconnectionPolicy reconnectionPolicy) throws UnknownHostException {
        Cluster.Builder builder = Cluster.builder();
        if (System.getProperty("javax.net.ssl.trustStore") != null) {
            builder = builder.withSSL();
        }
        int port = -1;
        for (String host : this.hosts) {
            int idx = host.indexOf(":");
            if (idx > 0) {
                port = Integer.parseInt(host.substring(idx + 1).trim());
                host = host.substring(0, idx).trim();
            }
            builder.addContactPoints(new InetAddress[]{InetAddress.getByName(host)});
        }
        if (port > -1) {
            builder.withPort(port);
        }
        builder.withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE).withReconnectionPolicy((ReconnectionPolicy)(reconnectionPolicy == null ? new ConstantReconnectionPolicy(100L) : reconnectionPolicy));
        if (this.userName != null) {
            builder.withCredentials(this.userName, this.password);
            LOGGER.info("URI: {} - Using authentication as user '{}'", (Object)this.uri, (Object)this.userName);
        }
        return builder.build();
    }

    private void warnOnUnsupportedOptions(Map<String, List<String>> optionsMap) {
        for (String key : optionsMap.keySet()) {
            if (key.startsWith("javax.net.ssl")) {
                System.setProperty(key, optionsMap.get(key).get(0));
                continue;
            }
            if (allKeys.contains(key)) continue;
            LOGGER.warn("Unknown or Unsupported Option '{}'", (Object)key);
        }
    }

    private String getLastValue(Map<String, List<String>> optionsMap, String key) {
        List<String> valueList = optionsMap.get(key);
        return valueList == null ? null : valueList.get(valueList.size() - 1);
    }

    private Map<String, List<String>> parseOptions(String optionsPart) {
        HashMap<String, List<String>> optionsMap = new HashMap<String, List<String>>();
        for (String _part : optionsPart.split("&|;")) {
            int idx = _part.indexOf("=");
            if (idx < 0) continue;
            String key = _part.substring(0, idx).toLowerCase();
            String value = _part.substring(idx + 1);
            ArrayList<String> valueList = (ArrayList<String>)optionsMap.get(key);
            if (valueList == null) {
                valueList = new ArrayList<String>(1);
            }
            valueList.add(value);
            optionsMap.put(key, valueList);
        }
        return optionsMap;
    }

    boolean _parseBoolean(String _in) {
        String in = _in.trim();
        return in != null && in.length() > 0 && (in.equals("1") || in.toLowerCase().equals("true") || in.toLowerCase().equals("yes"));
    }

    public String getUsername() {
        return this.userName;
    }

    public char[] getPassword() {
        return this.password != null ? this.password.toCharArray() : null;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getURI() {
        return this.uri;
    }

    public String toString() {
        return this.uri;
    }

    static {
        allKeys.add("javax.net.ssl.trustStore");
        allKeys.add("javax.net.ssl.trustStorePassword");
        allKeys.add("javax.net.ssl.keyStore");
        allKeys.add("javax.net.ssl.keyStorePassword");
    }
}

