/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.sql.outbound;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.exceptions.CodecNotFoundException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.LoggingErrorHandlerBuilder;
import org.apache.camel.component.cassandra.CassandraComponent;
import org.apache.camel.component.cassandra.CassandraEndpoint;
import org.apache.camel.component.jdbc.JdbcComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;
import org.apache.commons.dbcp2.BasicDataSource;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.transport.base.AbstractOutboundTransportImpl;
import org.qubership.automation.itf.transport.sql.CassandraSessionsHolder;
import org.qubership.automation.itf.transport.sql.outbound.SqlRouteBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

@UserName(value="Outbound SQL Synchronous")
public class SqlOutboundTransport
extends AbstractOutboundTransportImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlOutboundTransport.class);
    private static final ObjectMapper MAPPER;
    private static final Integer defaultQueryTimeout;
    private static final Integer initialSize;
    private static final Integer maxTotal;
    private static final Integer maxIdle;
    private static final Integer minIdle;
    private static final boolean testWhileIdle;
    private static final boolean fastFailValidation;
    private static final boolean removeAbandonedOnMaintenance;
    private static final boolean removeAbandonedOnBorrow;
    private static final Integer maxWaitMillis;
    private static final Integer minEvictableIdleTimeMillis;
    private static final Integer timeBetweenEvictionRunsMillis;
    private static final Integer maxConnLifetimeMillis;
    private static final Integer ojdbcReadTimeout;
    private static final Integer ojdbcConnectTimeout;
    private static final Integer ojdbcOutboundConnectTimeout;
    private static final boolean dataSourcesCacheEnable;
    private static final int dataSourcesCacheExpireMinutes;
    private static final boolean dataSourcesCacheRecordStats;
    private static final LoadingCache<ConnectionProperties, SqlConfig> configCache;
    private static final ScheduledExecutorService configCacheMaintenanceService;
    private static boolean isCacheCleanupScheduled;
    @Parameter(shortName="typeDB", longName="Type of database", description="Type of database")
    @Options(value={"Oracle", "Cassandra", "PostgreSQL", "SQLServer", "Trino", "Hive"})
    private String typeDB;
    @Parameter(shortName="jdbcUrl", longName="JDBC URL", description="jdbc:oracle:thin:host:port:sid or jdbc:cassandra://{host}[:{port}]/{database} or jdbc:postgresql://{host}:{port}/{database} or jdbc:sqlserver://[serverName[\\instanceName][:portNumber]][;property=value[;property=value]]", isDynamic=true)
    private String jdbcUrl;
    @Parameter(shortName="user", longName="DataBase User", description="DataBase User", isDynamic=true)
    private String user;
    @Parameter(shortName="pass", longName="DataBase Password", description="DataBase Password, non-empty (for Trino DBs, please use NONE instead of empty value)", isDynamic=true)
    private String pass;
    @Parameter(shortName="options", longName="Options", description="SomeOption=SomeValue\nreadSize=50", optional=true, forTemplate=true)
    private Map<String, String> options = new HashMap<String, String>();

    private static DataSource setupDataSource(ConnectionProperties connectionProperties) {
        BasicDataSource dataSource = new BasicDataSource();
        String typeDataBase = SqlOutboundTransport.getAndCheckRequiredProperty(connectionProperties, "typeDB", "Type of database");
        String driver = SqlOutboundTransport.selectDataBaseDriver(typeDataBase);
        dataSource.setDriverClassName(driver);
        dataSource.setUsername(SqlOutboundTransport.getAndCheckRequiredProperty(connectionProperties, "user", "DataBase User"));
        dataSource.setPassword(SqlOutboundTransport.getAndCheckRequiredProperty(connectionProperties, "pass", "DataBase Password, non-empty (for Trino DBs, please use NONE instead of empty value)"));
        dataSource.setUrl(SqlOutboundTransport.getAndCheckRequiredProperty(connectionProperties, "jdbcUrl", "JDBC URL"));
        if ("Oracle".equals(typeDataBase)) {
            if (ojdbcReadTimeout != -1) {
                dataSource.addConnectionProperty("oracle.jdbc.ReadTimeout", ojdbcReadTimeout.toString());
            }
            if (ojdbcConnectTimeout != -1) {
                dataSource.addConnectionProperty("oracle.net.CONNECT_TIMEOUT", ojdbcConnectTimeout.toString());
            }
            if (ojdbcOutboundConnectTimeout != -1) {
                dataSource.addConnectionProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT", ojdbcOutboundConnectTimeout.toString());
            }
        }
        dataSource.setDefaultQueryTimeout(defaultQueryTimeout);
        dataSource.setInitialSize(initialSize.intValue());
        dataSource.setMaxTotal(maxTotal.intValue());
        dataSource.setMaxIdle(maxIdle.intValue());
        dataSource.setMinIdle(minIdle.intValue());
        dataSource.setMaxWaitMillis((long)maxWaitMillis.intValue());
        dataSource.setTestWhileIdle(testWhileIdle);
        dataSource.setMinEvictableIdleTimeMillis((long)minEvictableIdleTimeMillis.intValue());
        dataSource.setTimeBetweenEvictionRunsMillis((long)timeBetweenEvictionRunsMillis.intValue());
        dataSource.setMaxConnLifetimeMillis((long)maxConnLifetimeMillis.intValue());
        dataSource.setFastFailValidation(fastFailValidation);
        dataSource.setRemoveAbandonedOnMaintenance(removeAbandonedOnMaintenance);
        dataSource.setRemoveAbandonedOnBorrow(removeAbandonedOnBorrow);
        return dataSource;
    }

    private static String selectDataBaseDriver(String typeDataBase) {
        switch (typeDataBase) {
            case "Oracle": {
                return "oracle.jdbc.driver.OracleDriver";
            }
            case "PostgreSQL": {
                return "org.postgresql.Driver";
            }
            case "Cassandra": {
                return "com.dbschema.CassandraJdbcDriver";
            }
            case "SQLServer": {
                return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            }
            case "Trino": {
                return "io.trino.jdbc.TrinoDriver";
            }
            case "Hive": {
                return "org.apache.hive.jdbc.HiveDriver";
            }
        }
        return null;
    }

    private static String getAndCheckRequiredProperty(ConnectionProperties connectionProperties, String field, String fieldName) {
        String reqProperty;
        try {
            reqProperty = connectionProperties.get((Object)field).toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Required property '%s' can't be empty", fieldName));
        }
        return reqProperty;
    }

    public String getShortName() {
        return "SQL Outbound";
    }

    public Message sendReceiveSync(Message message, BigInteger projectId) throws Exception {
        Message response;
        String sqlCommand;
        int sqlCommandType;
        String pwd;
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ConnectionProperties connectionProperties = (ConnectionProperties)message.getConnectionProperties();
        String typeDataBase = SqlOutboundTransport.getAndCheckRequiredProperty(connectionProperties, "typeDB", "Type of database");
        if (typeDataBase.equals("Cassandra")) {
            return this.sendReceiveSyncCassandra(message, connectionProperties);
        }
        if (typeDataBase.equals("Trino") && (pwd = connectionProperties.getOrDefault((Object)"pass", (Object)"").toString()).equals("NONE")) {
            connectionProperties.replace((Object)"pass", (Object)"");
        }
        if ((sqlCommandType = SqlOutboundTransport.determineType(sqlCommand = message.getText().trim())) == -1 || !dataSourcesCacheEnable) {
            return this.sendReceiveSyncLegacy(message, connectionProperties);
        }
        connectionProperties.remove((Object)"ContextId");
        connectionProperties.remove((Object)"transportId");
        SqlConfig sqlConfig = (SqlConfig)configCache.get((Object)connectionProperties);
        JdbcTemplate jdbcTemplate = sqlConfig.getJdbcTemplate();
        switch (sqlCommandType) {
            case 1: {
                List result = jdbcTemplate.queryForList(sqlCommand);
                response = new Message(this.convertToJson(result));
                break;
            }
            case 2: {
                int processedCount = jdbcTemplate.update(sqlCommand);
                response = new Message("[{\"result\":\"Executed successfully\",\"rowsProcessed\":" + processedCount + "}]");
                break;
            }
            case 3: {
                jdbcTemplate.execute(sqlCommand);
                response = new Message("[{\"result\":\"Executed successfully\"}]");
                break;
            }
            default: {
                response = new Message("[{\"result\":\"Unknown sql command; rejected\"}]");
            }
        }
        SqlOutboundTransport.scheduleCacheCleanupIfNeeded();
        return response;
    }

    private static synchronized void scheduleCacheCleanupIfNeeded() {
        if (!dataSourcesCacheEnable) {
            return;
        }
        if (!isCacheCleanupScheduled && configCache.size() > 0L) {
            configCacheMaintenanceService.scheduleWithFixedDelay(() -> {
                try {
                    if (dataSourcesCacheRecordStats) {
                        CacheStats cacheStats = configCache.stats();
                        LOGGER.info("DataSources Cache Statistics: {}", (Object)cacheStats);
                    }
                    configCache.cleanUp();
                }
                catch (Throwable t) {
                    LOGGER.error("Error while SqlOutboundTransport cache cleanUp: {}", (Object)t.toString());
                }
            }, 61L, 20L, TimeUnit.MINUTES);
            isCacheCleanupScheduled = true;
        }
    }

    private static int determineType(String sqlCommand) {
        String startString = sqlCommand.substring(0, 6).toLowerCase();
        return startString.equals("select") ? 1 : (startString.equals("insert") || startString.equals("update") || startString.equals("delete") ? 2 : (startString.equals("create") || startString.startsWith("alter") || startString.startsWith("drop") || startString.startsWith("call") ? 3 : -1));
    }

    private Message sendReceiveSyncLegacy(Message message, ConnectionProperties connectionProperties) throws Exception {
        Exchange out;
        DataSource dataSource = SqlOutboundTransport.setupDataSource(connectionProperties);
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)"DataSource", (Object)dataSource);
        DefaultCamelContext context = new DefaultCamelContext((Registry)registry);
        if (!context.getComponentNames().contains("jdbc")) {
            JdbcComponent jdbcComponent = new JdbcComponent((CamelContext)context);
            jdbcComponent.setDataSource(dataSource);
            context.addComponent("jdbc", (Component)jdbcComponent);
        }
        ProducerTemplate template = context.createProducerTemplate();
        String options = this.getStringOptionsForRouteBuilder(connectionProperties);
        SqlRouteBuilder sqlRoute = new SqlRouteBuilder(options);
        sqlRoute.setContext((CamelContext)context);
        context.addRoutes((RoutesBuilder)sqlRoute);
        Endpoint endpoint = context.getEndpoint("direct:start");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)message.getText());
        context.start();
        try {
            out = template.send(endpoint, exchange);
            if (out.isFailed()) {
                throw out.getException();
            }
        }
        catch (Exception e) {
            context.stop();
            throw new Exception("Error sending SQL Message. Stacktrace: " + e);
        }
        Message response = new Message(this.convertToJson(out.getOut().getBody()));
        exchange.getOut().getHeaders().put("Options", options);
        response.convertAndSetHeaders(exchange.getOut().getHeaders());
        context.stop();
        return response;
    }

    private Message sendReceiveSyncCassandra(Message message, ConnectionProperties connectionProperties) throws Exception {
        Exchange out;
        String username = SqlOutboundTransport.getAndCheckRequiredProperty(connectionProperties, "user", "DataBase User");
        String password = SqlOutboundTransport.getAndCheckRequiredProperty(connectionProperties, "pass", "DataBase Password, non-empty (for Trino DBs, please use NONE instead of empty value)");
        Session session = CassandraSessionsHolder.getInstance().getSession(SqlOutboundTransport.getAndCheckRequiredProperty(connectionProperties, "jdbcUrl", "JDBC URL"), username, password);
        CassandraComponent component = new CassandraComponent();
        CassandraEndpoint endpoint = new CassandraEndpoint("", component, null, session, session.getLoggedKeyspace());
        endpoint.setUsername(username);
        endpoint.setPassword(password);
        endpoint.setCql(message.getText());
        endpoint.start();
        DefaultCamelContext context = new DefaultCamelContext();
        context.setErrorHandlerBuilder((ErrorHandlerFactory)new LoggingErrorHandlerBuilder(LOGGER));
        ProducerTemplate template = context.createProducerTemplate();
        endpoint.setCamelContext((CamelContext)context);
        Exchange exchange = endpoint.createExchange();
        context.start();
        try {
            out = template.send((Endpoint)endpoint, exchange);
            if (out.isFailed()) {
                throw out.getException();
            }
        }
        catch (Exception e) {
            this.stop((CamelContext)context, session, session.getCluster());
            throw new Exception("Error sending SQL Message. Stacktrace: " + e);
        }
        Message response = new Message(this.convertToJson(this.processCassandraResponse(out.getOut().getBody())));
        exchange.getOut().getHeaders().put("Options", this.options);
        response.convertAndSetHeaders(exchange.getOut().getHeaders());
        this.stop((CamelContext)context, session, session.getCluster());
        return response;
    }

    private void stop(CamelContext context, Session session, Cluster cluster) throws Exception {
        context.stop();
    }

    private String getStringOptionsForRouteBuilder(ConnectionProperties connectionProperties) {
        if (!connectionProperties.containsKey((Object)"options")) {
            return "";
        }
        HashMap mapOfOptions = new HashMap((Map)connectionProperties.get((Object)"options"));
        StringBuilder st = new StringBuilder();
        st.append("?");
        int numberOptions = mapOfOptions.size();
        for (Map.Entry entry : mapOfOptions.entrySet()) {
            st.append(entry);
            if (--numberOptions <= 0) continue;
            st.append('&');
        }
        return st.toString();
    }

    private String convertToJson(Object responseBody) throws Exception {
        try {
            return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(responseBody);
        }
        catch (JsonProcessingException e) {
            throw new Exception("Error while converting query response to Json. Stacktrace: " + (Object)((Object)e));
        }
    }

    public String viewEndpoint(ConnectionProperties connectionProperties) {
        return null;
    }

    public Mep getMep() {
        return Mep.OUTBOUND_REQUEST_RESPONSE_SYNCHRONOUS;
    }

    public String getEndpointPrefix() {
        return null;
    }

    private Object getColumnValue(Row row, int i, DataType.Name columnType) {
        if (row == null || row.isNull(i)) {
            return null;
        }
        switch (columnType) {
            case ASCII: 
            case VARCHAR: 
            case TEXT: {
                return row.getString(i);
            }
            case BIGINT: 
            case COUNTER: {
                return row.getLong(i);
            }
            case BOOLEAN: {
                return row.getBool(i);
            }
            case DECIMAL: {
                return row.getDecimal(i);
            }
            case DOUBLE: {
                return row.getDouble(i);
            }
            case FLOAT: {
                return Float.valueOf(row.getFloat(i));
            }
            case INET: {
                return row.getInet(i);
            }
            case INT: {
                return row.getInt(i);
            }
            case SMALLINT: {
                return (int)row.getShort(i);
            }
            case TINYINT: {
                return (int)row.getByte(i);
            }
            case UDT: {
                return this.udtValue2Object(row.getUDTValue(i));
            }
            case LIST: {
                try {
                    return row.getList(i, String.class);
                }
                catch (CodecNotFoundException ex) {
                    try {
                        List udtList = row.getList(i, UDTValue.class);
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (UDTValue udtValue : udtList) {
                            list.add(this.udtValue2Object(udtValue));
                        }
                        return list;
                    }
                    catch (CodecNotFoundException ex1) {
                        return row.getObject(i);
                    }
                }
            }
            case MAP: {
                try {
                    return row.getMap(i, String.class, String.class);
                }
                catch (CodecNotFoundException ex) {
                    Map udtMap = row.getMap(i, String.class, UDTValue.class);
                    HashMap map = new HashMap();
                    for (Map.Entry entry : udtMap.entrySet()) {
                        map.put(entry.getKey(), this.udtValue2Object((UDTValue)entry.getValue()));
                    }
                    return map;
                }
            }
            case SET: {
                try {
                    return row.getSet(i, String.class);
                }
                catch (CodecNotFoundException ex) {
                    try {
                        Set udtSet = row.getSet(i, UDTValue.class);
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (UDTValue value : udtSet) {
                            list.add(this.udtValue2Object(value));
                        }
                        return list;
                    }
                    catch (CodecNotFoundException ex1) {
                        return row.getObject(i);
                    }
                }
            }
            case TIMESTAMP: {
                return row.getTimestamp(i);
            }
            case TIMEUUID: 
            case UUID: {
                return row.getUUID(i);
            }
            case VARINT: {
                return row.getVarint(i);
            }
        }
        ByteBuffer bytesUnsafe = row.getBytesUnsafe(i);
        byte[] b = new byte[bytesUnsafe.remaining()];
        bytesUnsafe.get(b);
        return b;
    }

    private Object udtValue2Object(UDTValue udtValue) {
        if (udtValue == null) {
            return null;
        }
        HashMap<String, Object> udtMap = new HashMap<String, Object>();
        for (String fieldName : udtValue.getType().getFieldNames()) {
            udtMap.put(fieldName, this.getByName(udtValue, fieldName));
        }
        return udtMap;
    }

    private Object getByName(UDTValue udtValue, String fieldName) {
        if (udtValue.isNull(fieldName)) {
            return null;
        }
        switch (udtValue.getType().getFieldType(fieldName).getName()) {
            case ASCII: 
            case VARCHAR: 
            case TEXT: {
                return udtValue.getString(fieldName);
            }
            case BIGINT: 
            case COUNTER: {
                return udtValue.getLong(fieldName);
            }
            case BOOLEAN: {
                return udtValue.getBool(fieldName);
            }
            case DECIMAL: {
                return udtValue.getDecimal(fieldName);
            }
            case DOUBLE: {
                return udtValue.getDouble(fieldName);
            }
            case FLOAT: {
                return Float.valueOf(udtValue.getFloat(fieldName));
            }
            case INET: {
                return udtValue.getInet(fieldName);
            }
            case INT: {
                return udtValue.getInt(fieldName);
            }
            case SMALLINT: {
                return (int)udtValue.getShort(fieldName);
            }
            case TINYINT: {
                return (int)udtValue.getByte(fieldName);
            }
            case UDT: {
                return this.udtValue2Object(udtValue.getUDTValue(fieldName));
            }
            case LIST: {
                try {
                    return udtValue.getList(fieldName, String.class);
                }
                catch (CodecNotFoundException ex) {
                    try {
                        List udtList = udtValue.getList(fieldName, UDTValue.class);
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (UDTValue value : udtList) {
                            list.add(this.udtValue2Object(value));
                        }
                        return list;
                    }
                    catch (CodecNotFoundException ex1) {
                        return udtValue.getObject(fieldName);
                    }
                }
            }
            case MAP: {
                try {
                    return udtValue.getMap(fieldName, String.class, String.class);
                }
                catch (CodecNotFoundException ex) {
                    Map udtMap = udtValue.getMap(fieldName, String.class, UDTValue.class);
                    HashMap map = new HashMap();
                    for (Map.Entry entry : udtMap.entrySet()) {
                        map.put(entry.getKey(), this.udtValue2Object((UDTValue)entry.getValue()));
                    }
                    return map;
                }
            }
            case SET: {
                try {
                    return udtValue.getSet(fieldName, String.class);
                }
                catch (CodecNotFoundException ex) {
                    try {
                        Set udtSet = udtValue.getSet(fieldName, UDTValue.class);
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (UDTValue value : udtSet) {
                            list.add(this.udtValue2Object(value));
                        }
                        return list;
                    }
                    catch (CodecNotFoundException ex1) {
                        return udtValue.getObject(fieldName);
                    }
                }
            }
            case TIMESTAMP: {
                return udtValue.getTimestamp(fieldName);
            }
            case TIMEUUID: 
            case UUID: {
                return udtValue.getUUID(fieldName);
            }
            case VARINT: {
                return udtValue.getVarint(fieldName);
            }
        }
        ByteBuffer bytesUnsafe = udtValue.getBytesUnsafe(fieldName);
        byte[] b = new byte[bytesUnsafe.remaining()];
        bytesUnsafe.get(b);
        return b;
    }

    private Object processCassandraResponse(Object responseBody) {
        if (responseBody == null) {
            return null;
        }
        if (responseBody instanceof ArrayList) {
            ArrayList array = new ArrayList(((ArrayList)responseBody).size());
            for (Object row : (ArrayList)responseBody) {
                if (!(row instanceof Row)) continue;
                ColumnDefinitions columnDefinitions = ((Row)row).getColumnDefinitions();
                LinkedHashMap<String, Object> rowValuesMap = new LinkedHashMap<String, Object>(columnDefinitions.size());
                for (int i = 0; i < columnDefinitions.size(); ++i) {
                    Object value = this.getColumnValue((Row)row, i, columnDefinitions.getType(i).getName());
                    rowValuesMap.put(columnDefinitions.getName(i), value);
                }
                array.add(rowValuesMap);
            }
            return array;
        }
        return responseBody;
    }

    static {
        configCacheMaintenanceService = Executors.newSingleThreadScheduledExecutor();
        isCacheCleanupScheduled = false;
        MAPPER = new ObjectMapper();
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        defaultQueryTimeout = Config.getConfig().getIntOrDefault("sql.transport.dataSource.defaultQueryTimeout", 360);
        initialSize = Config.getConfig().getIntOrDefault("sql.transport.dataSource.initialSize", 2);
        maxTotal = Config.getConfig().getIntOrDefault("sql.transport.dataSource.maxTotal", 100);
        maxIdle = Config.getConfig().getIntOrDefault("sql.transport.dataSource.maxIdle", 10);
        minIdle = Config.getConfig().getIntOrDefault("sql.transport.dataSource.minIdle", 0);
        testWhileIdle = Boolean.parseBoolean(Config.getConfig().getStringOrDefault("sql.transport.dataSource.testWhileIdle", "false"));
        fastFailValidation = Boolean.parseBoolean(Config.getConfig().getStringOrDefault("sql.transport.dataSource.fastFailValidation", "false"));
        removeAbandonedOnMaintenance = Boolean.parseBoolean(Config.getConfig().getStringOrDefault("sql.transport.dataSource.removeAbandonedOnMaintenance", "false"));
        removeAbandonedOnBorrow = Boolean.parseBoolean(Config.getConfig().getStringOrDefault("sql.transport.dataSource.removeAbandonedOnBorrow", "false"));
        maxWaitMillis = Config.getConfig().getIntOrDefault("sql.transport.dataSource.maxWaitMillis", 10000);
        minEvictableIdleTimeMillis = Config.getConfig().getIntOrDefault("sql.transport.dataSource.minEvictableIdleTimeMillis", 900000);
        timeBetweenEvictionRunsMillis = Config.getConfig().getIntOrDefault("sql.transport.dataSource.timeBetweenEvictionRunsMillis", 600000);
        maxConnLifetimeMillis = Config.getConfig().getIntOrDefault("sql.transport.dataSource.maxConnLifetimeMillis", 1800000);
        ojdbcReadTimeout = Config.getConfig().getIntOrDefault("sql.transport.dataSource.ojdbc.ReadTimeout", -1);
        ojdbcConnectTimeout = Config.getConfig().getIntOrDefault("sql.transport.dataSource.ojdbc.ConnectTimeout", -1);
        ojdbcOutboundConnectTimeout = Config.getConfig().getIntOrDefault("sql.transport.dataSource.ojdbc.OutboundConnectTimeout", -1);
        dataSourcesCacheEnable = Boolean.parseBoolean(Config.getConfig().getStringOrDefault("sql.transport.dataSourcesCache.enable", "true"));
        dataSourcesCacheExpireMinutes = Config.getConfig().getIntOrDefault("sql.transport.dataSourcesCache.expireMinutes", 1380);
        dataSourcesCacheRecordStats = Boolean.parseBoolean(Config.getConfig().getStringOrDefault("sql.transport.dataSourcesCache.recordStats", "false"));
        if (dataSourcesCacheEnable) {
            CacheBuilder builder = CacheBuilder.newBuilder();
            if (dataSourcesCacheExpireMinutes != -1) {
                builder.expireAfterAccess((long)dataSourcesCacheExpireMinutes, TimeUnit.MINUTES);
            }
            if (dataSourcesCacheRecordStats) {
                builder.recordStats();
            }
            configCache = builder.removalListener(removalNotification -> {
                BasicDataSource ds;
                SqlConfig sqlConfig;
                if (removalNotification.getCause().equals((Object)RemovalCause.EXPIRED) && (sqlConfig = (SqlConfig)removalNotification.getValue()) != null && (ds = sqlConfig.getDataSource()) != null && !ds.isClosed()) {
                    try {
                        ds.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }).build((CacheLoader)new CacheLoader<ConnectionProperties, SqlConfig>(){

                public SqlConfig load(@Nonnull ConnectionProperties id) {
                    BasicDataSource dataSource = (BasicDataSource)SqlOutboundTransport.setupDataSource(id);
                    return new SqlConfig(dataSource);
                }
            });
        } else {
            configCache = null;
        }
    }

    private static class SqlConfig {
        BasicDataSource dataSource;
        JdbcTemplate jdbcTemplate;

        public SqlConfig(BasicDataSource dataSource) {
            this.dataSource = dataSource;
            this.jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        }

        public BasicDataSource getDataSource() {
            return this.dataSource;
        }

        public JdbcTemplate getJdbcTemplate() {
            return this.jdbcTemplate;
        }
    }
}

