/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.transport.ss7.outbound;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.transport.base.AbstractTransportImpl;
import org.qubership.automation.itf.core.util.transport.base.OutboundTransport;
import org.qubership.automation.itf.transport.ss7.SS7Constants;
import org.qubership.automation.ss7lib.connection.ConnectionHolder;
import org.qubership.automation.ss7lib.proxy.service.ExecutionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UserName(value="Outbound SS7 Synchronous")
public class SS7OutboundTransport
extends AbstractTransportImpl
implements SS7Constants,
OutboundTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(SS7OutboundTransport.class);
    private static final ExecutionService EXECUTION_SERVICE = new ExecutionService();
    @Parameter(shortName="portTango", longName="port of tango", description="SCTP Layer connection port on the Tango server", isRedefined=true)
    private String portTango;
    @Parameter(shortName="hostnameTango", longName="host name of tango. One or two e.g. 127.0.0.1,127.0.0.2", description="Hosts", isRedefined=true)
    private String hostnameTango;
    @Parameter(shortName="isProxy", longName="is proxy", description="mode of work with transport", isRedefined=true)
    @Options(value={"True", "False"})
    private String callTimeMax;
    @Parameter(shortName="portApp", longName="port of proxy app", description="Connection port on the proxy app server", isRedefined=true)
    private String portApp;
    @Parameter(shortName="hostnameApp", longName="host name of app. e.g. 127.0.0.1", description="Hosts", isRedefined=true)
    private String hostnameApp;

    public String getShortName() {
        return "SS7 Outbound";
    }

    public Mep getMep() {
        return Mep.OUTBOUND_REQUEST_RESPONSE_SYNCHRONOUS;
    }

    public String getEndpointPrefix() {
        return "/mockingbird-transport-ss7";
    }

    public Message sendReceiveSync(Message message, BigInteger projectId) throws Exception {
        ConnectionProperties connectionProperties = (ConnectionProperties)message.getConnectionProperties();
        if (Boolean.parseBoolean((String)connectionProperties.obtain("isProxy"))) {
            if (!this.ping(this.createURIBuilder(connectionProperties, "/state"))) {
                return this.send(this.createURIBuilder(connectionProperties, "/execute"), message.getText());
            }
        } else if (ConnectionHolder.getInstance().isConnected()) {
            return new Message(EXECUTION_SERVICE.execute(message.getText()));
        }
        throw new IllegalStateException("Connection with Tango is not established yet.");
    }

    private boolean connect(int tangoPort) {
        try {
            LOGGER.info("SS7 proxy for ITF. Listening tango port: {}. Waiting for tango connection...", (Object)tangoPort);
            ConnectionHolder.getInstance().acceptConnection(tangoPort);
            LOGGER.info("Tango has been connected");
            Thread thread = ConnectionHolder.getInstance().runMainLoop();
            thread.join();
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Proxy server is not started", (Throwable)e);
            return false;
        }
    }

    private boolean ping(URIBuilder uri) throws IOException, URISyntaxException {
        URI build = uri.build();
        String response = this.parseHttpResponse(this.doPost(build, ""));
        return Boolean.parseBoolean(response);
    }

    private Message send(URIBuilder uri, String message) throws URISyntaxException, IOException, TransportException {
        URI build = uri.build();
        HttpResponse httpResponse = this.doPost(build, message);
        String response = this.parseHttpResponse(httpResponse);
        if (httpResponse.getStatusLine().getStatusCode() == 500) {
            throw new TransportException("Unable to send SS7 message: " + response);
        }
        return new Message(response);
    }

    private HttpResponse doPost(URI uri, String body) throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost request = new HttpPost(uri);
        StringEntity entity = new StringEntity(body);
        request.setEntity((HttpEntity)entity);
        return client.execute((HttpUriRequest)request);
    }

    private String parseHttpResponse(HttpResponse response) throws IOException {
        return IOUtils.toString((InputStream)response.getEntity().getContent());
    }

    private URIBuilder createURIBuilder(ConnectionProperties connectionProperties, String path) {
        return new URIBuilder().setScheme("http").setHost(connectionProperties.obtain("hostnameApp").toString()).setPort(Integer.parseInt(connectionProperties.obtain("portApp").toString())).setPath(path);
    }

    public String viewEndpoint(ConnectionProperties connectionProperties) {
        return null;
    }
}

