/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.cli.inbound;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CliMessageBuilder {
    private final StringBuilder builder = new StringBuilder();
    private final Pattern pattern;
    private final boolean isAllowedEmpty;
    private final String delimiter;

    public CliMessageBuilder(String delimiter, boolean isAllowedEmpty) {
        String regexPattern = isAllowedEmpty ? ".*" : ".+";
        this.delimiter = delimiter;
        this.isAllowedEmpty = isAllowedEmpty;
        this.pattern = Pattern.compile(delimiter.isEmpty() ? regexPattern : regexPattern + "?" + delimiter, 32);
    }

    public BuilderResult retrieveResult() {
        return this.retrieveResult(this.pattern);
    }

    public BuilderResult retrieveResult(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.builder.toString());
        if (matcher.find()) {
            String group = matcher.group();
            this.builder.delete(0, this.builder.toString().indexOf(group) + group.length());
            return new BuilderResult(true, group);
        }
        return new BuilderResult(false, null);
    }

    public void append(String message) {
        this.builder.append(message);
    }

    public boolean isAllowedEmpty() {
        return this.isAllowedEmpty;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public static class BuilderResult {
        private boolean isMatches;
        private String result;

        public BuilderResult(boolean isMatches, String result) {
            this.isMatches = isMatches;
            this.result = result;
        }

        public boolean isMatches() {
            return this.isMatches;
        }

        public String getResult() {
            return this.result;
        }
    }
}

