/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.cli.inbound;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.LoggingErrorHandlerBuilder;
import org.apache.camel.component.netty4.ChannelHandlerFactories;
import org.apache.camel.component.netty4.ChannelHandlerFactory;
import org.apache.camel.component.netty4.NettyComponent;
import org.apache.camel.component.netty4.NettyConfiguration;
import org.apache.camel.component.netty4.NettyConsumer;
import org.apache.camel.component.netty4.NettyEndpoint;
import org.apache.camel.component.netty4.ServerInitializerFactory;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.ServiceSupport;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.JvmSettings;
import org.qubership.automation.itf.communication.TriggerExecutionMessageSender;
import org.qubership.automation.itf.core.model.communication.TransportType;
import org.qubership.automation.itf.core.model.communication.message.CommonTriggerExecutionMessage;
import org.qubership.automation.itf.core.model.communication.message.TriggerExecutionMessage;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.core.util.transport.service.LockProvider;
import org.qubership.automation.itf.monitoring.metrics.MetricsAggregateService;
import org.qubership.automation.itf.trigger.camel.Helper;
import org.qubership.automation.itf.trigger.camel.inbound.AbstractCamelTrigger;
import org.qubership.automation.itf.trigger.camel.route.ItfAbstractRouteBuilder;
import org.qubership.automation.itf.trigger.cli.CliServerInitializerFactory;
import org.qubership.automation.itf.trigger.cli.inbound.CliMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliTrigger
extends AbstractCamelTrigger {
    private static final Logger LOGGER = LoggerFactory.getLogger(CliTrigger.class);
    private static final String CLI_INBOUND_TRANSPORT_CLASS_NAME = "org.qubership.automation.itf.transport.cli.inbound.CLIInboundTransport";
    private static final Map<UUID, Map<String, CamelContext>> camelContexts = new ConcurrentHashMap<UUID, Map<String, CamelContext>>();

    public CliTrigger(StorableDescriptor triggerConfigurationDescriptor, ConnectionProperties connectionProperties) {
        super(triggerConfigurationDescriptor, connectionProperties);
    }

    protected void activateSpecificTrigger() throws Exception {
        final CamelContext context = this.getCamelContext();
        context.addRoutes((RoutesBuilder)new ItfAbstractRouteBuilder(){

            public void configure() throws Exception {
                NettyComponent nettyComponent = new NettyComponent(context);
                context.addComponent(CliTrigger.this.getId(), (Component)nettyComponent);
                if ("$runningHostname".equals(CliTrigger.this.getConnectionProperties().obtain("remote_ip"))) {
                    CliTrigger.this.getConnectionProperties().replace((Object)"remote_ip", (Object)Config.getConfig().getRunningHostname());
                }
                String cmdDelimiter = (String)CliTrigger.this.getConnectionProperties().obtain("command_delimiter");
                String params = "?textline=true";
                if (StringUtils.isNotBlank((CharSequence)cmdDelimiter) && !"\n".equals(cmdDelimiter)) {
                    SimpleRegistry registry = new SimpleRegistry();
                    ((DefaultCamelContext)context).setRegistry((Registry)registry);
                    registry.put((Object)"tcpStringEncoder", (Object)new StringEncoder());
                    registry.put((Object)"tcpStringDecoder", (Object)new StringDecoder());
                    registry.put((Object)"tcpDelimiterFrameDecoder", (Object)CliTrigger.this.getDelimiterFrameDecoder(cmdDelimiter));
                    params = "?allowDefaultCodec=false&decoders=#tcpDelimiterFrameDecoder,#tcpStringDecoder&encoders=#tcpStringEncoder&autoAppendDelimiter=false";
                }
                Endpoint endpoint = nettyComponent.createEndpoint(CliTrigger.this.getId() + ':' + CliTrigger.this.getConnectionProperties().obtain("type") + "://" + CliTrigger.this.getConnectionProperties().obtain("remote_ip") + ':' + CliTrigger.this.getConnectionProperties().obtain("remote_port") + params);
                String endpointString = endpoint.toString();
                if (!StringUtils.isBlank((CharSequence)((CharSequence)CliTrigger.this.getConnectionProperties().obtain("greeting")))) {
                    NettyConfiguration configuration = ((NettyEndpoint)endpoint).getConfiguration();
                    NettyConsumer consumer = (NettyConsumer)endpoint.createConsumer(null);
                    CliServerInitializerFactory serverInitializerFactory = new CliServerInitializerFactory(consumer, CliTrigger.this.getConnectionProperties());
                    configuration.setServerInitializerFactory((ServerInitializerFactory)serverInitializerFactory);
                }
                boolean isAllowedEmpty = "Yes".equals(CliTrigger.this.getConnectionProperties().getOrDefault((Object)"empty_commands_allowed", (Object)"No"));
                CliMessageBuilder messageBuilder = new CliMessageBuilder(cmdDelimiter == null || cmdDelimiter.equals("\n") || cmdDelimiter.equals(".") ? "" : cmdDelimiter, isAllowedEmpty);
                UUID projectUuid = CliTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid();
                String brokerMessageSelectorValue = Helper.getBrokerMessageSelectorValue();
                this.from(endpoint).routeId(CliTrigger.this.getId()).process(exchange -> {
                    String sessionId = UUID.randomUUID().toString();
                    MetricsAggregateService.putCommonMetrics((UUID)projectUuid, (String)sessionId);
                    LOGGER.info("Project: {}. SessionId: {}. Request is received by endpoint: {}", new Object[]{projectUuid, sessionId, endpoint});
                    String body = (String)exchange.getIn().getBody(String.class);
                    MetricsAggregateService.checkIncomingMessageSize((UUID)projectUuid, (String)body);
                    org.qubership.automation.itf.core.model.jpa.message.Message requestMessage = this.composeRequestMessage(body, messageBuilder);
                    if (requestMessage != null) {
                        this.addRequestHeaders(exchange.getIn(), requestMessage);
                        ItfAbstractRouteBuilder.logExtendedInfo((UUID)projectUuid, (String)sessionId, (String)brokerMessageSelectorValue, (String)CliTrigger.CLI_INBOUND_TRANSPORT_CLASS_NAME, (long)(body == null ? 0L : (long)body.getBytes(JvmSettings.CHARSET).length));
                        TriggerExecutionMessageSender.send((TriggerExecutionMessage)new CommonTriggerExecutionMessage(CliTrigger.CLI_INBOUND_TRANSPORT_CLASS_NAME, requestMessage, CliTrigger.this.getTriggerConfigurationDescriptor(), sessionId, brokerMessageSelectorValue), (Object)CliTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid());
                        LOGGER.debug("Project: {}, SessionId: {}, transport: '{}' - message to executor is sent.", new Object[]{projectUuid, sessionId, CliTrigger.CLI_INBOUND_TRANSPORT_CLASS_NAME});
                        CliTrigger.this.setUpOut(exchange, projectUuid, sessionId);
                        LOGGER.info("Project: {}. SessionId: {}. Response is sent from endpoint: {}", new Object[]{projectUuid, sessionId, endpointString});
                        MetricsAggregateService.recordIncomingRequestDuration((UUID)projectUuid, (TransportType)TransportType.CLI_INBOUND, (String)endpointString, (Duration)Duration.between(exchange.getCreated().toInstant(), OffsetDateTime.now()));
                    }
                });
            }

            private org.qubership.automation.itf.core.model.jpa.message.Message composeRequestMessage(String body, CliMessageBuilder messageBuilder) {
                if (messageBuilder.isAllowedEmpty() || !StringUtils.isEmpty((CharSequence)body)) {
                    return new org.qubership.automation.itf.core.model.jpa.message.Message(body);
                }
                return null;
            }

            private void addRequestHeaders(Message inMessage, org.qubership.automation.itf.core.model.jpa.message.Message requestMessage) {
                InetSocketAddress address;
                if (inMessage.getHeaders() != null && inMessage.getHeaders().containsKey("CamelNettyRemoteAddress") && (address = (InetSocketAddress)inMessage.getHeader("CamelNettyRemoteAddress")) != null) {
                    String remoteHost = address.getHostString();
                    int remotePort = address.getPort();
                    requestMessage.getHeaders().put("remoteIp", remoteHost);
                    requestMessage.getHeaders().put("port", remotePort);
                }
            }

            public Map<String, Object> getAdditionalProperties(Exchange exchange) {
                return new HashMap<String, Object>();
            }

            public List<String> getExcludeHeadersList() {
                return null;
            }
        });
    }

    protected void deactivateSpecificTrigger() throws Exception {
        UUID projectUuid = this.getTriggerConfigurationDescriptor().getProjectUuid();
        if (Objects.nonNull(camelContexts.get(projectUuid))) {
            CamelContext context = camelContexts.get(projectUuid).get(this.getId());
            if (Objects.nonNull(context)) {
                this.deactivateTrigger(context);
                camelContexts.get(projectUuid).remove(this.getId());
            } else {
                this.deactivateTrigger(CAMEL_CONTEXT);
            }
        } else {
            this.deactivateTrigger(CAMEL_CONTEXT);
        }
    }

    private void deactivateTrigger(CamelContext context) throws Exception {
        if (Objects.nonNull(context.hasComponent(this.getId()))) {
            context.stopRoute(this.getId());
            context.removeRoute(this.getId());
            context.removeComponent(this.getId());
        }
    }

    protected void applyTriggerProperties(ConnectionProperties connectionProperties) {
        this.setConnectionProperties(connectionProperties);
    }

    private CamelContext getCamelContext() {
        String cmdDelimiter = (String)this.getConnectionProperties().obtain("command_delimiter");
        if (StringUtils.isNotBlank((CharSequence)cmdDelimiter) && !"\n".equals(cmdDelimiter)) {
            DefaultCamelContext camelContext = new DefaultCamelContext();
            camelContext.createProducerTemplate();
            UUID projectUuid = this.getTriggerConfigurationDescriptor().getProjectUuid();
            this.startContext((CamelContext)camelContext);
            Map contextList = camelContexts.getOrDefault(projectUuid, new ConcurrentHashMap());
            contextList.put(this.getId(), camelContext);
            camelContexts.put(projectUuid, contextList);
            return camelContexts.get(projectUuid).get(this.getId());
        }
        return CAMEL_CONTEXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startContext(CamelContext context) {
        if (!((ServiceSupport)context).isStarted()) {
            try {
                CamelContext camelContext = context;
                synchronized (camelContext) {
                    if (!((ServiceSupport)context).isStarted()) {
                        LoggingErrorHandlerBuilder errorHandlerBuilder = new LoggingErrorHandlerBuilder(LOGGER);
                        context.setErrorHandlerBuilder((ErrorHandlerFactory)errorHandlerBuilder);
                        context.start();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed starting of CamelContext", (Throwable)e);
            }
        }
    }

    private ChannelHandlerFactory getDelimiterFrameDecoder(String cmdDelimiter) {
        ByteBuf[] delimiters = new ByteBuf[]{Unpooled.copiedBuffer((byte[])cmdDelimiter.getBytes(JvmSettings.CHARSET))};
        return ChannelHandlerFactories.newDelimiterBasedFrameDecoder((int)1024, (ByteBuf[])delimiters, (String)"tcp");
    }

    protected void setUpOut(Exchange exchange, UUID projectUuid, String sessionId) throws InterruptedException {
        org.qubership.automation.itf.core.model.jpa.message.Message message = LockProvider.INSTANCE.waitResponse(sessionId, Helper.getLockProviderCheckInterval(), Helper.getLockProviderCheckMaxInterval(), Helper.getLockProviderCheckMultiplier());
        LOGGER.debug("Project {}, SessionId {}. Response is got from SessionHandler.", (Object)projectUuid, (Object)sessionId);
        if (message != null) {
            this.buildResponse(exchange, message.getText());
            MetricsAggregateService.incrementIncomingRequestToProject((UUID)projectUuid, (TransportType)TransportType.CLI_INBOUND, (boolean)true);
        } else {
            this.buildResponse(exchange, "Null response; see logs for errors (sessionId: " + sessionId);
            MetricsAggregateService.incrementIncomingRequestToProject((UUID)projectUuid, (TransportType)TransportType.CLI_INBOUND, (boolean)false);
        }
        LOGGER.debug("Project {}, SessionId {}. Response is built.", (Object)projectUuid, (Object)sessionId);
    }

    private void buildResponse(Exchange exchange, String messageText) {
        exchange.getOut().setBody((Object)messageText);
    }
}

