/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.file.inbound;

import com.google.common.collect.Maps;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.SimpleBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.qubership.automation.itf.core.model.communication.TransportType;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.monitoring.metrics.MetricsAggregateService;
import org.qubership.automation.itf.trigger.camel.AbstractTriggerImpl;
import org.qubership.automation.itf.trigger.camel.route.ItfAbstractRouteBuilder;
import org.qubership.automation.itf.trigger.file.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInboundTrigger
extends AbstractTriggerImpl {
    private static final Logger log = LoggerFactory.getLogger(FileInboundTrigger.class);
    private static final String FILE_INBOUND_CLASS_NAME = "org.qubership.automation.itf.transport.file.inbound.FileInbound";
    private CamelContext context;

    public FileInboundTrigger(StorableDescriptor triggerConfigurationDescriptor, ConnectionProperties connectionProperties) {
        super(triggerConfigurationDescriptor, connectionProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkSftpConnection(String ip, String type, ConnectionProperties connectionProperties) throws Exception {
        JSch jsch = new JSch();
        Session session = null;
        String username = connectionProperties.get((Object)"principal").toString();
        String credentials = connectionProperties.get((Object)"credentials").toString();
        try {
            session = jsch.getSession(username, ip, 22);
            session.setConfig("StrictHostKeyChecking", "no");
            session.setPassword(credentials);
            session.connect();
            Channel channel = session.openChannel(type);
            channel.connect();
            channel.disconnect();
            boolean bl = Boolean.TRUE;
            return bl;
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkFtpConnection(String ip, String type, ConnectionProperties connectionProperties, boolean checkLogin) throws Exception {
        FTPClient ftpClient = new FTPClient();
        try {
            ftpClient.connect(ip);
            int reply = ftpClient.getReplyCode();
            boolean isOk = FTPReply.isPositiveCompletion((int)reply);
            if (isOk && checkLogin) {
                String username = connectionProperties.get((Object)"principal").toString();
                String credentials = connectionProperties.get((Object)"credentials").toString();
                boolean bl = ftpClient.login(username, credentials);
                return bl;
            }
            boolean bl = isOk;
            return bl;
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (Exception e) {
                    log.debug("Error while disconnecting of test FTP connection to {}: {}", (Object)ip, (Object)e.getMessage());
                }
            }
        }
    }

    protected void activateSpecificTrigger() throws Exception {
        boolean isConnectionTestOk;
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        String type = this.getConnectionProperties().get((Object)"type").toString();
        if (StringUtils.isEmpty((CharSequence)type)) {
            throw new RuntimeException("Trigger type of the trigger is not set");
        }
        String ip = this.getConnectionProperties().get((Object)"host").toString();
        switch (type) {
            case "sftp": {
                isConnectionTestOk = this.testSftpConnection(ip, type, this.getConnectionProperties());
                break;
            }
            case "ftp": {
                isConnectionTestOk = this.testFtpConnection(ip, type, this.getConnectionProperties());
                break;
            }
            case "file": {
                isConnectionTestOk = true;
                break;
            }
            default: {
                throw new RuntimeException("Unknown trigger type '" + type + "' of the trigger");
            }
        }
        if (!isConnectionTestOk) {
            throw new RuntimeException("Error while activating of " + type + " trigger to " + ip + " (connection test failed)");
        }
        this.startSpecificTrigger();
    }

    private void startSpecificTrigger() throws Exception {
        this.context = new DefaultCamelContext();
        this.context.addRoutes((RoutesBuilder)this.createRoutes());
        this.context.start();
    }

    protected void deactivateSpecificTrigger() throws Exception {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        if (this.context != null) {
            this.context.stop();
            this.context = null;
        }
    }

    protected void applyTriggerProperties(ConnectionProperties connectionProperties) {
        this.setConnectionProperties(connectionProperties);
    }

    ItfAbstractRouteBuilder createRoutes() {
        return new ItfAbstractRouteBuilder(){

            public Map<String, Object> getAdditionalProperties(Exchange exchange) {
                return Maps.newHashMap();
            }

            public List<String> getExcludeHeadersList() {
                return null;
            }

            public void configure() throws Exception {
                ConnectionProperties properties = FileInboundTrigger.this.getConnectionProperties();
                String type = (String)properties.obtain("type");
                String host = (String)properties.obtain("host");
                String path = (String)properties.obtain("path");
                String username = (String)properties.obtain("principal");
                String password = (String)properties.obtain("credentials");
                Object sshKeyPropertiesValue = properties.get((Object)"ssh_key");
                Map extraProperties = (Map)properties.obtain("endpointProperties");
                String uri = FileHelper.buildUri(type, host, path, username, password, sshKeyPropertiesValue, extraProperties);
                this.log.debug("URI for {} trigger was built", (Object)type);
                this.from(uri).idempotentConsumer((Expression)SimpleBuilder.simple((String)"${in.body.lastModified}"), (IdempotentRepository)new MemoryIdempotentRepository()).process(exchange -> {
                    String sessionId = UUID.randomUUID().toString();
                    MetricsAggregateService.putCommonMetrics((UUID)FileInboundTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid(), (String)sessionId);
                    this.log.info("Project: {}. SessionId: {}. Request is received by endpoint: {}", new Object[]{FileInboundTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid(), sessionId, uri});
                    try {
                        this.startSession(exchange, FileInboundTrigger.FILE_INBOUND_CLASS_NAME, properties, FileInboundTrigger.this.getTriggerConfigurationDescriptor(), sessionId);
                        MetricsAggregateService.incrementIncomingRequestToProject((UUID)FileInboundTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid(), (TransportType)TransportType.FILE_INBOUND, (boolean)true);
                    }
                    catch (Exception e) {
                        MetricsAggregateService.incrementIncomingRequestToProject((UUID)FileInboundTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid(), (TransportType)TransportType.FILE_INBOUND, (boolean)false);
                        throw e;
                    }
                });
            }
        };
    }

    public boolean checkIfServerAvailable(Map<String, Boolean> availableServers) {
        Object ip = this.getConnectionProperties().get((Object)"host");
        String type = this.getConnectionProperties().get((Object)"type").toString();
        if (ip == null) {
            if (type.equals("file")) {
                return true;
            }
            log.debug("Misconfigured {} transport: an empty ip-address!", (Object)type);
            return false;
        }
        return availableServers.computeIfAbsent(type + "://" + ip, key -> this.testConnection((String)ip, type, this.getConnectionProperties()));
    }

    private boolean testConnection(String ip, String type, ConnectionProperties connectionProperties) {
        switch (type) {
            case "sftp": {
                return this.testSftpConnection(ip, type, connectionProperties);
            }
            case "ftp": {
                return this.testFtpConnection(ip, type, connectionProperties);
            }
        }
        return true;
    }

    private boolean testSftpConnection(String ip, String type, ConnectionProperties connectionProperties) {
        try {
            return FileInboundTrigger.checkSftpConnection(ip, type, connectionProperties);
        }
        catch (Exception ex) {
            log.debug("Error while testing SFTP connection to {}: {}", (Object)ip, (Object)ex.getMessage());
            return Boolean.FALSE;
        }
    }

    private boolean testFtpConnection(String ip, String type, ConnectionProperties connectionProperties) {
        try {
            return FileInboundTrigger.checkFtpConnection(ip, type, connectionProperties, false);
        }
        catch (Exception ex) {
            log.debug("Error while testing FTP connection to {}: {}", (Object)ip, (Object)ex.getMessage());
            return Boolean.FALSE;
        }
    }
}

