/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.qubership.automation.itf.JvmSettings;

public class FileHelper {
    public static String buildUri(String type, String host, String path, String username, String password, Object sshKeyObj, Map<String, Object> extraProperties) throws IOException {
        boolean isSftp = "sftp".equals(type);
        String sshKey = FileHelper.getSshKey(isSftp, sshKeyObj);
        FileHelper.stopIfRequiredPropertiesIsEmpty(path, type, isSftp, sshKey, password, username);
        boolean passIsBlank = Objects.isNull(password) || FileHelper.isNull(password);
        return type + "://" + FileHelper.appendIfHas(username, "@") + FileHelper.appendIfHas(host, "/") + path + FileHelper.appendIfHas("?password=", password) + (isSftp ? Character.valueOf(passIsBlank ? (char)'?' : '&') : "") + (isSftp ? "useUserKnownHostsFile=false" : "") + (isSftp ? "&preferredAuthentications=publickey,password" : "") + (isSftp && FileHelper.isNotNull(sshKey) ? "&privateKeyFile=" + FileHelper.createTempPemFile(sshKey).getPath() : "") + FileHelper.setExtraProperties(extraProperties, !isSftp && passIsBlank);
    }

    private static File createTempPemFile(String sshKey) throws IOException {
        File tmpfile = File.createTempFile(String.valueOf(System.currentTimeMillis()), ".pem");
        tmpfile.deleteOnExit();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpfile), JvmSettings.CHARSET));){
            writer.write(sshKey);
        }
        return tmpfile;
    }

    public static boolean isNull(String s) {
        return StringUtils.isBlank((CharSequence)s) || "null".equals(s);
    }

    public static boolean isNotNull(String s) {
        return !FileHelper.isNull(s);
    }

    public static String setExtraProperties(Map<String, Object> properties, boolean firstOption) {
        if (properties == null || properties.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirst = firstOption;
        for (Map.Entry<String, Object> item : properties.entrySet()) {
            String key;
            if (StringUtils.isBlank((CharSequence)item.getKey()) || item.getValue() == null || (key = item.getKey().trim()).isEmpty()) continue;
            stringBuilder.append(isFirst ? (char)'?' : '&').append(key).append('=').append(FileHelper.processValue(item.getValue()));
            isFirst = false;
        }
        return stringBuilder.toString();
    }

    private static String processValue(Object objValue) {
        try {
            return URLEncoder.encode((String)objValue, JvmSettings.CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            return (String)objValue;
        }
    }

    private static String appendIfHas(String ... s) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String s1 : s) {
            if (FileHelper.isNull(s1)) {
                return "";
            }
            stringBuilder.append(s1);
        }
        return stringBuilder.toString();
    }

    public static String getSshKey(boolean isSftp, Object sshKeyObj) {
        return isSftp && Objects.nonNull(sshKeyObj) && !((List)sshKeyObj).isEmpty() ? String.join((CharSequence)"\n", (List)sshKeyObj) : null;
    }

    public static void stopIfRequiredPropertiesIsEmpty(String remotePath, String type, boolean isSftp, String sshKey, String password, String username) {
        if (FileHelper.isNull(remotePath) || FileHelper.isNull(type)) {
            throw new IllegalArgumentException("Path/type can't be empty");
        }
        if (isSftp && Strings.isEmpty((CharSequence)sshKey) && Strings.isEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("Password/ssh_key can't be empty! Please fill one of them");
        }
        if (isSftp && Strings.isEmpty((CharSequence)username)) {
            throw new IllegalArgumentException("Username can't be empty!");
        }
    }
}

