/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.http.inbound;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.component.http4.HttpComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.automation.itf.JvmSettings;
import org.qubership.automation.itf.core.message.parser.Parser;
import org.qubership.automation.itf.core.model.communication.TransportType;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.stub.fast.ResponseDescription;
import org.qubership.automation.itf.core.stub.fast.StubEndpointConfig;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.transport.service.LockProvider;
import org.qubership.automation.itf.core.util.transport.service.SessionHandler;
import org.qubership.automation.itf.monitoring.metrics.MetricsAggregateService;
import org.qubership.automation.itf.trigger.FastStubsHelper;
import org.qubership.automation.itf.trigger.camel.Helper;
import org.qubership.automation.itf.trigger.camel.inbound.AbstractCamelTrigger;
import org.qubership.automation.itf.trigger.template.velocity.VelocityTemplateEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpInboundTrigger
extends AbstractCamelTrigger {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpInboundTrigger.class);

    protected HttpInboundTrigger(StorableDescriptor triggerConfigurationDescriptor, ConnectionProperties connectionProperties) {
        super(triggerConfigurationDescriptor, connectionProperties);
    }

    protected org.qubership.automation.itf.core.model.jpa.message.Message setUpOut(Exchange exchange, String sessionId) throws Exception {
        org.qubership.automation.itf.core.model.jpa.message.Message message = LockProvider.INSTANCE.waitResponse(sessionId, Helper.getLockProviderCheckInterval(), Helper.getLockProviderCheckMaxInterval(), Helper.getLockProviderCheckMultiplier());
        LOGGER.debug("Project {}, SessionId {}. Response is got from SessionHandler", (Object)this.getTriggerConfigurationDescriptor().getProjectUuid(), (Object)sessionId);
        if (message != null) {
            if (this.getConnectionProperties() != null) {
                message.fillConnectionProperties((Map)this.getConnectionProperties());
            }
            message.fillHeaders(message.getConnectionProperties(), "headers");
            if (message.getFailedMessage() == null) {
                this.buildResponse(exchange, message);
            } else {
                this.buildErrorResponse(exchange, message);
            }
        } else {
            this.buildUnknownErrorResponse(exchange, sessionId);
        }
        LOGGER.debug("Project {}, SessionId {}. Response is built", (Object)this.getTriggerConfigurationDescriptor().getProjectUuid(), (Object)sessionId);
        return message;
    }

    protected void collectMetrics(UUID projectUuid, TransportType transportType, String endPoint, boolean resultState, OffsetDateTime started) {
        MetricsAggregateService.incrementIncomingRequestToProject((UUID)projectUuid, (TransportType)transportType, (boolean)resultState);
        MetricsAggregateService.recordIncomingRequestDuration((UUID)projectUuid, (TransportType)transportType, (String)endPoint, (Duration)Duration.between(started, OffsetDateTime.now()));
    }

    public boolean prepareFastResponse(Exchange exchange, org.qubership.automation.itf.core.model.jpa.message.Message message, StubEndpointConfig cfg, String sessionId, StorableDescriptor triggerDescriptor) throws Exception {
        ResponseDescription responseDescription;
        if (cfg == null || Helper.isTrue((Boolean)cfg.getDisabled())) {
            return false;
        }
        Date started = new Date();
        Parser parser = new Parser();
        JsonContext parsedContext = parser.parseToJsonContext(message, (Collection)cfg.getParsingRules(), triggerDescriptor.getProjectId());
        this.duplicateContextToTcAndSp(parsedContext);
        FastStubsHelper.recalculateOperationDefinitionKey((StubEndpointConfig)cfg, (JsonContext)parsedContext);
        List operationParsingRules = (List)cfg.getOperationParsingRules().get(cfg.getOperationDefinitionKey());
        if (operationParsingRules != null) {
            JsonContext parsedOperationsContext = parser.parseToJsonContext(message, (Collection)operationParsingRules, triggerDescriptor.getProjectId());
            this.duplicateContextToTcAndSp(parsedOperationsContext);
            parsedContext.merge((Map)parsedOperationsContext);
        }
        if ((responseDescription = FastStubsHelper.checkConditions((JsonContext)parsedContext, (StubEndpointConfig)cfg)) == null && cfg.getDefaultResponse() != null && !Helper.isTrue((Boolean)cfg.getDefaultResponse().getDisabled())) {
            responseDescription = cfg.getDefaultResponse();
        }
        if (responseDescription == null) {
            return false;
        }
        org.qubership.automation.itf.core.model.jpa.message.Message outgoing = this.setUpFastOut(exchange, sessionId, responseDescription, parsedContext);
        if (!FastStubsHelper.isReportingSkipped((Boolean)responseDescription.getSkipReporting(), (Boolean)cfg.getSkipReporting())) {
            try {
                FastStubsHelper.sendMessageToReport((org.qubership.automation.itf.core.model.jpa.message.Message)message, (org.qubership.automation.itf.core.model.jpa.message.Message)outgoing, (StorableDescriptor)triggerDescriptor, (Date)started, (Date)new Date(), (JsonContext)parsedContext, (String)cfg.getConfiguredEndpoint(), (ResponseDescription)responseDescription);
            }
            catch (Exception ex) {
                LOGGER.error("Error while reporting from Fast Stub, endpoint {}", (Object)cfg.getConfiguredEndpoint(), (Object)ex);
            }
        }
        return true;
    }

    private void duplicateContextToTcAndSp(JsonContext ctx) {
        JsonContext sp = new JsonContext();
        sp.merge((Map)ctx);
        JsonContext tc = new JsonContext();
        tc.put((Object)"saved", (Object)new JsonContext());
        ((JsonContext)tc.get((Object)"saved")).merge((Map)ctx);
        ctx.put((Object)"sp", (Object)sp);
        ctx.put((Object)"tc", (Object)tc);
    }

    protected org.qubership.automation.itf.core.model.jpa.message.Message setUpFastOut(Exchange exchange, String sessionId, ResponseDescription responseDescription, JsonContext context) throws Exception {
        org.qubership.automation.itf.core.model.jpa.message.Message message = new org.qubership.automation.itf.core.model.jpa.message.Message(this.replaceVariables(responseDescription.getBody(), context));
        if (this.getConnectionProperties() != null) {
            message.fillConnectionProperties((Map)this.getConnectionProperties());
        }
        message.fillHeaders(message.getConnectionProperties(), "headers");
        this.processHeaders(responseDescription.getHeaders(), context);
        message.getHeaders().putAll(responseDescription.getHeaders());
        String responseCodeFromTemplate = this.replaceVariables(responseDescription.getResponseCode(), context);
        if (StringUtils.isNotEmpty((CharSequence)responseCodeFromTemplate)) {
            message.getHeaders().put("CamelHttpResponseCode", responseCodeFromTemplate);
        }
        this.buildResponse(exchange, message);
        LOGGER.debug("Project {}, SessionId {}. Response is built", (Object)this.getTriggerConfigurationDescriptor().getProjectUuid(), (Object)sessionId);
        return message;
    }

    protected String replaceVariables(String input, JsonContext context) {
        return ((VelocityTemplateEngine)TemplateEngineFactory.get()).process(input, context);
    }

    protected void processHeaders(Map<String, Object> headersMap, JsonContext context) {
        for (Map.Entry<String, Object> entry : headersMap.entrySet()) {
            if (entry.getValue() instanceof List) {
                List oldlist = (List)entry.getValue();
                ArrayList<String> newlist = new ArrayList<String>();
                for (String elem : oldlist) {
                    newlist.add(this.replaceVariables(Objects.toString(elem, ""), context));
                }
                entry.setValue(newlist);
                continue;
            }
            entry.setValue(this.replaceVariables(Objects.toString(entry.getValue(), ""), context));
        }
    }

    private void buildErrorResponse(Exchange exchange, org.qubership.automation.itf.core.model.jpa.message.Message message) {
        Message out = exchange.getOut();
        out.setHeader("CamelHttpResponseCode", (Object)"500");
        out.setHeader("Content-Type", (Object)"text/plain");
        Map headers = message.getHeaders();
        if (headers != null) {
            out.getHeaders().putAll(headers);
        }
        out.setBody((Object)message.getFailedMessage());
        out.setFault(true);
    }

    private void buildUnknownErrorResponse(Exchange exchange, String sessionId) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div>").append("<p>Response message is NULL for sessionId ").append(sessionId);
        Exception ex = exchange.getException();
        if (ex == null) {
            sb.append(" and there are no exchange exceptions.</p>").append("<p>Recommendations:</p>");
        } else {
            sb.append("; exchange exception(s) happen, please check: ").append(ex.getMessage()).append("<br>Stacktrace: ").append(ExceptionUtils.getStackTrace((Throwable)ex)).append("</p>").append("<p>Additionally:</p>");
        }
        sb.append("<p> 1) Please check ITF logs in the ITF root folder and 'itf_logs' sub-folder,</p>").append("<p> 2) Check if you haven't properly configured response template on the situation.</p>").append("<p>Please contact ITF Support in case of investigation difficulties.</p>").append("</div>");
        Message out = exchange.getOut();
        out.setBody((Object)sb.toString());
        out.setHeader("CamelHttpResponseCode", (Object)500);
        out.setHeader("Content-Type", (Object)"text/html");
        out.setFault(true);
    }

    private void buildResponse(Exchange exchange, org.qubership.automation.itf.core.model.jpa.message.Message message) throws Exception {
        Message out = exchange.getOut();
        out.setHeader("CamelHttpResponseCode", this.getOrDefault(message.getConnectionProperties(), "responseCode", "200"));
        out.setHeader("Content-Type", this.getOrDefault(message.getConnectionProperties(), "contentType", "text/html"));
        Map headers = message.getHeaders();
        if (headers != null) {
            out.getHeaders().putAll(headers);
        }
        message.convertAndSetHeaders(out.getHeaders());
        this.composeBody(out, message);
    }

    protected void activateSpecificTrigger() throws Exception {
        LockProvider.INSTANCE.init();
        SessionHandler.INSTANCE.init();
        this.createAndConfigureContext();
    }

    protected abstract RoutesBuilder createRoute();

    protected abstract Message composeBody(Message var1, org.qubership.automation.itf.core.model.jpa.message.Message var2) throws Exception;

    protected void deactivateSpecificTrigger() throws Exception {
        String curId;
        String id = this.getId();
        int cnt = 1;
        while (CAMEL_CONTEXT.getRoute(curId = id + cnt) != null) {
            CAMEL_CONTEXT.stopRoute(curId);
            CAMEL_CONTEXT.removeRoute(curId);
            ++cnt;
        }
        CAMEL_CONTEXT.stopRoute(id);
        CAMEL_CONTEXT.removeRoute(id);
        CAMEL_CONTEXT.removeComponent(id);
        LOGGER.info("CAMEL_CONTEXT [{}] is deactivated successfully", (Object)id);
    }

    protected void applyTriggerProperties(ConnectionProperties connectionProperties) {
        this.setConnectionProperties(connectionProperties);
    }

    public void validateRequest(Exchange exchange) {
    }

    public void validateResponse(Exchange exchange) {
    }

    private Object getOrDefault(Map<String, Object> properties, String key, String defaultValue) {
        Object value = properties.get(key);
        return value == null || !properties.containsKey(key) || "".equals(value.toString()) ? defaultValue : value;
    }

    protected Map<String, Object> getAdditionalProperties(Exchange exchange) {
        HashMap<String, Object> addProperties = new HashMap<String, Object>();
        try {
            String uriParams;
            String uri = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
            String query = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
            String string = uriParams = StringUtils.isBlank((CharSequence)uri) ? "" : uri;
            if (!StringUtils.isBlank((CharSequence)query)) {
                uriParams = uriParams + "?" + query;
            }
            addProperties.put("uriParams", URLDecoder.decode(uriParams, JvmSettings.CHARSET_NAME));
            addProperties.put("method", exchange.getIn().getHeader("CamelHttpMethod").toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return addProperties;
    }

    private void createAndConfigureContext() throws Exception {
        CAMEL_CONTEXT.addRoutes(this.createRoute());
        if (CAMEL_CONTEXT.getComponentNames().contains(this.getId())) {
            CAMEL_CONTEXT.removeComponent(this.getId());
        }
        HttpComponent http4Component = new HttpComponent();
        CAMEL_CONTEXT.addComponent(this.getId(), (Component)http4Component);
    }

    public CamelContext getCamelContext() {
        return CAMEL_CONTEXT;
    }
}

