/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.http;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class PreconfiguredHttpClientHolder {
    private static final CloseableHttpClient HTTPCLIENT = PreconfiguredHttpClientHolder.configureClient();
    private static final int HTTP_CLIENT_TIMEOUT_VALUE = 300000;

    public static CloseableHttpClient get() {
        return HTTPCLIENT;
    }

    private static CloseableHttpClient configureClient() {
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            TrustAllStrategy trustStrategy = new TrustAllStrategy();
            builder.loadTrustMaterial(null, (TrustStrategy)trustStrategy);
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)new NoopHostnameVerifier());
            RequestConfig config = RequestConfig.custom().setConnectTimeout(300000).setConnectionRequestTimeout(300000).setSocketTimeout(300000).build();
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).setDefaultRequestConfig(config).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Http client is not initialized", e);
        }
    }
}

