/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.http;

import com.google.gson.Gson;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.Message;
import org.apache.camel.StringSource;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.http4.HttpComponent;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.qubership.automation.itf.JvmSettings;
import org.qubership.automation.itf.core.util.config.ApplicationConfig;
import org.qubership.automation.itf.core.util.feign.http.HttpClientFactory;
import org.qubership.automation.itf.trigger.http.GraphglQuery;
import org.qubership.automation.itf.trigger.http.PreconfiguredHttpClientHolder;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;

public class Helper {
    public static void addClientCoordsToHeaders(Map<String, Object> headers, ServletRequest servletRequest) {
        if (Objects.nonNull(servletRequest)) {
            String ipAddress = Helper.getCorrectedAddress(servletRequest.getRemoteAddr());
            headers.put("client", ipAddress);
            headers.put("remoteAddr", ipAddress);
            headers.put("remoteHost", Helper.getCorrectedAddress(servletRequest.getRemoteHost()));
            headers.put("remotePort", servletRequest.getRemotePort());
            headers.put("protocol", servletRequest.getProtocol());
        }
    }

    public static void fixCoNamedHeaders(Map<String, Object> headers, ServletRequest servletRequest) {
        if (Objects.nonNull(servletRequest)) {
            Enumeration names = ((HttpServletRequest)servletRequest).getHeaderNames();
            while (names.hasMoreElements()) {
                String curName = (String)names.nextElement();
                Enumeration requestHeaders = ((HttpServletRequest)servletRequest).getHeaders(curName);
                ArrayList list = new ArrayList();
                while (requestHeaders.hasMoreElements()) {
                    list.add(requestHeaders.nextElement());
                }
                if (list.size() <= 1) continue;
                headers.replace(curName, list);
            }
        }
    }

    public static Message composeBodyForSoapOutbound(Message camelMessage, org.qubership.automation.itf.core.model.jpa.message.Message itfMessage) {
        Helper.turnOffTransferEncodingChunkedHeader(camelMessage);
        camelMessage.setBody((Object)itfMessage.getText());
        return camelMessage;
    }

    public static Message composeBodyForSoapInbound(Message camelMessage, org.qubership.automation.itf.core.model.jpa.message.Message itfMessage, boolean isRawDataformat) {
        Helper.parseAndSetContentType(camelMessage, camelMessage.getHeader("Content-Type").toString());
        Helper.turnOffTransferEncodingChunkedHeader(camelMessage);
        if (!StringUtils.isBlank((CharSequence)itfMessage.getText())) {
            if (isRawDataformat) {
                camelMessage.setBody((Object)itfMessage.getText());
            } else {
                StringSource stringSource = new StringSource(itfMessage.getText());
                ArrayList<StringSource> list = new ArrayList<StringSource>();
                list.add(stringSource);
                CxfPayload cxp = new CxfPayload(null, list, null);
                camelMessage.setBody((Object)cxp);
            }
        }
        return camelMessage;
    }

    public static Message composeBodyForRest(Message camelMessage, org.qubership.automation.itf.core.model.jpa.message.Message itfMessage) {
        String contentTypeString = camelMessage.getHeader("Content-Type").toString();
        ContentType contentType = Helper.parseAndSetContentType(camelMessage, contentTypeString);
        Object contentDisposition = camelMessage.getHeader("Content-Disposition");
        if (contentType.getMimeType().equals(ContentType.MULTIPART_FORM_DATA.getMimeType())) {
            return Helper.composeMultipartBody(camelMessage, itfMessage, contentType, (String)contentDisposition);
        }
        if (contentDisposition != null && (contentDisposition.toString().startsWith("attachment") || contentDisposition.toString().startsWith("inline"))) {
            return Helper.composeAttachmentsBody(camelMessage, itfMessage);
        }
        if (contentTypeString.startsWith("application/graphql")) {
            return Helper.graphqlToJson(camelMessage, itfMessage, contentTypeString);
        }
        Helper.turnOffTransferEncodingChunkedHeader(camelMessage);
        camelMessage.setBody((Object)itfMessage.getText());
        return camelMessage;
    }

    private static ContentType parseAndSetContentType(Message camelMessage, String contentTypeString) {
        ContentType contentType = ContentType.parse((String)contentTypeString);
        if (contentType.getCharset() != null) {
            camelMessage.getExchange().setProperty("CamelCharsetName", (Object)contentType.getCharset().toString());
        }
        return contentType;
    }

    public static void clearForbiddenHeaders(HttpComponent httpComponent, DefaultHeaderFilterStrategy itfHeaderFilterStrategy) {
        httpComponent.setHeaderFilterStrategy((HeaderFilterStrategy)itfHeaderFilterStrategy);
    }

    private static Message composeMultipartBody(Message camelMessage, org.qubership.automation.itf.core.model.jpa.message.Message itfMessage, ContentType contentType, String contentDisposition) {
        if (camelMessage.getHeader("filename") == null && camelMessage.getHeader("partname") == null) {
            camelMessage.setBody((Object)itfMessage.getText());
            return camelMessage;
        }
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        String boundary = contentType.getParameter("boundary");
        if (!StringUtils.isBlank((CharSequence)boundary)) {
            multipartEntityBuilder.setBoundary(boundary);
        }
        Object response = null;
        try {
            String filename = (String)camelMessage.getHeader("filename");
            String partname = (String)camelMessage.getHeader("partname");
            if (StringUtils.isBlank((CharSequence)partname)) {
                partname = "file";
            }
            if (StringUtils.isBlank((CharSequence)filename)) {
                String partFilename = Helper.getPartFilename(contentDisposition);
                File tmpfile = File.createTempFile(partFilename, ".tmp");
                tmpfile.deleteOnExit();
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpfile), JvmSettings.CHARSET);){
                    writer.write(itfMessage.getText());
                }
                multipartEntityBuilder.addPart(partname, (ContentBody)new FileBody(tmpfile, contentType, partFilename));
            } else {
                try {
                    URL url = new URL(filename);
                    multipartEntityBuilder.addPart(partname, (ContentBody)new ByteArrayBody((byte[])camelMessage.getExchange().getContext().getTypeConverter().convertTo(byte[].class, (Object)Helper.getViaClient(url)), Helper.getPartFilename(contentDisposition)));
                }
                catch (MalformedURLException ex) {
                    multipartEntityBuilder.addPart(partname, (ContentBody)new FileBody(new File(filename)));
                }
            }
            camelMessage.setBody((Object)multipartEntityBuilder.build());
            return camelMessage;
        }
        catch (IOException | URISyntaxException ex) {
            throw new RuntimeException("File exception while composing multipart message", ex);
        }
    }

    private static void turnOffTransferEncodingChunkedHeader(Message camelMessage) {
        camelMessage.setHeader("CamelHttpChunked", (Object)false);
    }

    private static String getPartFilename(String contentDisposition) {
        if (StringUtils.isBlank((CharSequence)contentDisposition)) {
            return "file";
        }
        int i = contentDisposition.indexOf("filename=\"");
        if (i < 0) {
            return "file";
        }
        return contentDisposition.substring(i + 10, contentDisposition.indexOf("\"", i + 10));
    }

    private static Message composeAttachmentsBody(Message camelMessage, org.qubership.automation.itf.core.model.jpa.message.Message itfMessage) {
        String filename = (String)camelMessage.getHeader("filename");
        InputStream inputStream = null;
        try {
            URL url = new URL(filename);
            if (url.getProtocol().equals("https")) {
                inputStream = Helper.getViaClient(url);
            }
            camelMessage.addAttachment("fileAttachment", new DataHandler((DataSource)new URLDataSource(url)));
        }
        catch (MalformedURLException ex) {
            camelMessage.addAttachment("fileAttachment", new DataHandler((DataSource)new FileDataSource(filename)));
        }
        catch (Exception ex) {
            throw new RuntimeException("HTTPClient exception while composing attachments message", ex);
        }
        try {
            byte[] data = (byte[])camelMessage.getExchange().getContext().getTypeConverter().convertTo(byte[].class, (Object)(inputStream == null ? camelMessage.getAttachment("fileAttachment").getInputStream() : inputStream));
            camelMessage.setBody((Object)data);
            return camelMessage;
        }
        catch (Exception ex) {
            throw new RuntimeException("File exception while composing attachments message", ex);
        }
    }

    private static String graphql2json(String graphqlString) {
        return new Gson().toJson((Object)new GraphglQuery(graphqlString));
    }

    private static Message graphqlToJson(Message camelMessage, org.qubership.automation.itf.core.model.jpa.message.Message itfMessage, String sourceContentTypeString) {
        String targetContentTypeString = sourceContentTypeString.replace("application/graphql", "application/json");
        camelMessage.setHeader("Content-Type", (Object)targetContentTypeString);
        itfMessage.getHeaders().put("Content-Type", targetContentTypeString);
        camelMessage.setBody((Object)Helper.graphql2json(itfMessage.getText()));
        return camelMessage;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Null check implemented")
    private static InputStream getViaClient(URL url) throws IOException, URISyntaxException {
        HttpGet request;
        String datasetServiceUrl = ApplicationConfig.env.getProperty("dataset.service.url");
        if (datasetServiceUrl != null && url.toString().startsWith(datasetServiceUrl)) {
            String datasetsRoute = ApplicationConfig.env.getProperty("feign.atp.datasets.route");
            UUID dataSetUuid = UUID.fromString(url.getFile().replace("/" + datasetsRoute + "/attachment/", ""));
            ResponseEntity responseEntity = HttpClientFactory.getDatasetsAttachmentFeignClient().getAttachmentByParameterId(dataSetUuid);
            if (!responseEntity.hasBody()) {
                throw new IOException(String.format("Response body is null for '%s', http status %s.", url, responseEntity.getStatusCode()));
            }
            return ((Resource)Objects.requireNonNull(responseEntity.getBody())).getInputStream();
        }
        CloseableHttpClient client = PreconfiguredHttpClientHolder.get();
        CloseableHttpResponse response = client.execute((HttpUriRequest)(request = new HttpGet(url.toURI())));
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 300) {
            String body = "";
            if (response.getEntity() != null) {
                body = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            }
            throw new IOException(String.format("Response is not accepted for '%s': %s [%s], body: %s", url, response.getStatusLine().getReasonPhrase(), statusCode, body));
        }
        if (response.getEntity() == null) {
            throw new IOException(String.format("Response body is null for '%s': %s [%s]", url, response.getStatusLine().getReasonPhrase(), statusCode));
        }
        return response.getEntity().getContent();
    }

    private static String getCorrectedAddress(String addr) {
        if (addr == null) {
            return null;
        }
        return addr.equals("0:0:0:0:0:0:0:1") ? "localhost" : addr;
    }
}

