/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.http2.inbound;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.qubership.automation.itf.JvmSettings;
import org.qubership.automation.itf.communication.TriggerExecutionMessageSender;
import org.qubership.automation.itf.core.model.communication.TransportType;
import org.qubership.automation.itf.core.model.communication.message.CommonTriggerExecutionMessage;
import org.qubership.automation.itf.core.model.communication.message.TriggerExecutionMessage;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.config.ApplicationConfig;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.core.util.transport.service.LockProvider;
import org.qubership.automation.itf.monitoring.metrics.MetricsAggregateService;
import org.qubership.automation.itf.trigger.camel.AbstractTriggerImpl;
import org.qubership.automation.itf.trigger.camel.Helper;
import org.qubership.automation.itf.trigger.camel.route.ItfAbstractRouteBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2InboundTrigger
extends AbstractTriggerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http2InboundTrigger.class);
    private static final String HTTP2_INBOUND_TRANSPORT_CLASS_NAME = "org.qubership.automation.itf.transport.http2.inbound.HTTP2InboundTransport";
    private CamelContext context;
    private Undertow undertow;

    public Http2InboundTrigger(StorableDescriptor triggerConfigurationDescriptor, ConnectionProperties connectionProperties) {
        super(triggerConfigurationDescriptor, connectionProperties);
    }

    protected void activateSpecificTrigger() throws Exception {
        this.context = new DefaultCamelContext();
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                if ("$runningHostname".equals(Http2InboundTrigger.this.getConnectionProperties().obtain("remoteIp"))) {
                    Http2InboundTrigger.this.getConnectionProperties().replace((Object)"remoteIp", (Object)Config.getConfig().getRunningHostname());
                }
                int port = Integer.parseInt(Http2InboundTrigger.this.getConnectionProperties().get((Object)"remotePort").toString());
                String host = Http2InboundTrigger.this.getConnectionProperties().get((Object)"remoteIp").toString();
                String configuredEndpoint = Http2InboundTrigger.this.getConnectionProperties().get((Object)"endpoint").toString();
                UUID projectUuid = Http2InboundTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid();
                String brokerMessageSelectorValue = Helper.getBrokerMessageSelectorValue();
                boolean addProjectUuidEndpointPrefix = "Yes".equals(Http2InboundTrigger.this.getConnectionProperties().getOrDefault((Object)"addProjectUuidEndpointPrefix", (Object)"Yes"));
                String projectUuidPrefix = addProjectUuidEndpointPrefix ? Http2InboundTrigger.this.getPrefixWithProjectUuid() : "";
                int ioThreads = Integer.parseInt(ApplicationConfig.env.getProperty("server.undertow.threads.io.transport.http2", "2"));
                int workerThreads = Integer.parseInt(ApplicationConfig.env.getProperty("server.undertow.threads.worker.transport.http2", "16"));
                Http2InboundTrigger.this.undertow = Undertow.builder().setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).addHttpListener(port, host).setIoThreads(ioThreads).setWorkerThreads(workerThreads).setHandler((HttpHandler)Handlers.path().addPrefixPath(projectUuidPrefix + configuredEndpoint, exchange -> exchange.getRequestReceiver().receiveFullBytes((innerExchange, message) -> {
                    block9: {
                        String sessionId = UUID.randomUUID().toString();
                        String body = new String(message, StandardCharsets.UTF_8);
                        MetricsAggregateService.putCommonMetrics((UUID)projectUuid, (String)sessionId);
                        LOGGER.info("Project: {}. SessionId: {}. Request is received by endpoint: {}", new Object[]{projectUuid, sessionId, configuredEndpoint});
                        OffsetDateTime started = OffsetDateTime.now();
                        MetricsAggregateService.checkIncomingMessageSize((UUID)projectUuid, (String)body);
                        Message msg = new Message(body);
                        HeaderMap headerMap = innerExchange.getRequestHeaders();
                        for (HttpString name : headerMap.getHeaderNames()) {
                            HeaderValues values = headerMap.get(name);
                            msg.getHeaders().put(name.toString(), values == null || values.isEmpty() ? "" : (values.size() == 1 ? values.get(0) : values.toString()));
                        }
                        msg.getHeaders().put("protocol", innerExchange.getProtocol().toString());
                        msg.getHeaders().put("CamelHttpMethod", innerExchange.getRequestMethod().toString());
                        msg.getHeaders().put("CamelHttpUri", innerExchange.getRequestURI());
                        msg.getHeaders().put("CamelHttpQuery", innerExchange.getQueryString());
                        msg.getConnectionProperties().putAll(Http2InboundTrigger.this.getConnectionProperties());
                        try {
                            ItfAbstractRouteBuilder.logExtendedInfo((UUID)projectUuid, (String)sessionId, (String)brokerMessageSelectorValue, (String)Http2InboundTrigger.HTTP2_INBOUND_TRANSPORT_CLASS_NAME, (long)body.getBytes(JvmSettings.CHARSET).length);
                            TriggerExecutionMessageSender.send((TriggerExecutionMessage)new CommonTriggerExecutionMessage(Http2InboundTrigger.HTTP2_INBOUND_TRANSPORT_CLASS_NAME, msg, Http2InboundTrigger.this.getTriggerConfigurationDescriptor(), sessionId, brokerMessageSelectorValue), (Object)Http2InboundTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid());
                            LOGGER.debug("Project: {}, SessionId: {}, Broker Message Selector Value: {}, transport: '{}' - message to executor is sent.", new Object[]{projectUuid, sessionId, brokerMessageSelectorValue, Http2InboundTrigger.HTTP2_INBOUND_TRANSPORT_CLASS_NAME});
                            Message response = Http2InboundTrigger.this.setUpOut(innerExchange, projectUuid, sessionId);
                            if (response != null) {
                                innerExchange.getResponseSender().send(response.getText());
                                LOGGER.info("Project: {}. SessionId: {}. Response is sent from endpoint: {}", new Object[]{projectUuid, sessionId, configuredEndpoint});
                                MetricsAggregateService.incrementIncomingRequestToProject((UUID)projectUuid, (TransportType)TransportType.HTTP2_INBOUND, (boolean)true);
                                break block9;
                            }
                            throw new RuntimeException("Response message is NULL for sessionId " + sessionId + " (as a rule, not received in time from ITF-EXECUTOR)");
                        }
                        catch (InterruptedException e) {
                            Http2InboundTrigger.this.processException(innerExchange, projectUuid, sessionId, 524, e);
                        }
                        catch (Exception e) {
                            Http2InboundTrigger.this.processException(innerExchange, projectUuid, sessionId, 500, e);
                        }
                        finally {
                            MetricsAggregateService.recordIncomingRequestDuration((UUID)projectUuid, (TransportType)TransportType.HTTP2_INBOUND, (String)configuredEndpoint, (Duration)Duration.between(started, OffsetDateTime.now()));
                        }
                    }
                }))).build();
                Http2InboundTrigger.this.undertow.start();
            }
        });
        this.context.start();
        LOGGER.info("Trigger {} (project {}) is activated successfully", this.getTriggerConfigurationDescriptor().getId(), (Object)this.getTriggerConfigurationDescriptor().getProjectUuid());
    }

    protected void deactivateSpecificTrigger() throws Exception {
        if (this.context != null) {
            this.context.stop();
        }
        if (this.undertow != null) {
            this.undertow.stop();
            this.undertow = null;
        }
        LOGGER.info("Trigger {} (project {}) is deactivated successfully", this.getTriggerConfigurationDescriptor().getId(), (Object)this.getTriggerConfigurationDescriptor().getProjectUuid());
    }

    protected void applyTriggerProperties(ConnectionProperties connectionProperties) {
        this.setConnectionProperties(connectionProperties);
    }

    protected Message setUpOut(HttpServerExchange exchange, UUID projectUuid, String sessionId) throws InterruptedException {
        Message message = LockProvider.INSTANCE.waitResponse(sessionId, Helper.getLockProviderCheckInterval(), Helper.getLockProviderCheckMaxInterval(), Helper.getLockProviderCheckMultiplier());
        LOGGER.debug("Project {}, SessionId {}. Response is got from SessionHandler.", (Object)projectUuid, (Object)sessionId);
        if (message != null) {
            Object codeStatus = message.getConnectionProperties().get("responseCode");
            if (codeStatus == null || "".equals(codeStatus.toString())) {
                codeStatus = this.getConnectionProperties().get((Object)"responseCode");
                if (codeStatus == null || "".equals(codeStatus.toString())) {
                    exchange.setStatusCode(Integer.parseInt("200"));
                } else {
                    exchange.setStatusCode(Integer.parseInt(codeStatus.toString()));
                }
            } else {
                exchange.setStatusCode(Integer.parseInt(codeStatus.toString()));
            }
            this.fillHeaders(exchange, message.getHeaders(), this.getConnectionProperties().get((Object)"headers"));
        }
        LOGGER.debug("Project {}, SessionId {}. Response is built.", (Object)projectUuid, (Object)sessionId);
        return message;
    }

    private void fillHeaders(HttpServerExchange exchange, Map<String, Object> messageHeaders, Object triggerHeaders) {
        if (triggerHeaders instanceof Map) {
            ((Map)triggerHeaders).forEach(messageHeaders::putIfAbsent);
        }
        messageHeaders.forEach((key, value) -> exchange.getResponseHeaders().add(new HttpString(key), String.valueOf(value)));
    }

    private void processException(HttpServerExchange exchange, UUID projectUuid, String sessionId, int httpStatusCode, Exception ex) {
        StringBuilder sb = new StringBuilder();
        sb.append("Project: ").append(projectUuid).append(". SessionId: ").append(sessionId).append(". Error while request processing:\n").append(ex.getMessage());
        if (ex.getCause() != null) {
            sb.append("\nCaused by: ").append(ex.getCause());
        }
        exchange.setStatusCode(httpStatusCode);
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
        exchange.getResponseSender().send(sb.toString());
        LOGGER.error("Project: {}. SessionId: {}. Error while request processing", new Object[]{projectUuid, sessionId, ex});
        MetricsAggregateService.incrementIncomingRequestToProject((UUID)projectUuid, (TransportType)TransportType.HTTP2_INBOUND, (boolean)false);
    }
}

