/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.jms;

import com.google.common.base.Strings;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.camel.Component;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.component.jms.DefaultJmsMessageListenerContainer;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConsumer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.trigger.camel.inbound.AbstractCamelTrigger;
import org.qubership.automation.itf.trigger.jms.JmsHelper;
import org.qubership.automation.itf.trigger.jms.inbound.JmsRoutingBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.ExponentialBackOff;

public class JmsTrigger
extends AbstractCamelTrigger {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsTrigger.class);
    private static final long JMS_CONNECTION_RECOVERY_INTERVAL_DEFAULT = Long.parseLong(Config.getConfig().getStringOrDefault("jms.connection.recovery.interval", "5000"), 10);
    private static final long JMS_CONNECTION_MAX_ATTEMPTS_DEFAULT = JmsTrigger.computeMaxAttempts(Config.getConfig().getStringOrDefault("jms.connection.max.attempts", "3600"));
    private static final long JMS_CONNECTION_MAX_ELAPSED_TIME_DEFAULT = Long.parseLong(Config.getConfig().getStringOrDefault("jms.connection.max.elapsed.time", "18000000"), 10);

    public JmsTrigger(StorableDescriptor triggerConfigurationDescriptor, ConnectionProperties connectionProperties) {
        super(triggerConfigurationDescriptor, connectionProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activateSpecificTrigger() throws Exception {
        try (InitialContext initialContext = null;){
            Object jmsConnectionMaxAttemptsConfigured;
            long jmsConnectionMaxAttempts;
            long jmsConnectionRecoveryInterval;
            Component prevAdded = CAMEL_CONTEXT.hasComponent(this.getId());
            if (prevAdded != null) {
                try {
                    LOGGER.info("Before activation: {} - CAMEL_CONTEXT already has component with the same ID {}. It will be deactivated.", (Object)this, (Object)this.getId());
                    this.deactivateSpecificTrigger();
                }
                catch (Exception ex) {
                    LOGGER.debug("Trigger {} deactivation before its activation - ignoring the exception:", (Object)this.getId(), (Object)ex);
                }
            }
            initialContext = this.createContext();
            JmsComponent jmsComponent = this.getComponent(initialContext);
            String destinationName = (String)this.getConnectionProperties().obtain("destination");
            Destination destination = JmsHelper.isPathToDestination(destinationName) ? null : this.getDestination(initialContext, destinationName);
            initialContext.close();
            CAMEL_CONTEXT.addComponent(this.getId(), (Component)jmsComponent);
            CAMEL_CONTEXT.addRoutes((RoutesBuilder)new JmsRoutingBuilder(this.getConnectionProperties(), this.getTriggerConfigurationDescriptor(), destination, jmsComponent, this.getId()));
            Object jmsConnectionRecoveryIntervalConfigured = this.getConnectionProperties().obtain("recoveryInterval");
            long l = jmsConnectionRecoveryInterval = jmsConnectionRecoveryIntervalConfigured != null && !StringUtils.isEmpty((CharSequence)((String)jmsConnectionRecoveryIntervalConfigured)) ? Long.parseLong((String)jmsConnectionRecoveryIntervalConfigured, 10) : JMS_CONNECTION_RECOVERY_INTERVAL_DEFAULT;
            if (jmsConnectionRecoveryInterval < JMS_CONNECTION_RECOVERY_INTERVAL_DEFAULT) {
                jmsConnectionRecoveryInterval = JMS_CONNECTION_RECOVERY_INTERVAL_DEFAULT;
            }
            long l2 = jmsConnectionMaxAttempts = (jmsConnectionMaxAttemptsConfigured = this.getConnectionProperties().obtain("maxAttempts")) != null && !StringUtils.isEmpty((CharSequence)((String)jmsConnectionMaxAttemptsConfigured)) ? JmsTrigger.computeMaxAttempts((String)jmsConnectionMaxAttemptsConfigured) : JMS_CONNECTION_MAX_ATTEMPTS_DEFAULT;
            if (jmsConnectionMaxAttempts < 0L || jmsConnectionMaxAttempts > JMS_CONNECTION_MAX_ATTEMPTS_DEFAULT * 2L) {
                jmsConnectionMaxAttempts = JMS_CONNECTION_MAX_ATTEMPTS_DEFAULT;
            }
            long jmsConnectionMaxElapsedTime = jmsConnectionMaxAttempts > JMS_CONNECTION_MAX_ATTEMPTS_DEFAULT ? JMS_CONNECTION_MAX_ELAPSED_TIME_DEFAULT * 2L : JMS_CONNECTION_MAX_ELAPSED_TIME_DEFAULT;
            ExponentialBackOff backOff = new ExponentialBackOff();
            backOff.setInitialInterval(jmsConnectionRecoveryInterval);
            backOff.setMultiplier(1.5);
            backOff.setMaxInterval(90000L);
            backOff.setMaxElapsedTime(jmsConnectionMaxElapsedTime);
            ((DefaultJmsMessageListenerContainer)((JmsConsumer)CAMEL_CONTEXT.getRoute(this.getId()).getConsumer()).getListenerContainer()).setBackOff((BackOff)backOff);
        }
    }

    private static long computeMaxAttempts(String configValue) {
        return configValue.equalsIgnoreCase("unlimited") ? Long.MAX_VALUE : Long.parseLong(configValue, 10);
    }

    private Destination getDestination(InitialContext initialContext, String destinationName) throws NamingException {
        String escDestinationName = StringEscapeUtils.escapeHtml4((String)destinationName);
        return (Destination)initialContext.lookup(escDestinationName);
    }

    private JmsComponent getComponent(InitialContext initialContext) throws NamingException {
        String strConnectionFactory = String.valueOf(this.getConnectionProperties().get((Object)"connectionFactory"));
        String escConnectionFactory = StringEscapeUtils.escapeHtml4((String)strConnectionFactory);
        ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup(escConnectionFactory);
        return JmsComponent.jmsComponent((ConnectionFactory)connectionFactory);
    }

    protected void deactivateSpecificTrigger() throws Exception {
        CAMEL_CONTEXT.stopRoute(this.getId());
        CAMEL_CONTEXT.removeRoute(this.getId());
        CAMEL_CONTEXT.removeComponent(this.getId());
        LOGGER.info("{} [{}] is deactivated successfully", (Object)CAMEL_CONTEXT, (Object)this.getId());
        this.generateNewId();
    }

    private InitialContext createContext() throws NamingException {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        Properties env = new Properties();
        JmsHelper.putSafe(env, "java.naming.factory.initial", this.getConnectionProperties().get((Object)"initialContextFactory"));
        JmsHelper.putSafe(env, "java.naming.security.principal", this.getConnectionProperties().get((Object)"principal"));
        JmsHelper.putSafe(env, "java.naming.security.credentials", this.getConnectionProperties().get((Object)"credentials"));
        JmsHelper.putSafe(env, "java.naming.provider.url", this.getConnectionProperties().get((Object)"providerUrl"));
        JmsHelper.putSafe(env, "java.naming.security.authentication", this.getConnectionProperties().get((Object)"authentication"));
        String messageSelector = (String)this.getConnectionProperties().get((Object)"messageSelector");
        if (!Strings.isNullOrEmpty((String)messageSelector)) {
            JmsHelper.putSafe(env, "messageSelector", messageSelector);
        }
        if (this.getConnectionProperties().get((Object)"addJndiProps") != null) {
            env.putAll((Map<?, ?>)((Map)this.getConnectionProperties().get((Object)"addJndiProps")));
        }
        return new InitialContext(env);
    }

    public void applyTriggerProperties(ConnectionProperties connectionProperties) {
        this.setConnectionProperties(connectionProperties);
    }

    public String toString() {
        return "JmsTrigger{destination='" + this.getConnectionProperties().get((Object)"destination") + "', providerUrl='" + this.getConnectionProperties().get((Object)"providerUrl") + "', triggerConfiguration='" + this.getTriggerConfigurationDescriptor().getName() + "'}";
    }

    public boolean checkIfServerAvailable(Map<String, Boolean> availableServers, ConnectionProperties connectionProperties) {
        String providerUrl = (String)connectionProperties.get((Object)"providerUrl");
        return availableServers.computeIfAbsent(providerUrl, key -> this.testConnection(providerUrl, connectionProperties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testConnection(String providerUrl, ConnectionProperties connectionProperties) {
        Context context = null;
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.provider.url", providerUrl);
            env.put("java.naming.factory.initial", connectionProperties.get((Object)"initialContextFactory"));
            env.put("weblogic.jndi.createIntermediateContexts", "true");
            context = new InitialContext(env);
            TopicConnectionFactory tconFactory = (TopicConnectionFactory)context.lookup("javax.jms.TopicConnectionFactory");
            TopicConnection con = tconFactory.createTopicConnection();
            con.close();
            boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (JMSException | NamingException e) {
            boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Availability check for {}: Context isn't closed due to error", (Object)providerUrl, (Object)e);
            }
        }
    }
}

