/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.jms.inbound;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.jms.Destination;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.qubership.automation.itf.core.model.communication.TransportType;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.monitoring.metrics.MetricsAggregateService;
import org.qubership.automation.itf.trigger.camel.route.ItfAbstractRouteBuilder;
import org.qubership.automation.itf.trigger.jms.JmsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsRoutingBuilder
extends ItfAbstractRouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsRoutingBuilder.class);
    private static final String MESSAGE_SELECTOR_PROPERTY_REGEXP = "(.+=.+)";
    private static final String JMS_INBOUND_TRANSPORT_CLASS_NAME = "org.qubership.automation.itf.transport.jms.inbound.JMSInboundTransport";
    private ConnectionProperties connectionProperties;
    private Destination destination;
    private JmsComponent component;
    private String id;
    private StorableDescriptor triggerConfigurationDescriptor;

    public JmsRoutingBuilder(ConnectionProperties connectionProperties, StorableDescriptor triggerConfigurationDescriptor, Destination destination, JmsComponent component, String id) {
        this.triggerConfigurationDescriptor = triggerConfigurationDescriptor;
        this.connectionProperties = connectionProperties;
        this.destination = destination;
        this.component = component;
        this.id = id;
    }

    public void configure() throws Exception {
        LOGGER.debug("Starting of JMSQueue");
        if (Strings.isNullOrEmpty((String)((String)this.connectionProperties.get((Object)"destinationType")))) {
            throw new IllegalArgumentException("Destination type is not specified; should be 'Queue' or 'Topic'.");
        }
        String destinationType = (String)this.connectionProperties.obtain("destinationType");
        String destinationName = (String)this.connectionProperties.obtain("destination");
        String selectorString = (String)this.connectionProperties.get((Object)"messageSelector");
        String selectorExpression = "";
        if (destinationType.equals("Queue") && !Strings.isNullOrEmpty((String)selectorString)) {
            selectorExpression = this.buildSelectorExpression(selectorString);
        }
        if (JmsHelper.isPathToDestination(destinationName)) {
            this.component.getConfiguration().setSelector(selectorExpression);
            String jmsEndpoint = this.id + ':' + destinationType.toLowerCase(Locale.getDefault()) + ':' + destinationName;
            ((RouteDefinition)this.from(jmsEndpoint).process(this.createProcessor(jmsEndpoint))).routeId(this.id);
        } else {
            JmsEndpoint jmsEndpoint = JmsEndpoint.newInstance((Destination)this.destination, (JmsComponent)this.component);
            jmsEndpoint.setSelector(selectorExpression);
            ((RouteDefinition)this.from((Endpoint)jmsEndpoint).process(this.createProcessor(jmsEndpoint.toString()))).routeId(this.id);
        }
    }

    protected Processor createProcessor(String jmsEndpoint) {
        return exchange -> {
            String sessionId = UUID.randomUUID().toString();
            MetricsAggregateService.putCommonMetrics((UUID)this.triggerConfigurationDescriptor.getProjectUuid(), (String)sessionId);
            LOGGER.info("Project: {}. SessionId: {}. Request is received by jmsEndpoint: {}", new Object[]{this.triggerConfigurationDescriptor.getProjectUuid(), sessionId, jmsEndpoint});
            try {
                this.startSession(exchange, JMS_INBOUND_TRANSPORT_CLASS_NAME, this.connectionProperties, this.triggerConfigurationDescriptor, sessionId);
                MetricsAggregateService.incrementIncomingRequestToProject((UUID)this.triggerConfigurationDescriptor.getProjectUuid(), (TransportType)TransportType.JMS_INBOUND, (boolean)true);
            }
            catch (Exception e) {
                MetricsAggregateService.incrementIncomingRequestToProject((UUID)this.triggerConfigurationDescriptor.getProjectUuid(), (TransportType)TransportType.JMS_INBOUND, (boolean)false);
                throw e;
            }
        };
    }

    private String buildSelectorExpression(String selectorString) {
        StringBuilder selectorExpression = new StringBuilder();
        String operatorLike = " LIKE ";
        String operatorOr = " OR ";
        String[] arrHeadersWithValues = selectorString.split(",");
        for (int i = 0; i < arrHeadersWithValues.length; ++i) {
            StringBuilder selectorBuilder = new StringBuilder();
            if (!arrHeadersWithValues[i].matches(MESSAGE_SELECTOR_PROPERTY_REGEXP)) continue;
            selectorBuilder.append('(').append(arrHeadersWithValues[i].split("=")[0].trim()).append(operatorLike).append('\'').append(arrHeadersWithValues[i].split("=")[1].trim()).append('\'').append(')');
            if (i < arrHeadersWithValues.length - 1) {
                selectorBuilder.append(operatorOr);
            }
            selectorExpression.append((CharSequence)selectorBuilder);
        }
        if (selectorExpression.toString().trim().endsWith("OR")) {
            String expression = selectorExpression.toString().trim();
            return expression.substring(0, expression.length() - 2).trim();
        }
        return selectorExpression.toString();
    }

    public Map<String, Object> getAdditionalProperties(Exchange exchange) {
        return new HashMap<String, Object>();
    }

    public List<String> getExcludeHeadersList() {
        return null;
    }
}

