/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.rest.inbound;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.http.common.HttpMessage;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.model.RouteDefinition;
import org.qubership.automation.itf.JvmSettings;
import org.qubership.automation.itf.core.model.communication.TransportType;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.stub.fast.FastResponseConfigsHolder;
import org.qubership.automation.itf.core.stub.fast.StubEndpointConfig;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.core.util.helper.ProjectSettingsHelper;
import org.qubership.automation.itf.monitoring.metrics.MetricsAggregateService;
import org.qubership.automation.itf.trigger.camel.route.ItfAbstractRouteBuilder;
import org.qubership.automation.itf.trigger.http.Helper;
import org.qubership.automation.itf.trigger.http.inbound.HttpInboundTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.ContentCachingRequestWrapper;

public class RestInboundTrigger
extends HttpInboundTrigger {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestInboundTrigger.class);
    private static final String REST_INBOUND_TRANSPORT_CLASS_NAME = "org.qubership.automation.itf.transport.rest.inbound.RESTInboundTransport";

    public RestInboundTrigger(StorableDescriptor triggerConfigurationDescriptor, ConnectionProperties connectionProperties) {
        super(triggerConfigurationDescriptor, connectionProperties);
    }

    protected RouteBuilder createRoute() {
        return new ItfAbstractRouteBuilder(){

            public void configure() {
                UUID projectUuid = RestInboundTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid();
                BigInteger projectId = RestInboundTrigger.this.getTriggerConfigurationDescriptor().getProjectId();
                String endPoint = Objects.toString(RestInboundTrigger.this.getConnectionProperties().get((Object)"endpoint"));
                ArrayList endPointsList = RestInboundTrigger.this.splitEndPoint(endPoint);
                int cnt = 0;
                for (String currentEndPoint : endPointsList) {
                    ((RouteDefinition)this.from("servlet:" + RestInboundTrigger.this.getPrefixWithProjectUuid() + currentEndPoint + "?matchOnUriPrefix=true").process(exchange -> {
                        block6: {
                            OffsetDateTime started;
                            String sessionId;
                            block5: {
                                StubEndpointConfig cfg;
                                sessionId = UUID.randomUUID().toString();
                                MetricsAggregateService.putCommonMetrics((UUID)projectUuid, (String)sessionId);
                                LOGGER.info("Project: {}. SessionId: {}. Request is received by endpoint: {}", new Object[]{projectUuid, sessionId, currentEndPoint});
                                started = OffsetDateTime.now();
                                RestInboundTrigger.this.prepareFilters((ServletEndpoint)exchange.getFromEndpoint());
                                RestInboundTrigger.this.addClientAddressInHeader(exchange);
                                RestInboundTrigger.this.preProcessUrlEncodedMessage(exchange);
                                org.qubership.automation.itf.core.model.jpa.message.Message message = this.prepareIncomingMessage(exchange, RestInboundTrigger.REST_INBOUND_TRANSPORT_CLASS_NAME, RestInboundTrigger.this.getConnectionProperties(), RestInboundTrigger.this.getTriggerConfigurationDescriptor(), sessionId);
                                boolean enableFastStubs = Boolean.parseBoolean(ProjectSettingsHelper.getProjectSettingsService().get((Object)projectId, "enable.fastStubs", "true"));
                                boolean prepared = false;
                                if (enableFastStubs && (cfg = FastResponseConfigsHolder.INSTANCE.getConfig(RestInboundTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid().toString(), StubEndpointConfig.TransportTypes.REST.name(), currentEndPoint)) != null) {
                                    prepared = RestInboundTrigger.this.prepareFastResponse(exchange, message, cfg, sessionId, RestInboundTrigger.this.getTriggerConfigurationDescriptor());
                                }
                                if (prepared) break block5;
                                this.startSession(exchange, RestInboundTrigger.REST_INBOUND_TRANSPORT_CLASS_NAME, RestInboundTrigger.this.getConnectionProperties(), RestInboundTrigger.this.getTriggerConfigurationDescriptor(), sessionId, message);
                                boolean resultState = false;
                                try {
                                    org.qubership.automation.itf.core.model.jpa.message.Message responseMessage = RestInboundTrigger.this.setUpOut(exchange, sessionId);
                                    resultState = responseMessage != null && responseMessage.getFailedMessage() == null;
                                }
                                catch (Throwable ex) {
                                    try {
                                        throw new RuntimeException(String.format("Error while sending REST response, Project: %s, sessionId: %s, endpoint: %s", projectUuid, sessionId, currentEndPoint), ex);
                                    }
                                    catch (Throwable throwable) {
                                        LOGGER.info("Project: {}. SessionId: {}. Response is sent from endpoint: {}", new Object[]{projectUuid, sessionId, currentEndPoint});
                                        RestInboundTrigger.this.collectMetrics(projectUuid, TransportType.REST_INBOUND, currentEndPoint, resultState, started);
                                        throw throwable;
                                    }
                                }
                                LOGGER.info("Project: {}. SessionId: {}. Response is sent from endpoint: {}", new Object[]{projectUuid, sessionId, currentEndPoint});
                                RestInboundTrigger.this.collectMetrics(projectUuid, TransportType.REST_INBOUND, currentEndPoint, resultState, started);
                                break block6;
                            }
                            LOGGER.info("Project: {}. SessionId: {}. Fast-Stub response is sent from endpoint: {}", new Object[]{projectUuid, sessionId, currentEndPoint});
                            RestInboundTrigger.this.collectMetrics(projectUuid, TransportType.REST_INBOUND, currentEndPoint, true, started);
                        }
                    })).routeId(endPointsList.size() == 1 ? RestInboundTrigger.this.getId() : RestInboundTrigger.this.getId() + ++cnt);
                }
            }

            public Map<String, Object> getAdditionalProperties(Exchange exchange) {
                return RestInboundTrigger.this.getAdditionalProperties(exchange);
            }

            public List<String> getExcludeHeadersList() {
                return Arrays.asList("CamelHttpServletRequest", "CamelHttpServletResponse");
            }
        };
    }

    protected Message composeBody(Message camelMessage, org.qubership.automation.itf.core.model.jpa.message.Message itfMessage) {
        return Helper.composeBodyForRest((Message)camelMessage, (org.qubership.automation.itf.core.model.jpa.message.Message)itfMessage);
    }

    private void preProcessUrlEncodedMessage(Exchange exchange) throws UnsupportedEncodingException {
        HttpServletRequest request;
        HttpMessage in = (HttpMessage)exchange.getIn();
        String contentType = (String)in.getHeader("Content-Type", (Object)"text/html", String.class);
        String method = (String)in.getHeader("CamelHttpMethod", (Object)"GET", String.class);
        if (contentType.contains("application/x-www-form-urlencoded") && method.equals("POST") && (request = in.getRequest()) instanceof ContentCachingRequestWrapper) {
            byte[] bytes = ((ContentCachingRequestWrapper)request).getContentAsByteArray();
            if (bytes.length > 0) {
                String encoding = (String)in.getHeader("CamelHttpCharacterEncoding", (Object)JvmSettings.CHARSET_NAME, String.class);
                String content = new String(bytes, encoding);
                in.setBody((Object)URLDecoder.decode(content, encoding));
            } else {
                in.setBody((Object)"");
            }
        }
    }

    private void prepareFilters(ServletEndpoint endpoint) {
        DefaultHeaderFilterStrategy st = (DefaultHeaderFilterStrategy)endpoint.getHeaderFilterStrategy();
        st.setOutFilter(null);
        st.setInFilter(null);
        st.getOutFilter().add("content-type");
        st.setCaseInsensitive(true);
    }

    private void addClientAddressInHeader(Exchange exchange) {
        ServletRequest servletRequest = (ServletRequest)exchange.getIn().getHeader("CamelHttpServletRequest");
        Helper.addClientCoordsToHeaders((Map)exchange.getIn().getHeaders(), (ServletRequest)servletRequest);
        Helper.fixCoNamedHeaders((Map)exchange.getIn().getHeaders(), (ServletRequest)servletRequest);
    }

    private ArrayList<String> splitEndPoint(String s) {
        if (s.contains("(") && s.contains(")") && s.contains("|")) {
            return this.unpackEndPoint(s);
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(s);
        return result;
    }

    private ArrayList<String> unpackEndPoint(String s) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        int level = 0;
        String block = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '(' && level++ == 0) {
                for (String w : list) {
                    list.set(list.indexOf(w), w + block);
                }
                block = "";
                continue;
            }
            if (s.charAt(i) == ')' && --level == 0) {
                ArrayList<String> parts = this.splitBlockOnParts(block);
                for (String w : list) {
                    for (String p : parts) {
                        parts.set(parts.indexOf(p), w + p);
                    }
                    list = parts;
                }
                block = "";
                continue;
            }
            block = block + s.charAt(i);
        }
        for (String w : list) {
            list.set(list.indexOf(w), w + block);
        }
        return list;
    }

    private ArrayList<String> splitBlockOnParts(String s) {
        ArrayList<String> list = new ArrayList<String>();
        int level = 0;
        String block = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '(') {
                ++level;
            } else if (s.charAt(i) == ')') {
                --level;
            }
            if (s.charAt(i) == '|' && level == 0) {
                list.addAll(this.splitEndPoint(block));
                block = "";
                continue;
            }
            block = block + s.charAt(i);
        }
        list.addAll(this.splitEndPoint(block));
        return list;
    }
}

