/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.smpp;

import com.cloudhopper.commons.charset.CharsetUtil;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.impl.DefaultSmppSessionHandler;
import com.cloudhopper.smpp.pdu.DeliverSm;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.pdu.SubmitSmResp;
import com.cloudhopper.smpp.tlv.Tlv;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.itf.core.model.communication.TransportType;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.monitoring.metrics.MetricsAggregateService;
import org.qubership.automation.itf.trigger.smpp.inbound.SmppTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItfSmppSessionHandler
extends DefaultSmppSessionHandler {
    private static final Logger log = LoggerFactory.getLogger(ItfSmppSessionHandler.class);
    private SmppSessionConfiguration configuration;
    private SmppTrigger smppTrigger;
    private String charsetName;

    public ItfSmppSessionHandler(SmppSessionConfiguration configuration, SmppTrigger trigger, ConnectionProperties triggerConnectionProperties) {
        this.configuration = configuration;
        this.smppTrigger = trigger;
        this.charsetName = (String)triggerConnectionProperties.getOrDefault((Object)"charsetName", (Object)"UCS-2");
    }

    public PduResponse firePduRequestReceived(PduRequest pduRequest) {
        PduResponse pduResponse;
        OffsetDateTime started = OffsetDateTime.now();
        UUID currentProject = null;
        try {
            PduResponse pduResponse2;
            if (this.smppTrigger == null) {
                pduResponse2 = this.defaultProcessing(pduRequest);
            } else {
                currentProject = this.smppTrigger.getTriggerConfigurationDescriptor().getProjectUuid();
                MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)currentProject);
                pduResponse2 = this.itfProcessing(pduRequest);
                MetricsAggregateService.incrementIncomingRequestToProject((UUID)currentProject, (TransportType)TransportType.SMPP_INBOUND, (boolean)true);
            }
            pduResponse = pduResponse2;
        }
        catch (Exception e) {
            try {
                if (currentProject != null) {
                    MetricsAggregateService.incrementIncomingRequestToProject((UUID)currentProject, (TransportType)TransportType.SMPP_INBOUND, (boolean)false);
                }
                throw e;
            }
            catch (Throwable throwable) {
                String currentEndPoint = String.format("tcp://%s:%s/%s", this.configuration.getHost(), this.configuration.getPort(), this.configuration.getAddressRange().getAddress());
                if (currentProject != null) {
                    MetricsAggregateService.recordIncomingRequestDuration((UUID)currentProject, (TransportType)TransportType.SMPP_INBOUND, (String)currentEndPoint, (Duration)Duration.between(started, OffsetDateTime.now()));
                }
                throw throwable;
            }
        }
        String currentEndPoint = String.format("tcp://%s:%s/%s", this.configuration.getHost(), this.configuration.getPort(), this.configuration.getAddressRange().getAddress());
        if (currentProject != null) {
            MetricsAggregateService.recordIncomingRequestDuration((UUID)currentProject, (TransportType)TransportType.SMPP_INBOUND, (String)currentEndPoint, (Duration)Duration.between(started, OffsetDateTime.now()));
        }
        return pduResponse;
    }

    private PduResponse defaultProcessing(PduRequest pduRequest) {
        if (pduRequest.isRequest()) {
            if (pduRequest.getClass() == SubmitSm.class) {
                SubmitSm sm = (SubmitSm)pduRequest;
                SubmitSmResp response = (SubmitSmResp)pduRequest.createResponse();
                response.setMessageId("MessageID");
                String message = CharsetUtil.decode((byte[])sm.getShortMessage(), (String)"UCS-2");
                log.debug("[Client] = {}\n [Message] = {},\n [Phone Number] = {},\n [Source Phone Number] = {}", new Object[]{this.configuration.getSystemId(), message, sm.getDestAddress(), sm.getSourceAddress()});
                return response;
            }
            if (pduRequest.getClass() == DeliverSm.class) {
                DeliverSm dlr = (DeliverSm)pduRequest;
                log.debug("Got DELIVER_SM, Msg id={}, Status={}", (Object)dlr.getOptionalParameter((short)30), (Object)dlr.getOptionalParameter((short)1063));
                return pduRequest.createResponse();
            }
        } else {
            log.warn("Don't know how to process pduRequest message {}", (Object)pduRequest);
        }
        return pduRequest.createResponse();
    }

    private PduResponse itfProcessing(PduRequest pduRequest) {
        if (pduRequest.isRequest()) {
            if (pduRequest.getClass() == SubmitSm.class) {
                Message responseMessage;
                SubmitSm sm = (SubmitSm)pduRequest;
                log.info("SubmitSm message is received: [Client] = {}, [Phone Number] = {}, [Source Phone Number] = {}", new Object[]{this.configuration.getSystemId(), sm.getDestAddress(), sm.getSourceAddress()});
                try {
                    responseMessage = this.smppTrigger.produceMessageToItf(this.submitSm2Message(sm));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                SubmitSmResp response = (SubmitSmResp)pduRequest.createResponse();
                this.fillSubmitSmResponse(response, responseMessage);
                return response;
            }
            if (pduRequest.getClass() == DeliverSm.class) {
                DeliverSm dlr = (DeliverSm)pduRequest;
                log.debug("DeliverSm message is received: Msg id = {}, Status = {}", (Object)dlr.getOptionalParameter((short)30), (Object)dlr.getOptionalParameter((short)1063));
                return pduRequest.createResponse();
            }
        }
        return pduRequest.createResponse();
    }

    private Message submitSm2Message(SubmitSm submitSmRequest) {
        Message message = new Message(CharsetUtil.decode((byte[])submitSmRequest.getShortMessage(), (String)this.charsetName));
        message.getHeaders().put("DestAddress", submitSmRequest.getDestAddress().toString());
        message.getHeaders().put("DestAddress_Address", submitSmRequest.getDestAddress().getAddress());
        message.getHeaders().put("DestAddress_Npi", submitSmRequest.getDestAddress().getNpi());
        message.getHeaders().put("DestAddress_Ton", submitSmRequest.getDestAddress().getTon());
        message.getHeaders().put("SourceAddress", submitSmRequest.getSourceAddress().toString());
        message.getHeaders().put("SourceAddress_Address", submitSmRequest.getSourceAddress().getAddress());
        message.getHeaders().put("SourceAddress_Npi", submitSmRequest.getSourceAddress().getNpi());
        message.getHeaders().put("SourceAddress_Ton", submitSmRequest.getSourceAddress().getTon());
        message.getHeaders().put("CommandStatus", submitSmRequest.getCommandStatus());
        if (submitSmRequest.getOptionalParameters() != null) {
            for (Tlv tlv : submitSmRequest.getOptionalParameters()) {
                message.getHeaders().put("OptionalParameters_" + tlv.getTagName(), CharsetUtil.decode((byte[])tlv.getValue(), (String)this.charsetName));
            }
        }
        return message;
    }

    private void fillSubmitSmResponse(SubmitSmResp response, Message responseMessage) {
        Map props = responseMessage.getConnectionProperties();
        response.setResultMessage(responseMessage.getText());
        response.setMessageId(props.getOrDefault("messageId", ""));
        response.setCommandStatus(Integer.parseInt(props.getOrDefault("commandStatus", "0")));
    }
}

