/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.smpp;

import com.cloudhopper.smpp.SmppServerConfiguration;
import com.cloudhopper.smpp.SmppServerHandler;
import com.cloudhopper.smpp.SmppServerSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultSmppServer;
import com.cloudhopper.smpp.pdu.BaseBind;
import com.cloudhopper.smpp.pdu.BaseBindResp;
import com.cloudhopper.smpp.type.LoggingOptions;
import com.cloudhopper.smpp.type.SmppChannelException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.trigger.smpp.ItfSmppSessionHandler;
import org.qubership.automation.itf.trigger.smpp.inbound.SmppTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppServerSimulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmppServerSimulator.class);
    private DefaultSmppServer smppServer;
    SmppTrigger smppTrigger;
    SmppServerHandler serverHandler;
    ConnectionProperties connectionProperties;

    public SmppServerSimulator(ConnectionProperties triggerConnectionProperties, SmppTrigger trigger) throws SmppChannelException {
        this.smppTrigger = trigger;
        this.connectionProperties = triggerConnectionProperties;
        SmppServerConfiguration configuration = new SmppServerConfiguration();
        configuration.setPort(Integer.parseInt((String)this.connectionProperties.getOrDefault((Object)"port", (Object)"36888")));
        configuration.setDefaultRequestExpiryTimeout((long)Integer.parseInt((String)this.connectionProperties.getOrDefault((Object)"expiryTimeout", (Object)"60000")));
        configuration.setDefaultWindowSize(Integer.parseInt((String)this.connectionProperties.getOrDefault((Object)"windowSize", (Object)"5")));
        configuration.setDefaultSessionCountersEnabled(Boolean.parseBoolean((String)this.connectionProperties.getOrDefault((Object)"defaultSessionCountersEnabled", (Object)"false")));
        configuration.setJmxEnabled(Boolean.parseBoolean((String)this.connectionProperties.getOrDefault((Object)"jmxEnabled", (Object)"false")));
        configuration.setSystemId((String)this.connectionProperties.getOrDefault((Object)"systemId", (Object)"uim"));
        this.initServerHandler();
        ScheduledExecutorService monitorService = Executors.newScheduledThreadPool(1, new MyThreadFactory());
        this.smppServer = new DefaultSmppServer(configuration, this.serverHandler, Executors.newCachedThreadPool(), monitorService);
        this.smppServer.start();
        LOGGER.info("Server started at {}:{}", (Object)configuration.getHost(), (Object)configuration.getPort());
    }

    public void stop() {
        if (this.smppServer != null) {
            if (this.smppServer.isStarted()) {
                this.smppServer.stop();
            }
            this.smppServer.destroy();
        }
    }

    private void initServerHandler() {
        this.serverHandler = new SmppServerHandler(){

            public void sessionBindRequested(Long along, SmppSessionConfiguration smppSessionConfiguration, BaseBind baseBind) {
                LoggingOptions loggingOptions = new LoggingOptions();
                loggingOptions.setLogPdu(false);
                loggingOptions.setLogBytes(false);
                smppSessionConfiguration.setLoggingOptions(loggingOptions);
                LOGGER.info("Bind request with system.id = {} successfully received. Sending response.", (Object)baseBind.getSystemId());
                smppSessionConfiguration.setName("Smpp.Client." + smppSessionConfiguration.getSystemId());
            }

            public void sessionCreated(Long along, SmppServerSession smppServerSession, BaseBindResp baseBindResp) {
                LoggingOptions loggingOptions = new LoggingOptions();
                loggingOptions.setLogPdu(false);
                loggingOptions.setLogBytes(false);
                smppServerSession.getConfiguration().setLoggingOptions(loggingOptions);
                LOGGER.info("Session with system.id = {} successfully created.", (Object)smppServerSession.getConfiguration().getSystemId());
                smppServerSession.serverReady((SmppSessionHandler)new ItfSmppSessionHandler(smppServerSession.getConfiguration(), SmppServerSimulator.this.smppTrigger, SmppServerSimulator.this.connectionProperties));
            }

            public void sessionDestroyed(Long along, SmppServerSession smppServerSession) {
                smppServerSession.destroy();
                LOGGER.info("Session with system.id = {} successfully destroyed.", (Object)smppServerSession.getConfiguration().getSystemId());
            }
        };
    }

    private static class MyThreadFactory
    implements ThreadFactory {
        AtomicInteger sequence = new AtomicInteger(0);

        private MyThreadFactory() {
        }

        @Override
        public Thread newThread(@NotNull Runnable runnable) {
            Thread t = new Thread(runnable);
            t.setName("SmppServerSessionWindowMonitorPool-" + this.sequence.getAndIncrement());
            return t;
        }
    }
}

