/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.smpp.inbound;

import java.util.UUID;
import org.qubership.automation.itf.communication.TriggerExecutionMessageSender;
import org.qubership.automation.itf.core.model.communication.message.CommonTriggerExecutionMessage;
import org.qubership.automation.itf.core.model.communication.message.TriggerExecutionMessage;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.core.util.transport.service.LockProvider;
import org.qubership.automation.itf.monitoring.metrics.MetricsAggregateService;
import org.qubership.automation.itf.trigger.camel.Helper;
import org.qubership.automation.itf.trigger.camel.inbound.AbstractCamelTrigger;
import org.qubership.automation.itf.trigger.camel.route.ItfAbstractRouteBuilder;
import org.qubership.automation.itf.trigger.smpp.SmppServerSimulator;

public class SmppTrigger
extends AbstractCamelTrigger {
    private SmppServerSimulator smppServerSimulator;
    private static final String SMPP_INBOUND_TRANSPORT_CLASS_NAME = "org.qubership.automation.itf.transport.smpp.inbound.SmppInboundTransport";

    public SmppTrigger(StorableDescriptor triggerConfigurationDescriptor, ConnectionProperties connectionProperties) {
        super(triggerConfigurationDescriptor, connectionProperties);
    }

    protected void activateSpecificTrigger() throws Exception {
        this.smppServerSimulator = new SmppServerSimulator(this.getConnectionProperties(), this);
    }

    protected void deactivateSpecificTrigger() {
        if (this.smppServerSimulator != null) {
            this.smppServerSimulator.stop();
        }
    }

    protected void applyTriggerProperties(ConnectionProperties connectionProperties) {
        this.setConnectionProperties(connectionProperties);
    }

    public Message produceMessageToItf(Message requestMessage) throws InterruptedException {
        String sessionId = UUID.randomUUID().toString();
        MetricsAggregateService.putCommonMetrics((UUID)this.getTriggerConfigurationDescriptor().getProjectUuid(), (String)sessionId);
        String brokerMessageSelectorValue = Helper.getBrokerMessageSelectorValue();
        ItfAbstractRouteBuilder.logExtendedInfo((UUID)this.getTriggerConfigurationDescriptor().getProjectUuid(), (String)sessionId, (String)brokerMessageSelectorValue, (String)SMPP_INBOUND_TRANSPORT_CLASS_NAME, (long)(requestMessage.getText() == null ? 0L : (long)requestMessage.getText().length()));
        TriggerExecutionMessageSender.send((TriggerExecutionMessage)new CommonTriggerExecutionMessage(SMPP_INBOUND_TRANSPORT_CLASS_NAME, requestMessage, this.getTriggerConfigurationDescriptor(), sessionId, brokerMessageSelectorValue), (Object)this.getTriggerConfigurationDescriptor().getProjectUuid());
        LOGGER.debug("Project: {}, SessionId: {}, Broker Message Selector Value: {}, transport: '{}' - message to executor is sent.", new Object[]{this.getTriggerConfigurationDescriptor().getProjectUuid(), sessionId, brokerMessageSelectorValue, SMPP_INBOUND_TRANSPORT_CLASS_NAME});
        Message message = LockProvider.INSTANCE.waitResponse(sessionId, Helper.getLockProviderCheckInterval(), Helper.getLockProviderCheckMaxInterval(), Helper.getLockProviderCheckMultiplier());
        LOGGER.info("Project: {}. SessionId: {}. Response is sent", (Object)this.getTriggerConfigurationDescriptor().getProjectUuid(), (Object)sessionId);
        return message == null ? new Message("Null response message") : message;
    }
}

