/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.snmp.inbound;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.component.snmp.SnmpActionType;
import org.apache.camel.component.snmp.SnmpComponent;
import org.apache.camel.component.snmp.SnmpEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.qubership.automation.itf.core.model.communication.TransportType;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.core.util.exception.TriggerException;
import org.qubership.automation.itf.monitoring.metrics.MetricsAggregateService;
import org.qubership.automation.itf.trigger.camel.inbound.AbstractCamelTrigger;
import org.qubership.automation.itf.trigger.camel.route.ItfAbstractRouteBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpTrigger
extends AbstractCamelTrigger {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnmpTrigger.class);
    private static final String SNMP_INBOUND_TRANSPORT_CLASS_NAME = "org.qubership.automation.itf.transport.snmp.inbound.SNMPInboundTransport";
    private CamelContext camelContext;

    public SnmpTrigger(StorableDescriptor triggerConfigurationDescriptor, ConnectionProperties connectionProperties) {
        super(triggerConfigurationDescriptor, connectionProperties);
    }

    protected void activateSpecificTrigger() throws Exception {
        this.camelContext = new DefaultCamelContext();
        this.camelContext.addRoutes((RoutesBuilder)new ItfAbstractRouteBuilder(){

            public void configure() throws Exception {
                SnmpEndpoint endpoint = new SnmpEndpoint(SnmpTrigger.this.resolveEndpoint(), (SnmpComponent)SnmpTrigger.this.camelContext.getComponent("snmp"));
                endpoint.setAddress(SnmpTrigger.this.resolveEndpoint());
                endpoint.setType(SnmpActionType.TRAP);
                this.from((Endpoint)endpoint).process(exchange -> {
                    String sessionId = UUID.randomUUID().toString();
                    MetricsAggregateService.putCommonMetrics((UUID)SnmpTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid(), (String)sessionId);
                    LOGGER.info("Project: {}. SessionId: {}. Request is received by endpoint: {}", new Object[]{SnmpTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid(), sessionId, endpoint});
                    this.startSession(exchange, SnmpTrigger.SNMP_INBOUND_TRANSPORT_CLASS_NAME, SnmpTrigger.this.getConnectionProperties(), SnmpTrigger.this.getTriggerConfigurationDescriptor(), sessionId);
                    MetricsAggregateService.incrementIncomingRequestToProject((UUID)SnmpTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid(), (TransportType)TransportType.SNMP_INBOUND, (boolean)true);
                });
            }

            public Map<String, Object> getAdditionalProperties(Exchange exchange) {
                return null;
            }

            public List<String> getExcludeHeadersList() {
                return null;
            }
        });
        this.camelContext.start();
        LOGGER.info(this.camelContext.toString() + " is activated successfully");
    }

    protected void deactivateSpecificTrigger() throws Exception {
        if (this.camelContext != null) {
            this.camelContext.stop();
            LOGGER.info(this.camelContext.toString() + " is deactivated successfully");
        }
    }

    protected void applyTriggerProperties(ConnectionProperties connectionProperties) throws TriggerException {
        this.setConnectionProperties(connectionProperties);
    }

    private String resolveEndpoint() {
        return "snmp:" + this.getConnectionProperties().get((Object)"Host") + ":" + this.getConnectionProperties().get((Object)"Port") + "?protocol=udp&type=TRAP&snmpVersion=" + this.getConnectionProperties().get((Object)"SNMP version");
    }
}

