/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.trigger.soap.http.inbound;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StringSource;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.model.RouteDefinition;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.MustUnderstandInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.PolicyException;
import org.qubership.automation.itf.JvmSettings;
import org.qubership.automation.itf.communication.TriggerExecutionMessageSender;
import org.qubership.automation.itf.core.model.communication.TransportType;
import org.qubership.automation.itf.core.model.communication.message.CommonTriggerExecutionMessage;
import org.qubership.automation.itf.core.model.communication.message.TriggerExecutionMessage;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.stub.fast.FastResponseConfigsHolder;
import org.qubership.automation.itf.core.stub.fast.StubEndpointConfig;
import org.qubership.automation.itf.core.util.descriptor.StorableDescriptor;
import org.qubership.automation.itf.core.util.helper.ProjectSettingsHelper;
import org.qubership.automation.itf.monitoring.metrics.MetricsAggregateService;
import org.qubership.automation.itf.trigger.camel.route.ItfAbstractRouteBuilder;
import org.qubership.automation.itf.trigger.http.Helper;
import org.qubership.automation.itf.trigger.http.inbound.HttpInboundTrigger;
import org.qubership.automation.itf.trigger.soap.http.SoapOverHttpHelper;
import org.qubership.automation.itf.xsd.XsdValidationResult;
import org.qubership.automation.itf.xsd.XsdValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class SoapOverHttpTrigger
extends HttpInboundTrigger {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoapOverHttpTrigger.class);
    private static final String SOAP_OVER_HTTP_INBOUND_TRANSPORT_CLASS_NAME = "org.qubership.automation.itf.transport.soap.http.inbound.SOAPOverHTTPInboundTransport";

    public SoapOverHttpTrigger(StorableDescriptor triggerConfigurationDescriptor, ConnectionProperties connectionProperties) {
        super(triggerConfigurationDescriptor, connectionProperties);
    }

    protected RoutesBuilder createRoute() {
        SoapOverHttpHelper.prepareBusContext((Object)this);
        return new ItfAbstractRouteBuilder(){

            public void configure() throws Exception {
                UUID projectUuid = SoapOverHttpTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid();
                BigInteger projectId = SoapOverHttpTrigger.this.getTriggerConfigurationDescriptor().getProjectId();
                String currentEndPoint = Objects.toString(SoapOverHttpTrigger.this.getConnectionProperties().get((Object)"endpoint"));
                String wsdlPath = SoapOverHttpTrigger.this.getWsdlPath();
                CxfEndpoint cxfEndpoint = SoapOverHttpTrigger.this.createCxfEndpoint(wsdlPath);
                RouteDefinition routeFrom = this.from((Endpoint)cxfEndpoint);
                routeFrom.onException(Throwable.class).continued(false);
                ((RouteDefinition)routeFrom.process(exchange -> {
                    block8: {
                        OffsetDateTime started;
                        String sessionId;
                        block6: {
                            boolean resultState;
                            block7: {
                                StubEndpointConfig cfg;
                                sessionId = UUID.randomUUID().toString();
                                MetricsAggregateService.putCommonMetrics((UUID)projectUuid, (String)sessionId);
                                LOGGER.info("Project: {}. SessionId: {}. Request is received by endpoint: {}", new Object[]{projectUuid, sessionId, currentEndPoint});
                                started = OffsetDateTime.now();
                                SoapOverHttpTrigger.this.clearOutFilter((CxfEndpoint)exchange.getFromEndpoint());
                                SoapOverHttpTrigger.this.addClientAddressInHeader(exchange);
                                String stringBody = SoapOverHttpTrigger.this.getStringBody(exchange.getIn());
                                SoapOverHttpTrigger.this.validate(exchange.getIn(), stringBody, "requestXSDPath");
                                exchange.getIn().setBody((Object)stringBody);
                                org.qubership.automation.itf.core.model.jpa.message.Message message = this.prepareIncomingMessage(exchange, SoapOverHttpTrigger.SOAP_OVER_HTTP_INBOUND_TRANSPORT_CLASS_NAME, SoapOverHttpTrigger.this.getConnectionProperties(), SoapOverHttpTrigger.this.getTriggerConfigurationDescriptor(), sessionId);
                                boolean enableFastStubs = Boolean.parseBoolean(ProjectSettingsHelper.getProjectSettingsService().get((Object)projectId, "enable.fastStubs", "true"));
                                boolean prepared = false;
                                if (enableFastStubs && (cfg = FastResponseConfigsHolder.INSTANCE.getConfig(SoapOverHttpTrigger.this.getTriggerConfigurationDescriptor().getProjectUuid().toString(), StubEndpointConfig.TransportTypes.SOAP.name(), currentEndPoint)) != null) {
                                    prepared = SoapOverHttpTrigger.this.prepareFastResponse(exchange, message, cfg, sessionId, SoapOverHttpTrigger.this.getTriggerConfigurationDescriptor());
                                }
                                if (prepared) break block6;
                                this.startSession(exchange, SoapOverHttpTrigger.SOAP_OVER_HTTP_INBOUND_TRANSPORT_CLASS_NAME, SoapOverHttpTrigger.this.getConnectionProperties(), SoapOverHttpTrigger.this.getTriggerConfigurationDescriptor(), sessionId, message);
                                org.qubership.automation.itf.core.model.jpa.message.Message responseMessage = SoapOverHttpTrigger.this.setUpOut(exchange, sessionId);
                                boolean bl = resultState = responseMessage != null && responseMessage.getFailedMessage() == null;
                                if (exchange.getOut().isFault()) break block7;
                                try {
                                    SoapOverHttpTrigger.this.validate(exchange.getOut(), "responseXSDPath");
                                }
                                catch (IllegalArgumentException | RuntimeCamelException ex) {
                                    try {
                                        if (responseMessage != null) {
                                            responseMessage.setFailedMessage(ex.getMessage());
                                            responseMessage.getHeaders().put("CamelHttpResponseCode", "500");
                                        }
                                        throw ex;
                                    }
                                    catch (Throwable throwable) {
                                        LOGGER.info("Project: {}. SessionId: {}. Response is sent from endpoint: {}", new Object[]{projectUuid, sessionId, currentEndPoint});
                                        SoapOverHttpTrigger.this.collectMetrics(projectUuid, TransportType.SOAP_OVER_HTTP_INBOUND, currentEndPoint, resultState, started);
                                        throw throwable;
                                    }
                                }
                                LOGGER.info("Project: {}. SessionId: {}. Response is sent from endpoint: {}", new Object[]{projectUuid, sessionId, currentEndPoint});
                                SoapOverHttpTrigger.this.collectMetrics(projectUuid, TransportType.SOAP_OVER_HTTP_INBOUND, currentEndPoint, resultState, started);
                                break block8;
                            }
                            LOGGER.info("Project: {}. SessionId: {}. Response (fault) is sent from endpoint: {}", new Object[]{projectUuid, sessionId, currentEndPoint});
                            SoapOverHttpTrigger.this.collectMetrics(projectUuid, TransportType.SOAP_OVER_HTTP_INBOUND, currentEndPoint, resultState, started);
                            break block8;
                        }
                        LOGGER.info("Project: {}. SessionId: {}. Fast-Stub response is sent from endpoint: {}", new Object[]{projectUuid, sessionId, currentEndPoint});
                        SoapOverHttpTrigger.this.collectMetrics(projectUuid, TransportType.SOAP_OVER_HTTP_INBOUND, currentEndPoint, true, started);
                    }
                })).routeId(SoapOverHttpTrigger.this.getId());
                cxfEndpoint.start();
            }

            public Map<String, Object> getAdditionalProperties(Exchange exchange) {
                return SoapOverHttpTrigger.this.getAdditionalProperties(exchange);
            }

            public List<String> getExcludeHeadersList() {
                return Arrays.asList("CamelCxfMessage", "org.apache.cxf.headers.Header.list");
            }
        };
    }

    protected Message composeBody(Message camelMessage, org.qubership.automation.itf.core.model.jpa.message.Message itfMessage) {
        return Helper.composeBodyForSoapInbound((Message)camelMessage, (org.qubership.automation.itf.core.model.jpa.message.Message)itfMessage, (boolean)((CxfEndpoint)camelMessage.getExchange().getFromEndpoint()).getDataFormat().equals((Object)DataFormat.RAW));
    }

    public void validateRequest(Exchange exchange) {
        this.validate(exchange.getIn(), "requestXSDPath");
    }

    public void validateResponse(Exchange exchange) {
        this.validate(exchange.getOut(), "responseXSDPath");
    }

    private String getStringBody(Message camelMessage) {
        Object messageBody = camelMessage.getBody();
        if (messageBody instanceof CxfPayload) {
            return this.serializeCxfPayloadBody((CxfPayload)messageBody);
        }
        if (messageBody instanceof ByteArrayInputStream) {
            return this.readBais((ByteArrayInputStream)messageBody);
        }
        return (String)messageBody;
    }

    private void clearOutFilter(CxfEndpoint endpoint) {
        DefaultHeaderFilterStrategy st = (DefaultHeaderFilterStrategy)endpoint.getHeaderFilterStrategy();
        st.setOutFilter(null);
    }

    private void addClientAddressInHeader(Exchange exchange) {
        try {
            ServletRequest servletRequest = (ServletRequest)((SoapMessage)exchange.getIn().getHeader("CamelCxfMessage")).get((Object)"HTTP.REQUEST");
            Helper.addClientCoordsToHeaders((Map)exchange.getIn().getHeaders(), (ServletRequest)servletRequest);
            Helper.fixCoNamedHeaders((Map)exchange.getIn().getHeaders(), (ServletRequest)servletRequest);
        }
        catch (Exception ex) {
            LOGGER.warn("addClientAddressInHeader: exceptions while headers processing", (Throwable)ex);
        }
    }

    private void validate(Message camelMessage, String xsdPathParameter) {
        String xsdPath = (String)this.getConnectionProperties().obtain(xsdPathParameter);
        if (StringUtils.isBlank((CharSequence)xsdPath)) {
            LOGGER.debug("Message validation is skipped due to empty parameter {}", (Object)xsdPathParameter);
            return;
        }
        String stringBody = this.getStringBody(camelMessage);
        if (StringUtils.isBlank((CharSequence)stringBody)) {
            LOGGER.warn("Message validation is skipped due to message is empty");
            return;
        }
        this.performValidation(stringBody, camelMessage.getBody(), xsdPath);
    }

    private void validate(Message camelMessage, String stringBody, String xsdPathParameter) {
        if (StringUtils.isBlank((CharSequence)stringBody)) {
            LOGGER.warn("Message validation is skipped due to message is empty");
            return;
        }
        String xsdPath = (String)this.getConnectionProperties().obtain(xsdPathParameter);
        if (StringUtils.isBlank((CharSequence)xsdPath)) {
            LOGGER.debug("Message validation is skipped due to empty parameter {}", (Object)xsdPathParameter);
            return;
        }
        this.performValidation(stringBody, camelMessage.getBody(), xsdPath);
    }

    private XsdValidationResult performValidation(String stringBody, Object messageBody, String xsdPath) {
        XsdValidationResult validationResult = messageBody instanceof CxfPayload ? new XsdValidator().validate(stringBody, this.collectNamespaces((CxfPayload)messageBody, xsdPath)) : new XsdValidator().validate(stringBody, xsdPath);
        if (validationResult.isFailed()) {
            throw new IllegalArgumentException(validationResult.getException() instanceof SAXException ? "Invalid message. " : "Unexpected exception. " + validationResult);
        }
        return validationResult;
    }

    private String serializeCxfPayloadBody(CxfPayload cxfPayloadBody) {
        List srcList = cxfPayloadBody.getBodySources();
        if (srcList == null || srcList.isEmpty()) {
            return "";
        }
        Source src = (Source)srcList.get(0);
        if (src instanceof StringSource) {
            return ((StringSource)src).getText();
        }
        List elementList = cxfPayloadBody.getBody();
        Document document = ((Element)elementList.get(0)).getOwnerDocument();
        DOMImplementationLS domImplLs = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer serializer = domImplLs.createLSSerializer();
        return serializer.writeToString((Node)elementList.get(0));
    }

    private String readBais(ByteArrayInputStream messageBody) {
        int n = messageBody.available();
        byte[] bytes = new byte[n];
        messageBody.read(bytes, 0, n);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private StreamSource[] collectNamespaces(CxfPayload cxfPayloadBody, String xsdPath) {
        ArrayList<StreamSource> result = new ArrayList<StreamSource>();
        result.add(new StreamSource(xsdPath));
        List list = cxfPayloadBody.getBody();
        if (list != null && !list.isEmpty()) {
            result.add(new StreamSource(((Element)list.get(0)).getNamespaceURI()));
        }
        return result.toArray(new StreamSource[0]);
    }

    private String getWsdlPath() {
        String pathToWsdlFile = (String)this.getConnectionProperties().obtain("wsdlPath");
        if (StringUtils.isBlank((CharSequence)pathToWsdlFile)) {
            throw new IllegalArgumentException("Path/URL to WSDL file is not specified");
        }
        try {
            return SoapOverHttpHelper.getAndCheckPath(pathToWsdlFile, true, "WSDL file");
        }
        catch (FileNotFoundException | MalformedURLException e) {
            throw new IllegalArgumentException("Path/URL to WSDL file is invalid (" + pathToWsdlFile + ")", e);
        }
    }

    protected void setExtraProperties(CxfEndpoint cxfEndpoint, Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        block14: for (Map.Entry<String, Object> item : properties.entrySet()) {
            String key;
            if (StringUtils.isBlank((CharSequence)item.getKey()) || item.getValue() == null) continue;
            switch (key = item.getKey().trim()) {
                case "dataFormat": {
                    try {
                        DataFormat dtf = DataFormat.valueOf((String)((String)item.getValue()));
                        cxfEndpoint.setDataFormat(dtf);
                    }
                    catch (Exception ignore) {
                        LOGGER.debug("Incorrect dataFormat property: {}", item.getValue());
                    }
                    continue block14;
                }
                case "namespace": {
                    continue block14;
                }
                case "endpoint": {
                    if (properties.containsKey("namespace")) {
                        cxfEndpoint.setPortName(new QName((String)properties.get("namespace"), (String)item.getValue()));
                        continue block14;
                    }
                    cxfEndpoint.setPortName((String)item.getValue());
                    continue block14;
                }
                case "servicename": {
                    if (!properties.containsKey("namespace")) continue block14;
                    cxfEndpoint.setServiceName(new QName((String)properties.get("namespace"), (String)item.getValue()));
                    continue block14;
                }
            }
            props.put(key, item.getValue());
        }
        if (!props.isEmpty()) {
            cxfEndpoint.setProperties(props);
        }
    }

    private CxfEndpoint createCxfEndpoint(String wsdlPath) {
        CxfEndpoint cxfEndpoint = new CxfEndpoint();
        cxfEndpoint.setCamelContext(CAMEL_CONTEXT);
        cxfEndpoint.setWsdlURL(wsdlPath);
        cxfEndpoint.setPublishedEndpointUrl(this.getPrefixWithProjectUuid() + this.getConnectionProperties().obtain("endpoint"));
        cxfEndpoint.setAddress(this.getPrefixWithProjectUuid() + this.getConnectionProperties().obtain("endpoint"));
        cxfEndpoint.setDataFormat(DataFormat.PAYLOAD);
        this.setExtraProperties(cxfEndpoint, (Map)this.getConnectionProperties().obtain("endpointProperties"));
        cxfEndpoint.setBus(BusFactory.getThreadDefaultBus());
        final PlainSoapMessage plainSoapMessage = new PlainSoapMessage();
        cxfEndpoint.getOutFaultInterceptors().add(new AbstractPhaseInterceptor<SoapMessage>("post-protocol"){

            public void handleMessage(SoapMessage message) throws Fault {
                SoapOverHttpTrigger.this.handleMessage(message, plainSoapMessage);
            }
        });
        cxfEndpoint.getInInterceptors().add(new ItfMustUnderstandInterceptor());
        cxfEndpoint.getInInterceptors().add(new ItfSoapMessageAbstractPhaseInterceptor(plainSoapMessage));
        cxfEndpoint.getInInterceptors().add(new AbstractPhaseInterceptor<SoapMessage>("pre-logical"){

            public void handleMessage(SoapMessage message) throws Fault {
                SoapOverHttpTrigger.this.revertToPlainMessage(message, plainSoapMessage);
            }
        });
        cxfEndpoint.getOutInterceptors().add(new AbstractPhaseInterceptor("setup"){

            public void handleMessage(org.apache.cxf.message.Message message) throws Fault {
                Interceptor interceptorToRemove = null;
                SoapOverHttpTrigger.this.getResponseCode(message);
                ListIterator iterator = message.getInterceptorChain().getIterator();
                while (iterator.hasNext()) {
                    Interceptor currentInterceptor = (Interceptor)iterator.next();
                    if (!(currentInterceptor instanceof SoapOutInterceptor)) continue;
                    interceptorToRemove = currentInterceptor;
                    break;
                }
                if (interceptorToRemove != null) {
                    message.getInterceptorChain().remove(interceptorToRemove);
                }
            }
        });
        return cxfEndpoint;
    }

    private void getResponseCode(org.apache.cxf.message.Message message) {
        Object obj;
        String key = org.apache.cxf.message.Message.class.getName() + ".RESPONSE_CODE";
        if (message.containsKey((Object)key) && (obj = message.get((Object)key)) instanceof String) {
            try {
                int respCode = Integer.parseInt((String)obj);
                message.put((Object)key, (Object)respCode);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void handleMessage(SoapMessage soapMessage, PlainSoapMessage body) throws Fault {
        Fault fault = (Fault)soapMessage.getContent(Exception.class);
        if (fault == null) {
            return;
        }
        if (fault.getCause() instanceof PolicyException) {
            this.handlePolicyError(soapMessage, fault);
            return;
        }
        Exchange exchange = (Exchange)soapMessage.getExchange().get((Object)"org.apache.camel.Exchange");
        if (!Objects.nonNull(exchange) || !exchange.hasOut()) {
            org.qubership.automation.itf.core.model.jpa.message.Message message = new org.qubership.automation.itf.core.model.jpa.message.Message();
            message.setText(body.getText());
            message.setFailedMessage(fault.getMessage() + "\nStacktrace: " + ExceptionUtils.getStackTrace((Throwable)fault) + "\nInbound message was: " + body.getText());
            message.getConnectionProperties().putAll(this.getConnectionProperties());
            message.getHeaders().putAll(body.getHeaders());
            if (fault.getStatusCode() > 0) {
                message.getConnectionProperties().put("responseCode", fault.getStatusCode());
            }
            String sessionId = UUID.randomUUID().toString();
            try {
                TriggerExecutionMessageSender.send((TriggerExecutionMessage)new CommonTriggerExecutionMessage("", message, this.getTriggerConfigurationDescriptor(), sessionId, org.qubership.automation.itf.trigger.camel.Helper.getBrokerMessageSelectorValue()), (Object)this.getTriggerConfigurationDescriptor().getProjectUuid());
            }
            catch (Exception e) {
                LOGGER.error("Failed to send message to broker", (Throwable)e);
            }
        }
    }

    private void handlePolicyError(SoapMessage soapMessage, Fault fault) throws Fault {
        this.prepareAndSendErrorResponse(soapMessage, fault);
        LOGGER.error("An error occurred while processing the SOAP message - a PolicyException was encountered. Please check the policy description and resource availability (URL) in the WSDL file. ITF did not process this SOAP message. Endpoint: " + this.getConnectionProperties().get((Object)"endpoint") + " , WSDL path: " + this.getWsdlPath(), fault.getCause());
    }

    private void prepareAndSendErrorResponse(SoapMessage soapMessage, Fault fault) {
        HttpServletResponse resp = (HttpServletResponse)soapMessage.getExchange().getInMessage().get((Object)"HTTP.RESPONSE");
        resp.setStatus(fault.getStatusCode());
        try {
            resp.getOutputStream().write(fault.getMessage().getBytes(JvmSettings.CHARSET));
            resp.getOutputStream().flush();
        }
        catch (Exception e) {
            LOGGER.error("Error while sending SOAP Error response ", (Throwable)e);
        }
        soapMessage.getInterceptorChain().setFaultObserver(null);
        soapMessage.getInterceptorChain().abort();
    }

    private void revertToPlainMessage(SoapMessage soapMessage, PlainSoapMessage body) {
        List listObj = (List)soapMessage.getContent(List.class);
        if (listObj != null) {
            if (!listObj.isEmpty()) {
                listObj.clear();
            }
            listObj.add(new StringSource(body.getText()));
        }
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="Checked; it can't be static")
    private class PlainSoapMessage {
        private String text;
        private Map<String, Object> headers = new HashMap<String, Object>();

        PlainSoapMessage() {
        }

        String getText() {
            return this.text;
        }

        void setText(String text) {
            this.text = text;
        }

        Map<String, Object> getHeaders() {
            return this.headers;
        }

        void setHeaders(Map<String, Object> headers) {
            this.headers = headers;
        }
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="Checked; it can't be static")
    private class ItfSoapMessageAbstractPhaseInterceptor
    extends AbstractPhaseInterceptor<SoapMessage> {
        private final PlainSoapMessage plainSoapMessage;

        public ItfSoapMessageAbstractPhaseInterceptor(PlainSoapMessage plainSoapMessage) {
            super("receive");
            this.plainSoapMessage = plainSoapMessage;
        }

        public void handleMessage(SoapMessage message) throws Fault {
            try (InputStream content = (InputStream)message.getContent(InputStream.class);){
                try {
                    String sourceMessage = IOUtils.toString((InputStream)content);
                    this.plainSoapMessage.setText(sourceMessage);
                    message.setContent(InputStream.class, (Object)new ByteArrayInputStream(sourceMessage.getBytes(JvmSettings.CHARSET)));
                }
                catch (IOException e2) {
                    LOGGER.error("Unable to get message from soap request", (Throwable)e2);
                }
            }
            catch (IOException e3) {
                LOGGER.error("Unable to close input stream", (Throwable)e3);
            }
            try {
                Map headers = CastUtils.cast((Map)((Map)message.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS)));
                if (headers != null && !headers.isEmpty()) {
                    this.plainSoapMessage.setHeaders(headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).isEmpty() ? "" : (((List)e.getValue()).size() == 1 ? ((List)e.getValue()).get(0) : e.getValue()))));
                }
            }
            catch (Exception ex) {
                LOGGER.error("Unable to get message headers from soap request", (Throwable)ex);
            }
        }
    }

    private static class ItfMustUnderstandInterceptor
    extends MustUnderstandInterceptor {
        public ItfMustUnderstandInterceptor() {
            super("pre-protocol");
        }

        public void handleMessage(SoapMessage soapMessage) throws Fault {
            soapMessage.getHeaders().forEach(header -> ((SoapHeader)header).setMustUnderstand(false));
        }
    }
}

