/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.xsd;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.qubership.automation.itf.xsd.XsdValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XsdValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XsdValidator.class);
    private static final String SOAP_ENV = "http://schemas.xmlsoap.org/soap/envelope/";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XsdValidationResult validate(String message, StreamSource[] schemaDocuments) {
        XsdValidationResult result = new XsdValidationResult(message);
        try (StringReader xml = new StringReader(message);){
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(schemaDocuments);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xml));
            XsdValidationResult xsdValidationResult = result.setSchemaDocuments(schemaDocuments).setFailed(false);
            return xsdValidationResult;
        }
        catch (IOException | SAXException e) {
            LOGGER.error("XSD Validation is failed. XML message: \n" + message, (Throwable)e);
            return result.setException(e).setSchemaDocuments(schemaDocuments).setFailed(true);
        }
    }

    public XsdValidationResult validate(String message, String xsdPath) {
        return this.validate(message, new StreamSource[]{new File(xsdPath).exists() ? new StreamSource(xsdPath) : null, new StreamSource(SOAP_ENV)});
    }
}

