/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.xsd;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.StringReader;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.qubership.automation.itf.xsd.XSDValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XSDValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XSDValidator.class);
    private static final String SOAP_ENV = "http://schemas.xmlsoap.org/soap/envelope/";
    private static SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static LoadingCache<String, Schema> schemaCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Schema>(){

        public Schema load(@Nonnull String xsdPath) throws SAXException {
            return schemaFactory.newSchema(new StreamSource[]{new File(xsdPath).exists() ? new StreamSource(xsdPath) : null, new StreamSource(XSDValidator.SOAP_ENV)});
        }
    });

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XSDValidationResult validate(String message, String xsdPath) {
        XSDValidationResult result = new XSDValidationResult(message);
        try (StringReader xml = new StringReader(message);){
            Schema schema = (Schema)schemaCache.get((Object)xsdPath);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xml));
            XSDValidationResult xSDValidationResult = result.setSchemaDocuments(new String[]{xsdPath, SOAP_ENV}).setFailed(false);
            return xSDValidationResult;
        }
        catch (Exception e) {
            LOGGER.error("XSD Validation is failed.\n XML message: \n" + message, (Throwable)e);
            return result.setException(e).setSchemaDocuments(new String[]{xsdPath, SOAP_ENV}).setFailed(true);
        }
    }
}

