/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.cloud.nifi.config;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.consul.config.ConsulPropertySource;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component
@RefreshScope
public class PropertiesManager {
    private static final Logger log = LoggerFactory.getLogger(PropertiesManager.class);
    @Value(value="classpath:logback-template.xml")
    private Resource sourceXmlFile;
    @Value(value="classpath:nifi_default.properties")
    private Resource defaultPropertiesFile;
    @Value(value="classpath:custom.properties")
    private Resource defaultCustomPropertiesFile;
    @Value(value="classpath:nifi_internal.properties")
    private Resource internalPropertiesFile;
    @Value(value="classpath:nifi_internal_comments.properties")
    private Resource internalPropertiesCommentsFile;
    private Map<String, String> consulPropertiesMap = new HashMap<String, String>();
    private Properties props;
    @Value(value="${config.file.path}")
    private String path;
    @Autowired
    private ConfigurableEnvironment env;
    @Autowired
    private Environment appEnv;
    private static final Set<String> SKIPPED_CUSTOM_PROPERTIES = new HashSet<String>();

    public void generateNifiProperties() throws IOException, ParserConfigurationException, TransformerException, SAXException {
        this.readConsulProperties();
        this.buildPropertiesFile();
        this.buildCustomPropertiesFile();
        this.buildLogbackXMLFile();
        log.info("nifi properties files generated");
    }

    private void buildLogbackXMLFile() throws ParserConfigurationException, IOException, SAXException, TransformerException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = null;
        try (BufferedInputStream is = new BufferedInputStream(this.sourceXmlFile.getInputStream());){
            doc = dBuilder.parse(is);
        }
        doc.getDocumentElement().normalize();
        if (log.isDebugEnabled()) {
            log.debug("Root element: {}", (Object)doc.getDocumentElement().getNodeName());
        }
        NodeList nodeList = doc.getElementsByTagName("logger");
        for (String consulKey : this.consulPropertiesMap.keySet()) {
            boolean loggerElementFound = false;
            if (!consulKey.toLowerCase().startsWith("logger.")) continue;
            String xmlKey = consulKey.substring(7);
            if (log.isDebugEnabled()) {
                log.debug("current xmlKey: {}", (Object)xmlKey);
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node loggerKey;
                Node prop = nodeList.item(i);
                NamedNodeMap attr = prop.getAttributes();
                if (attr == null || !xmlKey.equalsIgnoreCase((loggerKey = attr.getNamedItem("name")).getNodeValue())) continue;
                attr.getNamedItem("level").setTextContent(this.consulPropertiesMap.get(consulKey));
                loggerElementFound = true;
                break;
            }
            if (loggerElementFound) continue;
            Element newLogger = doc.createElement("logger");
            newLogger.setAttribute("name", xmlKey);
            newLogger.setAttribute("level", this.consulPropertiesMap.get(consulKey));
            Node firstLogNode = doc.getElementsByTagName("logger").item(0);
            doc.getDocumentElement().insertBefore(newLogger, firstLogNode);
        }
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.path + "logback.xml"));){
            this.writeXml(doc, output);
        }
        log.info("logback.xml file created at path: {}", (Object)this.path);
    }

    private void writeXml(Document doc, OutputStream output) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(output);
        transformer.transform(source, result);
    }

    private void readConsulProperties() {
        MutablePropertySources srcs = this.env.getPropertySources();
        HashSet<String> allPropertyNames = new HashSet<String>();
        for (PropertySource src1 : srcs) {
            String[] allNames;
            if (!ConsulPropertySource.class.isAssignableFrom(src1.getClass()) || (allNames = ((ConsulPropertySource)src1).getPropertyNames()) == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("allNames array: {}", List.of(allNames));
            }
            for (String name : allNames) {
                String lowercaseName = name.toLowerCase();
                if (!lowercaseName.startsWith("logger") && !lowercaseName.startsWith("nifi")) continue;
                allPropertyNames.add(name);
            }
        }
        log.debug("All property names = {}", allPropertyNames);
        for (String property : allPropertyNames) {
            this.consulPropertiesMap.put(property, this.appEnv.getProperty(property));
        }
        log.debug("consulPropertiesMap map: {}", this.consulPropertiesMap);
    }

    public void buildCustomPropertiesFile() throws IOException {
        String fileName = this.path + "custom.properties";
        Map<String, String> combinedNifiProperties = this.getOrderedProperties(this.defaultCustomPropertiesFile);
        for (String consulKey : this.consulPropertiesMap.keySet()) {
            if (!SKIPPED_CUSTOM_PROPERTIES.contains(consulKey)) continue;
            combinedNifiProperties.put(consulKey, this.consulPropertiesMap.get(consulKey));
        }
        try (PrintWriter pw = new PrintWriter(new FileOutputStream(fileName));){
            for (String s : combinedNifiProperties.keySet()) {
                pw.print(s);
                pw.print("=");
                pw.println(combinedNifiProperties.get(s));
            }
        }
        log.info("Custom Properties file created : {}", (Object)fileName);
    }

    public void buildPropertiesFile() throws IOException {
        String fileName = this.path + "nifi.properties";
        Map<String, String> combinedNifiProperties = this.getOrderedProperties(this.defaultPropertiesFile);
        for (String string : this.consulPropertiesMap.keySet()) {
            if (!string.toLowerCase().startsWith("nifi.") || SKIPPED_CUSTOM_PROPERTIES.contains(string)) continue;
            combinedNifiProperties.put(string, this.consulPropertiesMap.get(string));
        }
        Map<String, String> nifiInternalProps = this.getOrderedProperties(this.internalPropertiesFile);
        for (String string : nifiInternalProps.keySet()) {
            combinedNifiProperties.put(string, nifiInternalProps.get(string));
        }
        if (log.isDebugEnabled()) {
            log.debug("combined nifi Properties: {}", combinedNifiProperties);
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("nifi.security.identity.mapping.pattern.dn");
        hashSet.add("nifi.security.identity.mapping.value.dn");
        hashSet.add("nifi.security.identity.mapping.transform.dn");
        for (String s : hashSet) {
            combinedNifiProperties.remove(s);
        }
        try (PrintWriter printWriter = new PrintWriter(new FileOutputStream(fileName));
             BufferedReader reader = new BufferedReader(new InputStreamReader(this.internalPropertiesCommentsFile.getInputStream()));){
            for (String s : combinedNifiProperties.keySet()) {
                printWriter.print(s);
                printWriter.print("=");
                printWriter.println(combinedNifiProperties.get(s));
            }
            String line = reader.readLine();
            while (line != null) {
                printWriter.println(line);
                line = reader.readLine();
            }
        }
        log.info("Nifi Properties file created : {}", (Object)fileName);
    }

    public Map<String, String> getOrderedProperties(Resource rs) throws IOException {
        final LinkedHashMap<String, String> mp = new LinkedHashMap<String, String>();
        try (InputStream in = rs.getInputStream();){
            new Properties(){

                @Override
                public synchronized Object put(Object key, Object value) {
                    return mp.put((String)key, (String)value);
                }
            }.load(in);
        }
        return mp;
    }

    @EventListener
    public void handleChangeEvent(EnvironmentChangeEvent event) {
        log.debug("Change event received for keys: {}", (Object)event.getKeys());
        this.readConsulProperties();
        try {
            this.buildLogbackXMLFile();
        }
        catch (Exception e) {
            log.error("Exception while processing change event from consul", (Throwable)e);
        }
    }

    static {
        SKIPPED_CUSTOM_PROPERTIES.add("nifi.http-auth-proxying-disabled-schemes");
        SKIPPED_CUSTOM_PROPERTIES.add("nifi.http-auth-tunneling-disabled-schemes");
        SKIPPED_CUSTOM_PROPERTIES.add("nifi.cluster.base-node-count");
        SKIPPED_CUSTOM_PROPERTIES.add("nifi.cluster.start-mode");
        SKIPPED_CUSTOM_PROPERTIES.add("nifi.nifi-registry.nar-provider-enabled");
        SKIPPED_CUSTOM_PROPERTIES.add("nifi.conf.clean-db-repository");
        SKIPPED_CUSTOM_PROPERTIES.add("nifi.conf.clean-configuration");
        SKIPPED_CUSTOM_PROPERTIES.add("nifi.extensions.retry.attempts");
        SKIPPED_CUSTOM_PROPERTIES.add("nifi.extensions.retry.delay");
    }
}

