/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.cloud.nifi.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Component
public class XmlConfigValidator {
    private static final Logger log = LoggerFactory.getLogger(XmlConfigValidator.class);
    @Value(value="${config.file.path}")
    private String path;
    @Value(value="${config.main.path}")
    private String mainConfigDirectoryPath;
    @Value(value="${config.restore.path}")
    private String restoreDirectoryPath;
    private String mainAuthorizationsFilePath;
    private String mainUsersFilePath;

    public void validate() throws IOException, ParserConfigurationException {
        if (this.shouldSkipValidation()) {
            return;
        }
        log.info("Restore directory path: {}", (Object)this.restoreDirectoryPath);
        this.mainAuthorizationsFilePath = this.mainConfigDirectoryPath + "authorizations.xml";
        this.mainUsersFilePath = this.mainConfigDirectoryPath + "users.xml";
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd_hhmmss");
        String dateString = formatter.format((Object)date);
        if (this.validateMissingConfig(dateString)) {
            return;
        }
        this.validateWellFormedXmlConfig(dateString);
    }

    private boolean shouldSkipValidation() throws IOException {
        String cleanConf = System.getenv("NIFI_CONF_PV_CLEAN_CONF");
        if ("true".equals(cleanConf)) {
            log.info("NIFI_CONF_PV_CLEAN_CONF set to true, skipping validation");
            return true;
        }
        return false;
    }

    private void validateWellFormedXmlConfig(String dateString) throws ParserConfigurationException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Boolean isAuthorizationsFileValid = this.checkIfXmlIsValid(this.mainAuthorizationsFilePath, builder);
        Boolean isUsersFileValid = this.checkIfXmlIsValid(this.mainUsersFilePath, builder);
        if (isAuthorizationsFileValid.booleanValue() && isUsersFileValid.booleanValue()) {
            log.info("Deleting config from restore directory, as main config's are valid");
            this.deleteRestoreConfig();
            return;
        }
        if (!isAuthorizationsFileValid.booleanValue() && !isUsersFileValid.booleanValue()) {
            this.renameFile(this.mainAuthorizationsFilePath, this.mainAuthorizationsFilePath + ".bk_corrupted_" + dateString);
            this.renameFile(this.mainUsersFilePath, this.mainUsersFilePath + ".bk_corrupted_" + dateString);
            this.copyRestoreConfigToMain();
        } else if (!isAuthorizationsFileValid.booleanValue()) {
            this.renameFile(this.mainAuthorizationsFilePath, this.mainAuthorizationsFilePath + ".bk_corrupted_" + dateString);
            this.renameFile(this.mainUsersFilePath, this.mainUsersFilePath + ".bk_" + dateString);
            this.copyRestoreConfigToMain();
        } else {
            this.renameFile(this.mainUsersFilePath, this.mainUsersFilePath + ".bk_corrupted_" + dateString);
            this.renameFile(this.mainAuthorizationsFilePath, this.mainAuthorizationsFilePath + ".bk_" + dateString);
            this.copyRestoreConfigToMain();
        }
    }

    private boolean validateMissingConfig(String dateString) throws IOException {
        Boolean mainAuthFileExists = new File(this.mainAuthorizationsFilePath).exists();
        Boolean mainUsersFileExists = new File(this.mainUsersFilePath).exists();
        if (!mainAuthFileExists.booleanValue() && !mainUsersFileExists.booleanValue()) {
            this.copyRestoreConfigToMain();
            return true;
        }
        if (!mainAuthFileExists.booleanValue()) {
            this.renameFile(this.mainUsersFilePath, this.mainUsersFilePath + ".bk_" + dateString);
            this.copyRestoreConfigToMain();
            return true;
        }
        if (!mainUsersFileExists.booleanValue()) {
            this.renameFile(this.mainAuthorizationsFilePath, this.mainAuthorizationsFilePath + ".bk_" + dateString);
            this.copyRestoreConfigToMain();
            return true;
        }
        return false;
    }

    private boolean checkIfXmlIsValid(String xmlFilePath, DocumentBuilder builder) throws IOException {
        try {
            builder.parse(new InputSource(xmlFilePath));
        }
        catch (SAXException ex) {
            log.error("Error when parsing xml: " + xmlFilePath, (Throwable)ex);
            return false;
        }
        return true;
    }

    private void deleteRestoreConfig() {
        this.deleteFile(this.restoreDirectoryPath + "authorizations.xml");
        this.deleteFile(this.restoreDirectoryPath + "users.xml");
    }

    private void deleteFile(String filePath) {
        File fileToDelete = new File(filePath);
        log.info("Deleting file {} ", (Object)filePath);
        fileToDelete.delete();
    }

    private void renameFile(String sourcePath, String destPath) {
        File oldFile = new File(sourcePath);
        File newFile = new File(destPath);
        log.info("Renaming file {} to {} ", (Object)sourcePath, (Object)destPath);
        oldFile.renameTo(newFile);
    }

    private void copyRestoreConfigToMain() throws IOException {
        File srcAuth = new File(this.restoreDirectoryPath + "authorizations.xml");
        File srcUser = new File(this.restoreDirectoryPath + "users.xml");
        if (srcAuth.exists() && srcUser.exists()) {
            File destAuth = new File(this.mainAuthorizationsFilePath);
            log.info("Copying file {} to {} ", (Object)srcAuth.getAbsolutePath(), (Object)destAuth.getAbsolutePath());
            Files.copy(srcAuth.toPath(), destAuth.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File destUser = new File(this.mainUsersFilePath);
            log.info("Copying file {} to {} ", (Object)srcUser.getAbsolutePath(), (Object)destUser.getAbsolutePath());
            Files.copy(srcUser.toPath(), destUser.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

