/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.nifi.processors;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.qubership.nifi.NiFiUtils;
import org.qubership.nifi.service.PreparedStatementProvider;

public abstract class AbstractQueryDatabaseToJson
extends AbstractProcessor {
    public static final PropertyDescriptor DBCP_SERVICE = new PropertyDescriptor.Builder().name("Database Connection Pooling Service").description("The Controller Service that is used to obtain a connection to the database.").required(true).identifiesControllerService(DBCPService.class).build();
    public static final PropertyDescriptor PS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().name("prepared-statement-provider-service").displayName("Prepared Statement Provider").description("The Controller Service that is used to create a prepared statement.").required(true).identifiesControllerService(PreparedStatementProvider.class).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Successfully created FlowFile from SQL query result set.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("This relationship is only used when SQL query execution (using an incoming FlowFile) failed. The incoming FlowFile will be penalized and routed to this relationship. If no incoming connection(s) are specified, this relationship is unused.").build();
    public static final String EXTRACTION_ERROR = "extraction.error";
    private PreparedStatementProvider statementProducer;
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> propDescriptors;

    public AbstractQueryDatabaseToJson() {
        HashSet<Relationship> rel = new HashSet<Relationship>();
        rel.add(REL_SUCCESS);
        rel.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(rel);
        ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        pds.add(DBCP_SERVICE);
        pds.add(PS_PROVIDER_SERVICE);
        this.propDescriptors = Collections.unmodifiableList(pds);
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws Exception {
        this.statementProducer = (PreparedStatementProvider)context.getProperty(PS_PROVIDER_SERVICE).asControllerService(PreparedStatementProvider.class);
    }

    protected FlowFile writeResultToFlowFile(JsonNode value, ProcessSession session, FlowFile batchFlowFile) {
        return session.write(batchFlowFile, out -> NiFiUtils.MAPPER.writeValue(out, (Object)value));
    }

    protected Connection createConnection(ProcessContext context) {
        return this.getDbcpService(context).getConnection(Collections.emptyMap());
    }

    protected DBCPService getDbcpService(ProcessContext context) {
        return (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
    }

    protected PreparedStatementProvider getStatementProducer() {
        return this.statementProducer;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propDescriptors;
    }
}

