/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.nifi.reporting;

import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.reporting.ReportingTask;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public abstract class AbstractPrometheusReportingTask
extends AbstractReportingTask
implements ReportingTask {
    protected Server httpServer;
    protected PrometheusMeterRegistry meterRegistry;
    protected List<PropertyDescriptor> propertyDescriptors;
    protected String namespace;
    protected String hostname;
    protected String instance;
    protected int port;
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("port").displayName("Server Port").description("").required(true).defaultValue("9192").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();

    protected List<PropertyDescriptor> initProperties() {
        ArrayList<PropertyDescriptor> prop = new ArrayList<PropertyDescriptor>();
        prop.add(PORT);
        return prop;
    }

    protected String getNamespace() {
        return System.getenv("NAMESPACE");
    }

    protected String getHostname() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            this.getLogger().warn("Error while getting host name {}", new Object[]{ex.getLocalizedMessage()}, (Throwable)ex);
            return "cloud-data-migration-nifi";
        }
    }

    @OnScheduled
    public void onScheduled(ConfigurationContext context) {
        this.meterRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        this.port = context.getProperty(PORT).asInteger();
        this.namespace = this.getNamespace();
        this.hostname = this.getHostname();
        this.instance = this.namespace + "_" + this.hostname;
        try {
            this.httpServer = new Server(this.port);
            ServletContextHandler servletContextHandler = new ServletContextHandler();
            servletContextHandler.setContextPath("/");
            servletContextHandler.addServlet(new ServletHolder((Servlet)new PrometheusServlet()), "/metrics");
            this.httpServer.setHandler((Handler)servletContextHandler);
            this.httpServer.start();
        }
        catch (Exception e) {
            this.getLogger().error("Error while starting Jetty server {}", (Throwable)e);
            throw new ProcessException("Error while starting Jetty server {}", (Throwable)e);
        }
    }

    protected void init(ReportingInitializationContext config) {
        List<PropertyDescriptor> prop = this.initProperties();
        this.propertyDescriptors = Collections.unmodifiableList(prop);
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @OnStopped
    public void onStopped() throws Exception {
        if (this.httpServer != null) {
            this.getLogger().info("Jetty server is stopping");
            this.httpServer.stop();
        }
    }

    @OnShutdown
    public void onShutDown() throws Exception {
        if (this.httpServer != null) {
            this.getLogger().info("Jetty server is shutting down");
            this.httpServer.stop();
        }
    }

    public void onTrigger(ReportingContext context) {
        this.registerMetrics(context);
    }

    public abstract void registerMetrics(ReportingContext var1);

    public PrometheusMeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public String getInstance() {
        return this.instance;
    }

    public int getPort() {
        return this.port;
    }

    protected class PrometheusServlet
    extends HttpServlet {
        protected PrometheusServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            resp.setStatus(200);
            resp.setContentType("text/plain; version=0.0.4; charset=utf-8");
            try (PrintWriter writer = resp.getWriter();){
                TextFormat.write004((Writer)writer, (Enumeration)AbstractPrometheusReportingTask.this.meterRegistry.getPrometheusRegistry().metricFamilySamples());
                ((Writer)writer).flush();
            }
            catch (IOException e) {
                AbstractPrometheusReportingTask.this.getLogger().error("Error while scraping metrics {}", (Throwable)e);
                throw new ProcessException("Error while scraping metrics {}", (Throwable)e);
            }
        }
    }
}

