/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.nifi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;

public final class NiFiUtils {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    private NiFiUtils() {
    }

    public static JsonNode readJsonNodeFromFlowFile(ProcessSession session, FlowFile inputFlowFile) {
        AtomicReference result = new AtomicReference();
        session.read(inputFlowFile, in -> result.set(MAPPER.readTree(in)));
        return (JsonNode)result.get();
    }

    public static <T> T readJsonNodeFromFlowFile(ProcessSession session, FlowFile inputFlowFile, Class<T> clazz) {
        AtomicReference result = new AtomicReference();
        session.read(inputFlowFile, in -> result.set(MAPPER.readValue(in, clazz)));
        return (T)result.get();
    }

    public static <T> T readJsonNodeFromFlowFile(ProcessSession session, FlowFile inputFlowFile, TypeReference<T> typeReference) {
        AtomicReference result = new AtomicReference();
        session.read(inputFlowFile, in -> result.set(MAPPER.readValue(in, typeReference)));
        return (T)result.get();
    }

    public static String extractContent(ProcessSession session, FlowFile flowFile) {
        String string;
        block8: {
            InputStream flowStream = session.read(flowFile);
            try {
                string = IOUtils.toString((InputStream)flowStream, (Charset)StandardCharsets.UTF_8);
                if (flowStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (flowStream != null) {
                        try {
                            flowStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProcessException("Can't extract content form the FlowFile", (Throwable)e);
                }
            }
            flowStream.close();
        }
        return string;
    }

    public static String getEvaluatedValue(PropertyDescriptor descriptor, ProcessContext context, FlowFile flowFile) {
        return context.getProperty(descriptor).evaluateAttributeExpressions(flowFile).getValue();
    }

    public static String getEvaluatedValue(PropertyDescriptor descriptor, ProcessContext context) {
        return context.getProperty(descriptor).evaluateAttributeExpressions().getValue();
    }

    public static FlowFile createFlowFileInListFormat(ProcessSession session, Map<String, String> attributes, Collection<String> sourceIdCollection) {
        FlowFile ff = session.write(session.create(), out -> MAPPER.writeValue(out, (Object)NiFiUtils.transformToListFormat(sourceIdCollection)));
        return session.putAllAttributes(ff, attributes);
    }

    private static JsonNode transformToListFormat(Collection<String> sourceIdSet) {
        ArrayNode arrayNode = MAPPER.createArrayNode();
        sourceIdSet.forEach(sourceId -> arrayNode.add((JsonNode)MAPPER.createObjectNode().put("source_id", sourceId)));
        return arrayNode;
    }
}

